/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.mastercontroller;

import com.xceptance.xlt.agent.unipro.CompositeFunction;
import com.xceptance.xlt.agentcontroller.AgentController;
import com.xceptance.xlt.agentcontroller.TestUserConfiguration;
import com.xceptance.xlt.api.util.XltLogger;
import com.xceptance.xlt.mastercontroller.TestCaseLoadProfileConfiguration;
import com.xceptance.xlt.mastercontroller.TestDeployment;
import com.xceptance.xlt.mastercontroller.TestLoadProfileConfiguration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;

public class TestDeployer {
    private static final Comparator<String> agentIdComparator = (s1, s2) -> StringUtils.reverse((String)s1).compareTo(StringUtils.reverse((String)s2));
    private final Map<String, AgentController> agentControllers;
    private static int INSTANCE_NO = 0;

    public TestDeployer(Map<String, AgentController> agentControllers) {
        this.agentControllers = agentControllers;
    }

    private void validateAgentControllerMap() {
        if (this.agentControllers == null || this.agentControllers.isEmpty()) {
            throw new IllegalArgumentException("Must specify a valid agent controller map.");
        }
        for (AgentController ac : this.agentControllers.values()) {
            if (ac.getWeight() == 0) {
                throw new IllegalArgumentException("Agent controller '" + ac.getName() + "' has zero weight.");
            }
            if (ac.getAgentIDs().isEmpty()) {
                throw new IllegalArgumentException("Agent controller '" + ac.getName() + "' has no agent IDs.");
            }
            if (ac.getAgentCount() == 0) {
                throw new IllegalArgumentException("Agent controller '" + ac.getName() + "' has no agents.");
            }
            if (ac.getAgentCount() == ac.getAgentIDs().size()) continue;
            throw new IllegalArgumentException("Number of agents and number of agent IDs of agent controller '" + ac.getName() + "' differ.");
        }
    }

    public TestDeployment createTestDeployment(TestLoadProfileConfiguration loadProfile) {
        this.validateAgentControllerMap();
        PriorityQueue<ControllerEntry> queue = new PriorityQueue<ControllerEntry>();
        PriorityQueue<ControllerEntry> queueCP = new PriorityQueue<ControllerEntry>();
        HashSet<String> agentIDs = new HashSet<String>();
        double totalWeight = 0.0;
        double totalWeightCP = 0.0;
        for (AgentController agentController : this.agentControllers.values()) {
            Set<String> agent_ids = agentController.getAgentIDs();
            int weight = agentController.getWeight();
            agentIDs.addAll(agent_ids);
            if (agentController.runsClientPerformanceTests()) {
                queueCP.add(new ControllerEntry(weight, agent_ids, true));
                totalWeightCP += (double)weight;
                continue;
            }
            queue.add(new ControllerEntry(weight, agent_ids, false));
            totalWeight += (double)weight;
        }
        HashMap<String, Double> agentWeights = new HashMap<String, Double>();
        for (AgentController agentController : this.agentControllers.values()) {
            double total_weight = agentController.runsClientPerformanceTests() ? totalWeightCP : totalWeight;
            double agentWeight = (double)agentController.getWeight() / total_weight / (double)agentController.getAgentCount();
            for (String agentID : agentController.getAgentIDs()) {
                agentWeights.put(agentID, agentWeight);
            }
        }
        TestDeployment testDeployment = new TestDeployment(agentIDs);
        HashMap<String, Map<String, Integer>> deploymentPlan = new HashMap<String, Map<String, Integer>>();
        HashMap<String, List<TestUserConfiguration>> usersPerTestCase = new HashMap<String, List<TestUserConfiguration>>();
        GlobalUserFunction sched = new GlobalUserFunction();
        for (TestCaseLoadProfileConfiguration config : loadProfile.getLoadTestConfiguration()) {
            PriorityQueue<ControllerEntry> q;
            List<TestUserConfiguration> userConfigs = this.scheduleUsers(config);
            String testCaseName = config.getUserName();
            usersPerTestCase.put(testCaseName, userConfigs);
            sched.register(config.getUserName(), config.getNumberOfUsers());
            int nbUsers = userConfigs.size();
            boolean isCPTest = config.isCPTest();
            PriorityQueue<ControllerEntry> priorityQueue = q = isCPTest ? queueCP : queue;
            if (q == null) {
                throw new RuntimeException("No controller available. Please check configuration.");
            }
            for (int i = 0; i < nbUsers; ++i) {
                ControllerEntry entry = (ControllerEntry)q.poll();
                AgentEntry aEntry = entry.getLightestAgent();
                entry.incUsers(testCaseName, aEntry);
                HashMap<String, Integer> assignedUsers = (HashMap<String, Integer>)deploymentPlan.get(aEntry.agentID);
                if (assignedUsers == null) {
                    assignedUsers = new HashMap<String, Integer>();
                    deploymentPlan.put(aEntry.agentID, assignedUsers);
                }
                int usersSoFar = TestDeployer.zeroIfNullElseIntValue((Integer)assignedUsers.get(testCaseName));
                assignedUsers.put(testCaseName, usersSoFar + 1);
                q.add(entry);
            }
        }
        Map<String, Map<String, Object>> agentSpecificUsers = this.computeAgentSpecificUsers(sched, deploymentPlan);
        for (Map.Entry e : deploymentPlan.entrySet()) {
            String agentID;
            agentID = (String)e.getKey();
            Map assignedUsers = (Map)e.getValue();
            List<TestUserConfiguration> userList = testDeployment.getUserList(agentID);
            for (String testCaseName : assignedUsers.keySet()) {
                int nbUsers = (Integer)assignedUsers.get(testCaseName);
                List subList = ((List)usersPerTestCase.get(testCaseName)).subList(0, nbUsers);
                for (TestUserConfiguration user : subList) {
                    userList.add(user);
                }
                subList.clear();
            }
        }
        this.determineAgentCountAndIndex(testDeployment, agentWeights, agentSpecificUsers);
        this.finalizeDeployment(testDeployment, this.checkDeployedUserCount(testDeployment));
        return testDeployment;
    }

    private List<TestUserConfiguration> scheduleUsers(TestCaseLoadProfileConfiguration config) {
        int i;
        ArrayList<TestUserConfiguration> userList = new ArrayList<TestUserConfiguration>();
        String userName = config.getUserName();
        String testCaseClassName = config.getTestCaseClassName();
        int iterations = config.getNumberOfIterations();
        int initialDelay = config.getInitialDelay() * 1000;
        int warmUpPeriod = config.getWarmUpPeriod() * 1000;
        int measurementPeriod = config.getMeasurementPeriod() * 1000;
        int shutdownPeriod = config.getShutdownPeriod() * 1000;
        int[][] arrivalRates = config.getArrivalRate();
        int[][] users = config.getNumberOfUsers();
        int userCount = 0;
        for (i = 0; i < users.length; ++i) {
            userCount = Math.max(userCount, users[i][1]);
        }
        for (i = 0; i < userCount; ++i) {
            TestUserConfiguration userConfig = new TestUserConfiguration();
            userList.add(userConfig);
            userConfig.setInitialDelay(initialDelay);
            userConfig.setMeasurementPeriod(measurementPeriod);
            userConfig.setNumberOfIterations(iterations);
            userConfig.setNumberOfUsers(userCount);
            userConfig.setArrivalRates(arrivalRates);
            userConfig.setShutdownPeriod(shutdownPeriod);
            userConfig.setTestCaseClassName(testCaseClassName);
            userConfig.setUserName(userName);
            userConfig.setUsers(users);
            userConfig.setWarmUpPeriod(warmUpPeriod);
            userConfig.setInstance(i);
        }
        if (XltLogger.runTimeLogger.isInfoEnabled()) {
            XltLogger.runTimeLogger.info(((Object)userList).toString());
        }
        return userList;
    }

    private int checkDeployedUserCount(TestDeployment deployment) {
        int totalUsers = 0;
        for (List<TestUserConfiguration> userList : deployment.getAllUserLists()) {
            totalUsers += userList.size();
        }
        return totalUsers;
    }

    private void finalizeDeployment(TestDeployment deployment, int totalUsers) {
        int absoluteUserNumber = 0;
        for (List<TestUserConfiguration> userList : deployment.getAllUserLists()) {
            for (TestUserConfiguration testUserConfiguration : userList) {
                testUserConfiguration.setAbsoluteUserNumber(absoluteUserNumber++);
                testUserConfiguration.setTotalUserCount(totalUsers);
            }
        }
    }

    private void determineAgentCountAndIndex(TestDeployment deployment, Map<String, Double> agentWeights, Map<String, Map<String, Object>> agentSpecificUsers) {
        HashMap<String, HashSet<String>> agentsPerTestCase = new HashMap<String, HashSet<String>>();
        for (String string : deployment.getAgentIDs()) {
            for (TestUserConfiguration user : deployment.getUserList(string)) {
                String testCaseName = user.getUserName();
                HashSet<String> mappedAgentIDs = (HashSet<String>)agentsPerTestCase.get(testCaseName);
                if (mappedAgentIDs == null) {
                    mappedAgentIDs = new HashSet<String>();
                    agentsPerTestCase.put(testCaseName, mappedAgentIDs);
                }
                mappedAgentIDs.add(string);
            }
        }
        for (Map.Entry entry : agentsPerTestCase.entrySet()) {
            String testCaseName = (String)entry.getKey();
            ArrayList<String> agentsRunningTest = new ArrayList<String>((Collection)entry.getValue());
            agentsRunningTest.sort(agentIdComparator);
            int agentCount = agentsRunningTest.size();
            double[] weightFunction = new double[agentCount];
            int i = 0;
            for (String agentID : agentsRunningTest) {
                weightFunction[i] = agentWeights.get(agentID);
                ++i;
            }
            int agentIndex = 0;
            for (String agentID : agentsRunningTest) {
                for (TestUserConfiguration user : deployment.getUserList(agentID)) {
                    if (!user.getUserName().equals(testCaseName)) continue;
                    user.setWeightFunction(weightFunction);
                    user.setAgentIndex(agentIndex);
                    user.setUsers((int[][])agentSpecificUsers.get(agentID).get(testCaseName));
                }
                ++agentIndex;
            }
        }
    }

    private Map<String, Map<String, Object>> computeAgentSpecificUsers(GlobalUserFunction gUserFunc, Map<String, Map<String, Integer>> deploymentPlan) {
        LinkedList<String> userTypes = gUserFunc.userTypes;
        HashMap<String, Map<String, Object>> agentSpecificUsers = new HashMap<String, Map<String, Object>>();
        TreeSet<ControllerEntry> controllers = new TreeSet<ControllerEntry>();
        for (AgentController agentController : this.agentControllers.values()) {
            controllers.add(new ControllerEntry(agentController.getWeight(), agentController.getAgentIDs(), agentController.runsClientPerformanceTests()));
            for (String agentID : agentController.getAgentIDs()) {
                if (agentSpecificUsers.containsKey(agentID)) continue;
                HashMap agentUsers = new HashMap();
                agentSpecificUsers.put(agentID, agentUsers);
            }
        }
        HashMap<String, Integer> lastUsers = new HashMap<String, Integer>();
        for (int time : gUserFunc.getSamplingPoints()) {
            Map<String, Double> curUsers = gUserFunc.getUsersAt(time);
            for (String userType : userTypes) {
                int[][] tmp;
                int[][] testUsersOfAgent;
                Map agentUsers;
                AgentEntry agent;
                ControllerEntry entry;
                int i;
                ArrayList<ControllerEntry> dummy = new ArrayList<ControllerEntry>();
                ControllerEntry controller = null;
                while ((controller = (ControllerEntry)controllers.pollFirst()) != null) {
                    controller._currentUser = userType;
                    dummy.add(controller);
                }
                controllers.addAll(dummy);
                double nbUsers = curUsers.get(userType);
                int last = TestDeployer.zeroIfNullElseIntValue((Integer)lastUsers.get(userType));
                int newUsers = nbUsers > (double)last ? (int)Math.floor(nbUsers) : (int)Math.ceil(nbUsers);
                int userDiff = newUsers - last;
                lastUsers.put(userType, newUsers);
                ArrayList<ControllerEntry> workList = new ArrayList<ControllerEntry>();
                if (userDiff < 0) {
                    for (i = userDiff; i < 0; ++i) {
                        entry = null;
                        agent = null;
                        while (true) {
                            if ((entry = (ControllerEntry)controllers.pollLast()) == null) {
                                throw new RuntimeException("No controller available");
                            }
                            agent = entry.getHeaviestAgent(userType);
                            if (agent != null) break;
                            workList.add(entry);
                        }
                        entry.decUsers(userType, agent);
                        controllers.add(entry);
                        agentUsers = (Map)agentSpecificUsers.get(agent.agentID);
                        testUsersOfAgent = (int[][])agentUsers.get(userType);
                        if (testUsersOfAgent == null) {
                            if (time == 0) {
                                testUsersOfAgent = new int[1][2];
                            } else {
                                testUsersOfAgent = new int[2][2];
                                testUsersOfAgent[0][1] = 0;
                                testUsersOfAgent[0][0] = 0;
                            }
                            agentUsers.put(userType, testUsersOfAgent);
                        } else if (testUsersOfAgent[testUsersOfAgent.length - 1][0] != time) {
                            tmp = new int[testUsersOfAgent.length + 1][2];
                            System.arraycopy(testUsersOfAgent, 0, tmp, 0, testUsersOfAgent.length);
                            testUsersOfAgent = tmp;
                            agentUsers.put(userType, testUsersOfAgent);
                        }
                        testUsersOfAgent[testUsersOfAgent.length - 1][0] = time;
                        testUsersOfAgent[testUsersOfAgent.length - 1][1] = agent.users.get(userType);
                    }
                } else {
                    for (i = 0; i < userDiff; ++i) {
                        entry = null;
                        agent = null;
                        while (true) {
                            if ((entry = (ControllerEntry)controllers.pollFirst()) == null) {
                                throw new RuntimeException("No controller available");
                            }
                            agent = entry.getLightestAgent(userType, deploymentPlan);
                            if (agent != null) break;
                            workList.add(entry);
                        }
                        entry.incUsers(userType, agent);
                        controllers.add(entry);
                        agentUsers = (Map)agentSpecificUsers.get(agent.agentID);
                        testUsersOfAgent = (int[][])agentUsers.get(userType);
                        if (testUsersOfAgent == null) {
                            if (time == 0) {
                                testUsersOfAgent = new int[1][2];
                            } else {
                                testUsersOfAgent = new int[2][2];
                                testUsersOfAgent[0][1] = 0;
                                testUsersOfAgent[0][0] = 0;
                            }
                            agentUsers.put(userType, testUsersOfAgent);
                        } else if (testUsersOfAgent[testUsersOfAgent.length - 1][0] != time) {
                            tmp = new int[testUsersOfAgent.length + 1][2];
                            System.arraycopy(testUsersOfAgent, 0, tmp, 0, testUsersOfAgent.length);
                            testUsersOfAgent = tmp;
                            agentUsers.put(userType, testUsersOfAgent);
                        }
                        testUsersOfAgent[testUsersOfAgent.length - 1][0] = time;
                        testUsersOfAgent[testUsersOfAgent.length - 1][1] = agent.users.get(userType);
                    }
                }
                controllers.addAll(workList);
            }
        }
        if (XltLogger.runTimeLogger.isInfoEnabled()) {
            StringBuilder stringBuilder = new StringBuilder();
            for (Map.Entry e : agentSpecificUsers.entrySet()) {
                stringBuilder.append("agent : ").append((String)e.getKey());
                for (Map.Entry e2 : ((Map)e.getValue()).entrySet()) {
                    stringBuilder.append("{ testCase : ").append((String)e2.getKey());
                    int[][] users = (int[][])e2.getValue();
                    for (int i = 0; i < users.length; ++i) {
                        if (i > 0) {
                            stringBuilder.append(",");
                        }
                        stringBuilder.append("[").append(users[i][0]).append(",").append(users[i][1]).append("]");
                    }
                    stringBuilder.append(" } ");
                }
                stringBuilder.append("\n");
            }
            if (XltLogger.runTimeLogger.isInfoEnabled()) {
                XltLogger.runTimeLogger.info("agentSpecificUsers:\n" + stringBuilder.toString());
            }
        }
        return agentSpecificUsers;
    }

    private static int zeroIfNullElseIntValue(Integer theInteger) {
        return theInteger == null ? 0 : theInteger;
    }

    private static int boolCompare(boolean aBoolean, boolean bBoolean) {
        int result = aBoolean == bBoolean ? 0 : (bBoolean ? -1 : 1);
        return result;
    }

    private static class GlobalUserFunction {
        private final HashMap<String, CompositeFunction> userFunctions = new HashMap();
        private final LinkedList<String> userTypes = new LinkedList();
        private final TreeSet<Integer> samplings = new TreeSet();

        private GlobalUserFunction() {
        }

        private void register(String userType, int[][] userCount) {
            CompositeFunction func = new CompositeFunction(userCount);
            this.userFunctions.put(userType, func);
            this.userTypes.add(userType);
            this.addSamplings(userCount, func);
        }

        private int[] getSamplingPoints() {
            int[] sPoints = new int[2 * this.samplings.size()];
            int i = 0;
            for (int si : this.samplings) {
                if (this.isSpecialPoint(si) && i != 0 && sPoints[i - 1] != si - 1) {
                    sPoints[i++] = si - 1;
                }
                sPoints[i++] = si;
            }
            int[] iArr = new int[i];
            System.arraycopy(sPoints, 0, iArr, 0, i);
            return iArr;
        }

        private boolean isSpecialPoint(int x) {
            for (CompositeFunction cf : this.userFunctions.values()) {
                if (!cf.isSpecialPoint(x)) continue;
                return true;
            }
            return false;
        }

        private Map<String, Double> getUsersAt(int time) {
            HashMap<String, Double> users = new HashMap<String, Double>();
            for (String userType : this.userTypes) {
                CompositeFunction function = this.userFunctions.get(userType);
                users.put(userType, function.calculateY(time));
            }
            return users;
        }

        private void addSamplings(int[][] userCount, CompositeFunction func) {
            int start = userCount[0][0];
            int end = userCount[userCount.length - 1][0];
            int last = 0;
            for (int time = start; time <= end; ++time) {
                int totalUsers;
                double users = func.calculateY(time);
                int n = totalUsers = users > (double)last ? (int)Math.floor(users) : (int)Math.ceil(users);
                if (last != totalUsers) {
                    this.samplings.add(time);
                }
                last = totalUsers;
            }
        }
    }

    private static class ControllerEntry
    implements Comparable<ControllerEntry> {
        private final int instanceNo = INSTANCE_NO++;
        private int users;
        private final double weight;
        private final List<AgentEntry> agents;
        private final boolean runsCPTests;
        private String _currentUser = "";
        private final Map<String, Integer> countOfEachUserType = new HashMap<String, Integer>();

        private ControllerEntry(double weight, Iterable<String> agentIDs, boolean runsCPTests) {
            this.weight = weight;
            this.agents = new ArrayList<AgentEntry>();
            for (String agentID : agentIDs) {
                this.agents.add(new AgentEntry(agentID));
            }
            this.runsCPTests = runsCPTests;
        }

        @Override
        public int compareTo(ControllerEntry o) {
            int result = TestDeployer.boolCompare(this.runsCPTests, o.runsCPTests);
            if (result == 0 && (result = this.getWeightedUsers().compareTo(o.getWeightedUsers())) == 0 && (result = Double.compare(o.weight, this.weight)) == 0) {
                Integer thisUsers = this.countOfEachUserType.get(this._currentUser);
                Integer otherUsers = o.countOfEachUserType.get(this._currentUser);
                if (thisUsers != null && otherUsers != null) {
                    result = thisUsers.compareTo(otherUsers);
                    if (result == 0) {
                        result = Integer.valueOf(this.instanceNo).compareTo(o.instanceNo);
                    }
                } else {
                    result = Integer.valueOf(this.instanceNo).compareTo(o.instanceNo);
                }
            }
            return result;
        }

        private Double getWeightedUsers() {
            return (double)this.users / this.weight;
        }

        private void incUsers(String userType, AgentEntry aEntry) {
            aEntry.inc(userType);
            ++this.users;
            this.countOfEachUserType.put(userType, TestDeployer.zeroIfNullElseIntValue(this.countOfEachUserType.get(userType)) + 1);
        }

        private void decUsers(String userType, AgentEntry aEntry) {
            aEntry.dec(userType);
            --this.users;
            this.countOfEachUserType.put(userType, this.countOfEachUserType.get(userType) - 1);
        }

        private AgentEntry getLightestAgent() {
            AgentEntry agent = null;
            for (AgentEntry aEntry : this.agents) {
                if (agent != null && agent.userCount <= aEntry.userCount) continue;
                agent = aEntry;
            }
            return agent;
        }

        private AgentEntry getLightestAgent(String userType, Map<String, Map<String, Integer>> deploymentPlan) {
            ArrayList<AgentEntry> agentsSortedByUserCount = new ArrayList<AgentEntry>(this.agents);
            Collections.sort(agentsSortedByUserCount);
            AgentEntry agent = null;
            for (AgentEntry aEntry : agentsSortedByUserCount) {
                Map<String, Integer> assignedUsers;
                int maxUsers;
                if (agent != null && agent.userCount < aEntry.userCount) break;
                int aEntryUsers = TestDeployer.zeroIfNullElseIntValue(aEntry.users.get(userType));
                if (aEntryUsers >= (maxUsers = (assignedUsers = deploymentPlan.get(aEntry.agentID)) == null ? 0 : TestDeployer.zeroIfNullElseIntValue(assignedUsers.get(userType))) || agent != null && aEntryUsers >= TestDeployer.zeroIfNullElseIntValue(agent.users.get(userType))) continue;
                agent = aEntry;
            }
            return agent;
        }

        private AgentEntry getHeaviestAgent(String userType) {
            ArrayList<AgentEntry> agentsSortedByUserCount = new ArrayList<AgentEntry>(this.agents);
            Collections.sort(agentsSortedByUserCount);
            AgentEntry agent = null;
            int agentSize = agentsSortedByUserCount.size();
            for (int i = agentSize - 1; i >= 0; --i) {
                AgentEntry aEntry = (AgentEntry)agentsSortedByUserCount.get(i);
                if (agent != null && agent.userCount > aEntry.userCount) break;
                int aEntryUsers = TestDeployer.zeroIfNullElseIntValue(aEntry.users.get(userType));
                if (aEntryUsers <= 0 || agent != null && aEntryUsers <= TestDeployer.zeroIfNullElseIntValue(agent.users.get(userType))) continue;
                agent = aEntry;
            }
            return agent;
        }
    }

    private static class AgentEntry
    implements Comparable<AgentEntry> {
        private final String agentID;
        private final Map<String, Integer> users = new HashMap<String, Integer>();
        private int userCount;

        private AgentEntry(String agentID) {
            this.agentID = agentID;
        }

        private void inc(String userType) {
            int curUsers = TestDeployer.zeroIfNullElseIntValue(this.users.get(userType));
            this.users.put(userType, curUsers + 1);
            ++this.userCount;
        }

        private void dec(String userType) {
            int curUsers = TestDeployer.zeroIfNullElseIntValue(this.users.get(userType));
            if (curUsers == 0) {
                throw new RuntimeException("");
            }
            this.users.put(userType, curUsers - 1);
            --this.userCount;
        }

        @Override
        public int compareTo(AgentEntry o) {
            return Integer.valueOf(this.userCount).compareTo(o.userCount);
        }
    }
}

