/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.report.mergerules;

import com.xceptance.common.collection.LRUFastHashMap;
import com.xceptance.common.lang.ThrowableUtils;
import com.xceptance.common.util.RegExUtils;
import com.xceptance.xlt.api.engine.RequestData;
import com.xceptance.xlt.report.mergerules.AbstractRequestFilter;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractPatternRequestFilter
extends AbstractRequestFilter {
    private final LRUFastHashMap<CharSequence, MatchResult> cache;
    private static final MatchResult NULL = Pattern.compile(".*").matcher("null").toMatchResult();
    private final Matcher matcher;
    private final boolean isExclude;

    public AbstractPatternRequestFilter(String typeCode, String regex) {
        this(typeCode, regex, false, 100);
    }

    public AbstractPatternRequestFilter(String typeCode, String regex, boolean exclude, int cacheSize) {
        super(typeCode);
        this.matcher = StringUtils.isBlank((CharSequence)regex) ? null : RegExUtils.getPattern(regex, 0).matcher("any");
        this.isExclude = exclude;
        this.cache = cacheSize > 0 ? new LRUFastHashMap(cacheSize) : null;
    }

    protected abstract CharSequence getText(RequestData var1);

    @Override
    public Object appliesTo(RequestData requestData) {
        if (this.matcher == null) {
            return Boolean.TRUE;
        }
        CharSequence text = this.getText(requestData);
        if (this.cache == null) {
            Matcher m = this.matcher.reset(text);
            return m.find() ^ this.isExclude ? m : null;
        }
        MatchResult result = this.cache.get(text);
        if (result == null) {
            Matcher m = this.matcher.reset(text);
            if (m.find() ^ this.isExclude) {
                result = m.toMatchResult();
                this.cache.put(text, result);
                return result;
            }
            this.cache.put(text, NULL);
            return null;
        }
        return result == NULL ? null : result;
    }

    @Override
    public CharSequence getReplacementText(RequestData requestData, int capturingGroupIndex, Object filterState) {
        if (this.isExclude || this.matcher == null || capturingGroupIndex == -1) {
            return this.getText(requestData);
        }
        try {
            return ((MatchResult)filterState).group(capturingGroupIndex);
        }
        catch (IndexOutOfBoundsException ioobe) {
            String format = "No matching group %d for input string '%s' and pattern '%s'";
            ThrowableUtils.setMessage(ioobe, String.format("No matching group %d for input string '%s' and pattern '%s'", capturingGroupIndex, this.getText(requestData), this.getPattern()));
            throw ioobe;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{ type: '");
        sb.append(this.getTypeCode()).append("', ");
        sb.append("pattern: '").append(this.getPattern()).append("', ");
        sb.append("isExclude: ").append(this.isExclude).append(" }");
        return sb.toString();
    }

    public String getPattern() {
        return this.matcher == null ? "" : this.matcher.pattern().pattern();
    }

    public boolean isEmpty() {
        return this.matcher == null;
    }

    public boolean isExclude() {
        return this.isExclude;
    }
}

