/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.report.mergerules;

import com.xceptance.xlt.api.engine.RequestData;
import com.xceptance.xlt.report.mergerules.AbstractRequestFilter;
import org.apache.commons.lang3.StringUtils;

public class ResponseTimeRequestFilter
extends AbstractRequestFilter {
    private final long[] responseTimeBoundaries;
    private final String[] responseTimeRanges;

    public ResponseTimeRequestFilter(String responseTimes) {
        super("r");
        String[] ranges = StringUtils.split((String)responseTimes, (String)" ;,");
        this.responseTimeBoundaries = new long[ranges.length];
        for (int i = 0; i < this.responseTimeBoundaries.length; ++i) {
            this.responseTimeBoundaries[i] = Integer.parseInt(ranges[i]);
        }
        this.responseTimeRanges = new String[this.responseTimeBoundaries.length + 1];
        long previousBoundary = 0L;
        for (int i = 0; i < this.responseTimeBoundaries.length; ++i) {
            long nextBoundary = this.responseTimeBoundaries[i];
            this.responseTimeRanges[i] = previousBoundary + ".." + (nextBoundary - 1L);
            previousBoundary = nextBoundary;
        }
        this.responseTimeRanges[this.responseTimeRanges.length - 1] = ">=" + previousBoundary;
    }

    @Override
    public Object appliesTo(RequestData requestData) {
        return Boolean.TRUE;
    }

    @Override
    public String getReplacementText(RequestData requestData, int capturingGroupIndex, Object filterState) {
        int i;
        long responseTime = requestData.getRunTime();
        for (i = 0; i < this.responseTimeBoundaries.length; ++i) {
            if (responseTime >= this.responseTimeBoundaries[i]) continue;
            return this.responseTimeRanges[i];
        }
        return this.responseTimeRanges[i];
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{ type: '");
        sb.append(this.getTypeCode()).append("', ");
        sb.append("responseTimeRanges: [");
        for (int i = 0; i < this.responseTimeRanges.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append("'").append(this.responseTimeRanges[i]).append("'");
        }
        sb.append("]}");
        return sb.toString();
    }
}

