/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.report.providers;

import com.xceptance.xlt.api.engine.ActionData;
import com.xceptance.xlt.api.engine.Data;
import com.xceptance.xlt.api.report.AbstractReportProvider;
import com.xceptance.xlt.report.ReportGeneratorConfiguration;
import com.xceptance.xlt.report.providers.ActionReport;
import com.xceptance.xlt.report.providers.BasicTimerDataProcessor;
import com.xceptance.xlt.report.providers.TimerReport;
import com.xceptance.xlt.report.util.Apdex;
import com.xceptance.xlt.report.util.ApdexCalculator;
import java.io.File;

public class ActionDataProcessor
extends BasicTimerDataProcessor {
    private final ApdexCalculator apdexCalculator;

    public ActionDataProcessor(String name, AbstractReportProvider provider) {
        super(name, provider);
        this.setChartDir(new File(this.getChartDir(), "actions"));
        this.setCsvDir(new File(this.getCsvDir(), "actions"));
        ReportGeneratorConfiguration config = (ReportGeneratorConfiguration)this.getConfiguration();
        this.setChartCappingInfo(config.getActionChartCappingInfo());
        double threshold = config.getApdexThresholdForAction(this.getName());
        this.apdexCalculator = new ApdexCalculator(threshold);
    }

    @Override
    public void processDataRecord(Data stat) {
        super.processDataRecord(stat);
        ActionData data = (ActionData)stat;
        this.apdexCalculator.addSample(data.getRunTime(), data.hasFailed());
    }

    @Override
    public TimerReport createTimerReport(boolean generateHistogram) {
        ActionReport timerReport = (ActionReport)super.createTimerReport(generateHistogram);
        Apdex apdex = this.apdexCalculator.getApdex();
        timerReport.apdex.value = apdex.getValue();
        timerReport.apdex.longValue = apdex.getLongValue();
        return timerReport;
    }

    @Override
    protected TimerReport createTimerReport() {
        return new ActionReport();
    }
}

