/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.report.providers;

import com.xceptance.common.collection.FastHashMap;
import com.xceptance.xlt.api.engine.Data;
import com.xceptance.xlt.api.engine.RequestData;
import com.xceptance.xlt.api.report.AbstractReportProvider;
import com.xceptance.xlt.api.util.XltCharBuffer;
import com.xceptance.xlt.report.providers.ContentTypeReport;
import com.xceptance.xlt.report.providers.ContentTypesReport;

public class ContentTypesReportProvider
extends AbstractReportProvider {
    private final FastHashMap<XltCharBuffer, ContentTypeReport> contentTypeReports = new FastHashMap(11, 0.5f);

    @Override
    public Object createReportFragment() {
        ContentTypesReport report = new ContentTypesReport();
        report.contentTypes = this.contentTypeReports.values();
        return report;
    }

    @Override
    public void processDataRecord(Data stat) {
        if (stat instanceof RequestData) {
            RequestData reqStats = (RequestData)stat;
            XltCharBuffer contentType = reqStats.getContentType();
            ContentTypeReport contentTypeReport = this.contentTypeReports.get(contentType);
            if (contentTypeReport == null) {
                contentTypeReport = new ContentTypeReport();
                contentTypeReport.contentType = contentType.toString();
                this.contentTypeReports.put(contentType, contentTypeReport);
            }
            ++contentTypeReport.count;
        }
    }
}

