/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.report.providers;

import com.xceptance.common.collection.FastHashMap;
import com.xceptance.xlt.api.engine.Data;
import com.xceptance.xlt.api.engine.RequestData;
import com.xceptance.xlt.api.report.AbstractReportProvider;
import com.xceptance.xlt.api.util.XltCharBuffer;
import com.xceptance.xlt.report.providers.HostReport;
import com.xceptance.xlt.report.providers.HostsReport;

public class HostsReportProvider
extends AbstractReportProvider {
    private final FastHashMap<XltCharBuffer, HostReport> hostReports = new FastHashMap(11, 0.5f);

    @Override
    public Object createReportFragment() {
        HostsReport report = new HostsReport();
        report.hosts = this.hostReports.values();
        return report;
    }

    @Override
    public void processDataRecord(Data data) {
        if (data instanceof RequestData) {
            RequestData reqData = (RequestData)data;
            XltCharBuffer hostName = reqData.getHost();
            HostReport hostReport = this.hostReports.get(hostName);
            if (hostReport == null) {
                hostReport = new HostReport();
                hostReport.name = hostName.toString();
                this.hostReports.put(hostName, hostReport);
            }
            ++hostReport.count;
        }
    }
}

