/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.report.providers;

import com.xceptance.xlt.api.engine.Data;
import com.xceptance.xlt.api.engine.RequestData;
import com.xceptance.xlt.api.report.AbstractReportProvider;
import com.xceptance.xlt.report.providers.ResponseCodeReport;
import com.xceptance.xlt.report.providers.ResponseCodesReport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.impl.EnglishReasonPhraseCatalog;

public class ResponseCodesReportProvider
extends AbstractReportProvider {
    private final Map<Integer, ResponseCodeReport> responseCodeReports = new HashMap<Integer, ResponseCodeReport>();

    @Override
    public Object createReportFragment() {
        ResponseCodesReport report = new ResponseCodesReport();
        report.responseCodes = new ArrayList<ResponseCodeReport>(this.responseCodeReports.values());
        return report;
    }

    @Override
    public void processDataRecord(Data stat) {
        if (stat instanceof RequestData) {
            RequestData reqStats = (RequestData)stat;
            int code = reqStats.getResponseCode();
            ResponseCodeReport responseCodeReport = this.responseCodeReports.get(code);
            if (responseCodeReport == null) {
                responseCodeReport = new ResponseCodeReport();
                responseCodeReport.code = code;
                responseCodeReport.statusText = this.getStatusText(code);
                this.responseCodeReports.put(code, responseCodeReport);
            }
            ++responseCodeReport.count;
        }
    }

    private String getStatusText(int statusCode) {
        String statusText;
        if (statusCode == 0) {
            statusText = "No Response Available";
        } else {
            try {
                statusText = EnglishReasonPhraseCatalog.INSTANCE.getReason(statusCode, null);
            }
            catch (IllegalArgumentException e) {
                statusText = null;
            }
            statusText = statusText == null ? "???" : statusText;
        }
        return statusText;
    }
}

