/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.report.providers;

import com.xceptance.xlt.api.engine.Data;
import com.xceptance.xlt.api.engine.WebVitalData;
import com.xceptance.xlt.api.report.AbstractReportProvider;
import com.xceptance.xlt.report.providers.AbstractDataProcessor;
import com.xceptance.xlt.report.providers.WebVitalReport;
import com.xceptance.xlt.report.providers.WebVitalsReport;
import com.xceptance.xlt.report.util.ReportUtils;
import java.math.BigDecimal;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.math3.stat.descriptive.rank.PSquarePercentile;

public class WebVitalsDataProcessor
extends AbstractDataProcessor {
    private final WebVitalStatistics cls = new WebVitalStatistics(0.1, 0.25);
    private final WebVitalStatistics fcp = new TimingWebVitalStatistics(1800.0, 3000.0);
    private final WebVitalStatistics fid = new TimingWebVitalStatistics(100.0, 300.0);
    private final WebVitalStatistics inp = new TimingWebVitalStatistics(200.0, 500.0);
    private final WebVitalStatistics lcp = new TimingWebVitalStatistics(2500.0, 4000.0);
    private final WebVitalStatistics ttfb = new TimingWebVitalStatistics(800.0, 1800.0);

    public WebVitalsDataProcessor(String name, AbstractReportProvider reportProvider) {
        super(name, reportProvider);
    }

    @Override
    public void processDataRecord(Data data) {
        WebVitalData webVitalData = (WebVitalData)data;
        String webVitalName = WebVitalsDataProcessor.extractWebVitalName(webVitalData.getName());
        double value = webVitalData.getValue();
        switch (webVitalName) {
            case "CLS": {
                this.cls.update(value);
                break;
            }
            case "FCP": {
                this.fcp.update(value);
                break;
            }
            case "FID": {
                this.fid.update(value);
                break;
            }
            case "INP": {
                this.inp.update(value);
                break;
            }
            case "LCP": {
                this.lcp.update(value);
                break;
            }
            case "TTFB": {
                this.ttfb.update(value);
                break;
            }
        }
    }

    private static String extractWebVitalName(String actionName) {
        String suffix = StringUtils.substringAfterLast((String)actionName, (String)" ");
        return StringUtils.substringBetween((String)suffix, (String)"[", (String)"]");
    }

    public WebVitalsReport createWebVitalsReport() {
        WebVitalsReport report = new WebVitalsReport();
        report.name = this.getName();
        report.cls = this.cls.toWebVitalReport();
        report.fcp = this.fcp.toWebVitalReport();
        report.fid = this.fid.toWebVitalReport();
        report.inp = this.inp.toWebVitalReport();
        report.lcp = this.lcp.toWebVitalReport();
        report.ttfb = this.ttfb.toWebVitalReport();
        return report;
    }

    public static class TimingWebVitalStatistics
    extends WebVitalStatistics {
        public TimingWebVitalStatistics(double threshold1, double threshold2) {
            super(threshold1, threshold2);
        }

        @Override
        protected BigDecimal calculateScore(double p75) {
            return new BigDecimal(Math.round(p75));
        }
    }

    public static class WebVitalStatistics {
        private final double threshold1;
        private final double threshold2;
        private final PSquarePercentile p75Estimator = new PSquarePercentile(75.0);
        private int goodCount;
        private int improveCount;
        private int poorCount;

        public WebVitalStatistics(double threshold1, double threshold2) {
            this.threshold1 = threshold1;
            this.threshold2 = threshold2;
        }

        public void update(double value) {
            this.p75Estimator.increment(value);
            if (value <= this.threshold1) {
                ++this.goodCount;
            } else if (value > this.threshold2) {
                ++this.poorCount;
            } else {
                ++this.improveCount;
            }
        }

        public WebVitalReport toWebVitalReport() {
            if (this.goodCount + this.improveCount + this.poorCount == 0) {
                return null;
            }
            double p75 = this.p75Estimator.getResult();
            BigDecimal score = this.calculateScore(p75);
            WebVitalReport.Rating rating = p75 <= this.threshold1 ? WebVitalReport.Rating.good : (p75 > this.threshold2 ? WebVitalReport.Rating.poor : WebVitalReport.Rating.improve);
            return new WebVitalReport(score, rating, this.goodCount, this.improveCount, this.poorCount);
        }

        protected BigDecimal calculateScore(double p75) {
            return ReportUtils.convertToBigDecimal(p75);
        }
    }
}

