/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.html;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.htmlunit.Page;
import org.htmlunit.SgmlPage;
import org.htmlunit.WebResponse;
import org.htmlunit.html.BaseFrameElement;
import org.htmlunit.html.DomAttr;
import org.htmlunit.html.DomElement;
import org.htmlunit.html.DomNode;
import org.htmlunit.html.DomText;
import org.htmlunit.html.HtmlElement;
import org.htmlunit.html.HtmlHtml;
import org.htmlunit.html.HtmlImage;
import org.htmlunit.html.HtmlLink;
import org.htmlunit.html.HtmlOption;
import org.htmlunit.html.HtmlPage;
import org.htmlunit.html.HtmlScript;
import org.htmlunit.util.MimeType;
import org.htmlunit.util.StringUtils;

public class XmlSerializer {
    private static final String FILE_SEPARATOR = "/";
    private static final Pattern CREATE_FILE_PATTERN = Pattern.compile(".*/");
    private static final Log LOG = LogFactory.getLog(XmlSerializer.class);
    private final StringBuilder builder_ = new StringBuilder();
    private final StringBuilder indent_ = new StringBuilder();
    private File outputDir_;

    public void save(SgmlPage page, File file) throws IOException {
        this.save(page, file, false);
    }

    private void save(SgmlPage page, File file, boolean append) throws IOException {
        Object fileName = file.getName();
        if (!(append || ((String)fileName).endsWith(".htm") || ((String)fileName).endsWith(".html"))) {
            fileName = (String)fileName + ".html";
        }
        File outputFile = new File(file.getParentFile(), (String)fileName);
        if (!append && outputFile.exists()) {
            throw new IOException("File already exists: " + outputFile);
        }
        fileName = ((String)fileName).substring(0, ((String)fileName).lastIndexOf(46));
        this.outputDir_ = new File(file.getParentFile(), (String)fileName);
        DomElement node = page.getDocumentElement();
        Charset charsetName = StandardCharsets.ISO_8859_1;
        this.builder_.setLength(0);
        this.indent_.setLength(0);
        if (page.isHtmlPage() && (charsetName = page.getCharset()) != null && node instanceof HtmlHtml) {
            this.builder_.append("<?xml version=\"1.0\" encoding=\"").append(charsetName).append("\"?>\n");
        }
        this.printXml(node);
        String response = this.builder_.toString();
        this.builder_.setLength(0);
        FileUtils.writeStringToFile((File)outputFile, (String)response, (Charset)charsetName, (boolean)append);
    }

    public String asXml(DomElement node) throws IOException {
        Charset charsetName;
        this.builder_.setLength(0);
        this.indent_.setLength(0);
        SgmlPage page = node.getPage();
        if (null != page && page.isHtmlPage() && (charsetName = page.getCharset()) != null && node instanceof HtmlHtml) {
            this.builder_.append("<?xml version=\"1.0\" encoding=\"").append(charsetName).append("\"?>\n");
        }
        this.printXml(node);
        String response = this.builder_.toString();
        this.builder_.setLength(0);
        return response;
    }

    protected void printXml(DomElement node) throws IOException {
        if (!this.isExcluded(node)) {
            boolean hasChildren = node.getFirstChild() != null;
            this.builder_.append((CharSequence)this.indent_).append('<');
            this.printOpeningTag(node);
            if (!hasChildren && !node.isEmptyXmlTagExpanded()) {
                this.builder_.append("/>\n");
            } else {
                this.builder_.append(">\n");
                for (DomNode child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                    this.indent_.append("  ");
                    if (child instanceof DomElement) {
                        this.printXml((DomElement)child);
                    } else {
                        this.builder_.append(child);
                    }
                    this.indent_.setLength(this.indent_.length() - 2);
                }
                this.builder_.append((CharSequence)this.indent_).append("</").append(node.getTagName()).append(">\n");
            }
        }
    }

    public String asText(DomNode node) {
        this.builder_.setLength(0);
        if (node instanceof DomText) {
            this.builder_.append(((DomText)node).getData());
        } else {
            this.printText(node);
        }
        String response = this.builder_.toString();
        this.builder_.setLength(0);
        return response;
    }

    protected void printText(DomNode node) {
        for (DomNode child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child instanceof DomText) {
                this.builder_.append(((DomText)child).getData());
                continue;
            }
            this.printText(child);
        }
    }

    protected void printOpeningTag(DomElement node) throws IOException {
        this.builder_.append(node.getTagName());
        Map<String, DomAttr> attributes = this.readAttributes(node);
        for (Map.Entry<String, DomAttr> entry : attributes.entrySet()) {
            this.builder_.append(' ');
            this.builder_.append(entry.getKey());
            this.builder_.append("=\"");
            String value = entry.getValue().getNodeValue();
            this.builder_.append(StringUtils.escapeXmlAttributeValue(value));
            this.builder_.append('\"');
        }
    }

    private Map<String, DomAttr> readAttributes(DomElement node) throws IOException {
        if (node instanceof HtmlImage) {
            return this.getAttributesFor((HtmlImage)node);
        }
        if (node instanceof HtmlLink) {
            return this.getAttributesFor((HtmlLink)node);
        }
        if (node instanceof BaseFrameElement) {
            return this.getAttributesFor((BaseFrameElement)node);
        }
        Map<String, DomAttr> attributes = node.getAttributesMap();
        if (node instanceof HtmlOption) {
            attributes = new HashMap<String, DomAttr>(attributes);
            HtmlOption option = (HtmlOption)node;
            if (option.isSelected()) {
                if (!attributes.containsKey("selected")) {
                    attributes.put("selected", new DomAttr(node.getPage(), null, "selected", "selected", false));
                }
            } else {
                attributes.remove("selected");
            }
        }
        return attributes;
    }

    private Map<String, DomAttr> getAttributesFor(BaseFrameElement frame) throws IOException {
        Map<String, DomAttr> map = XmlSerializer.createAttributesCopyWithClonedAttribute(frame, "src");
        DomAttr srcAttr = map.get("src");
        if (srcAttr == null) {
            return map;
        }
        Page enclosedPage = frame.getEnclosedPage();
        String suffix = XmlSerializer.getFileExtension(enclosedPage);
        File file = this.createFile(srcAttr.getValue(), "." + suffix);
        if (enclosedPage != null) {
            if (enclosedPage.isHtmlPage()) {
                new XmlSerializer().save((HtmlPage)enclosedPage, file, true);
            } else {
                try (InputStream is = enclosedPage.getWebResponse().getContentAsStream();
                     OutputStream fos = Files.newOutputStream(file.toPath(), new OpenOption[0]);){
                    IOUtils.copyLarge((InputStream)is, (OutputStream)fos);
                }
            }
        }
        srcAttr.setValue(file.getParentFile().getName() + FILE_SEPARATOR + file.getName());
        return map;
    }

    private static String getFileExtension(Page enclosedPage) {
        if (enclosedPage != null) {
            if (enclosedPage.isHtmlPage()) {
                return "html";
            }
            URL url = enclosedPage.getUrl();
            if (url.getPath().contains(".")) {
                return org.apache.commons.lang3.StringUtils.substringAfterLast((String)url.getPath(), (String)".");
            }
        }
        return ".unknown";
    }

    protected Map<String, DomAttr> getAttributesFor(HtmlLink link) throws IOException {
        String protocol;
        Map<String, DomAttr> map = XmlSerializer.createAttributesCopyWithClonedAttribute(link, "href");
        DomAttr hrefAttr = map.get("href");
        if (hrefAttr != null && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)hrefAttr.getValue()) && ("http".equals(protocol = link.getWebRequest().getUrl().getProtocol()) || "https".equals(protocol))) {
            try {
                WebResponse response = link.getWebResponse(true, null);
                File file = this.createFile(hrefAttr.getValue(), ".css");
                FileUtils.writeStringToFile((File)file, (String)response.getContentAsString(), (Charset)StandardCharsets.ISO_8859_1);
                hrefAttr.setValue(this.outputDir_.getName() + FILE_SEPARATOR + file.getName());
            }
            catch (IOException e) {
                LOG.error((Object)("XmlSerializer: IOException while downloading link content from url '" + hrefAttr + "'"), (Throwable)e);
            }
            catch (IllegalStateException e) {
                LOG.error((Object)("XmlSerializer: IllegalStateException while downloading link content from url '" + hrefAttr + "'"), (Throwable)e);
            }
        }
        return map;
    }

    protected Map<String, DomAttr> getAttributesFor(HtmlImage image) {
        Map<String, DomAttr> map = XmlSerializer.createAttributesCopyWithClonedAttribute(image, "src");
        DomAttr srcAttr = map.get("src");
        if (srcAttr != null && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)srcAttr.getValue())) {
            try {
                WebResponse response = image.getWebResponse(true);
                try (InputStream inputStream = response.getContentAsStream();){
                    File file = this.createFile(srcAttr.getValue(), "." + XmlSerializer.getSuffix(response));
                    FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)file);
                    String valueOnFileSystem = this.outputDir_.getName() + FILE_SEPARATOR + file.getName();
                    srcAttr.setValue(valueOnFileSystem);
                }
            }
            catch (IOException e) {
                LOG.error((Object)("XmlSerializer: IOException while downloading image content from url '" + srcAttr + "'"), (Throwable)e);
            }
            catch (IllegalStateException e) {
                LOG.error((Object)("XmlSerializer: IllegalStateException while downloading image content from url '" + srcAttr + "'"), (Throwable)e);
            }
        }
        return map;
    }

    private static String getSuffix(WebResponse response) {
        String url = response.getWebRequest().getUrl().toString();
        String fileName = org.apache.commons.lang3.StringUtils.substringAfterLast((String)org.apache.commons.lang3.StringUtils.substringBefore((String)url, (String)"?"), (String)FILE_SEPARATOR);
        String suffix = org.apache.commons.lang3.StringUtils.substringAfterLast((String)fileName, (String)".");
        if (suffix.length() > 1 && suffix.length() < 5) {
            return suffix;
        }
        return MimeType.getFileExtension(response.getContentType());
    }

    private static Map<String, DomAttr> createAttributesCopyWithClonedAttribute(HtmlElement elt, String attrName) {
        HashMap<String, DomAttr> newMap = new HashMap<String, DomAttr>(elt.getAttributesMap());
        DomAttr attr = (DomAttr)newMap.get(attrName);
        if (null == attr) {
            return newMap;
        }
        DomAttr clonedAttr = new DomAttr(attr.getPage(), attr.getNamespaceURI(), attr.getQualifiedName(), attr.getValue(), attr.getSpecified());
        newMap.put(attrName, clonedAttr);
        return newMap;
    }

    protected boolean isExcluded(DomElement element) {
        return element instanceof HtmlScript;
    }

    private File createFile(String url, String extension) throws IOException {
        Object name = url.replaceFirst("/$", "");
        name = CREATE_FILE_PATTERN.matcher((CharSequence)name).replaceAll("");
        name = org.apache.commons.lang3.StringUtils.substringBefore((String)name, (String)"?");
        name = org.apache.commons.lang3.StringUtils.substringBefore((String)name, (String)";");
        name = org.apache.commons.lang3.StringUtils.substring((String)name, (int)0, (int)30);
        if (!((String)(name = StringUtils.sanitizeForFileName((String)name))).endsWith(extension)) {
            name = (String)name + extension;
        }
        int counter = 0;
        while (true) {
            Object fileName = counter != 0 ? org.apache.commons.lang3.StringUtils.substringBeforeLast((String)name, (String)".") + "_" + counter + "." + org.apache.commons.lang3.StringUtils.substringAfterLast((String)name, (String)".") : name;
            FileUtils.forceMkdir((File)this.outputDir_);
            File f = new File(this.outputDir_, (String)fileName);
            if (f.createNewFile()) {
                return f;
            }
            ++counter;
        }
    }
}

