/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.html.serializer;

import org.apache.commons.lang3.StringUtils;
import org.htmlunit.BrowserVersion;
import org.htmlunit.BrowserVersionFeatures;
import org.htmlunit.SgmlPage;
import org.htmlunit.WebWindow;
import org.htmlunit.css.ComputedCssStyleDeclaration;
import org.htmlunit.css.StyleAttributes;
import org.htmlunit.html.DomElement;
import org.htmlunit.html.DomNode;
import org.htmlunit.html.DomText;
import org.htmlunit.html.HtmlBreak;
import org.htmlunit.html.HtmlDetails;
import org.htmlunit.html.HtmlHead;
import org.htmlunit.html.HtmlListItem;
import org.htmlunit.html.HtmlNoFrames;
import org.htmlunit.html.HtmlParagraph;
import org.htmlunit.html.HtmlScript;
import org.htmlunit.html.HtmlStyle;
import org.htmlunit.html.HtmlSummary;
import org.htmlunit.html.HtmlSvg;
import org.htmlunit.html.HtmlTextArea;
import org.htmlunit.html.HtmlTitle;
import org.htmlunit.html.ScriptElement;
import org.htmlunit.svg.SvgTitle;

public class HtmlSerializerInnerOuterText {
    private final BrowserVersion browserVersion_;

    public HtmlSerializerInnerOuterText(BrowserVersion browserVersion) {
        this.browserVersion_ = browserVersion;
    }

    public String asText(DomNode node) {
        if (node instanceof HtmlBreak) {
            return "";
        }
        if (node instanceof ScriptElement) {
            HtmlSerializerTextBuilder builder = new HtmlSerializerTextBuilder();
            this.appendChildren(builder, node, HtmlSerializerTextBuilder.Mode.WHITE_SPACE_NORMAL, false);
            return builder.getText();
        }
        boolean insideHead = node instanceof HtmlTitle;
        HtmlSerializerTextBuilder builder = new HtmlSerializerTextBuilder();
        this.appendNode(builder, node, HtmlSerializerInnerOuterText.whiteSpaceStyle(node, HtmlSerializerTextBuilder.Mode.WHITE_SPACE_NORMAL), insideHead);
        return builder.getText();
    }

    protected void appendChildren(HtmlSerializerTextBuilder builder, DomNode node, HtmlSerializerTextBuilder.Mode mode, boolean insideHead) {
        for (DomNode child : node.getChildren()) {
            this.appendNode(builder, child, mode, insideHead);
        }
    }

    protected void appendNode(HtmlSerializerTextBuilder builder, DomNode node, HtmlSerializerTextBuilder.Mode mode, boolean insideHead) {
        if (node instanceof DomText) {
            this.appendText(builder, (DomText)node, mode);
        } else if (node instanceof HtmlBreak) {
            this.appendBreak(builder, (HtmlBreak)node);
        } else if (node instanceof HtmlParagraph) {
            this.appendParagraph(builder, (HtmlParagraph)node, mode, insideHead);
        } else if (node instanceof HtmlListItem) {
            this.appendListItem(builder, (HtmlListItem)node, mode, insideHead);
        } else if (node instanceof HtmlDetails) {
            this.appendDetails(builder, (HtmlDetails)node, mode, insideHead);
        } else if (node instanceof HtmlHead) {
            this.appendChildren(builder, node, mode, true);
        } else if (node instanceof HtmlNoFrames) {
            this.appendChildren(builder, node, HtmlSerializerTextBuilder.Mode.PLAIN, insideHead);
        } else if (!(node instanceof HtmlTitle && !insideHead || node instanceof HtmlTextArea)) {
            if (node instanceof ScriptElement) {
                if (insideHead || this.browserVersion_.hasFeature(BrowserVersionFeatures.JS_INNER_TEXT_SCRIPT)) {
                    this.appendChildren(builder, node, mode, insideHead);
                }
            } else if (node instanceof HtmlSvg) {
                if (this.browserVersion_.hasFeature(BrowserVersionFeatures.JS_INNER_TEXT_SVG_NL)) {
                    builder.appendRequiredLineBreak();
                    this.appendChildren(builder, node, mode, insideHead);
                    builder.appendRequiredLineBreak();
                } else {
                    this.appendChildren(builder, node, mode, insideHead);
                }
            } else if (node instanceof SvgTitle) {
                if (this.browserVersion_.hasFeature(BrowserVersionFeatures.JS_INNER_TEXT_SVG_TITLE)) {
                    this.appendChildren(builder, node, mode, insideHead);
                }
            } else {
                this.appendChildren(builder, node, mode, insideHead);
            }
        }
    }

    protected void appendText(HtmlSerializerTextBuilder builder, DomText domText, HtmlSerializerTextBuilder.Mode mode) {
        DomNode parent = domText.getParentNode();
        if (parent instanceof HtmlTitle || parent instanceof HtmlStyle || parent instanceof HtmlScript) {
            builder.append(domText.getData(), HtmlSerializerTextBuilder.Mode.PLAIN);
            return;
        }
        if (parent == null || parent instanceof HtmlNoFrames || parent.isDisplayed()) {
            builder.append(domText.getData(), mode);
        }
    }

    protected void appendBreak(HtmlSerializerTextBuilder builder, HtmlBreak htmlBreak) {
        builder.appendRequiredLineBreak();
    }

    protected void appendParagraph(HtmlSerializerTextBuilder builder, HtmlParagraph htmlParagraph, HtmlSerializerTextBuilder.Mode mode, boolean insideHead) {
        builder.appendRequiredLineBreak();
        this.appendChildren(builder, htmlParagraph, mode, insideHead);
        builder.appendRequiredLineBreak();
    }

    protected void appendListItem(HtmlSerializerTextBuilder builder, HtmlListItem htmlListItem, HtmlSerializerTextBuilder.Mode mode, boolean insideHead) {
        builder.appendRequiredLineBreak();
        this.appendChildren(builder, htmlListItem, mode, insideHead);
        builder.appendRequiredLineBreak();
    }

    protected void appendDetails(HtmlSerializerTextBuilder builder, HtmlDetails htmlDetails, HtmlSerializerTextBuilder.Mode mode, boolean insideHead) {
        if (htmlDetails.isOpen()) {
            this.appendChildren(builder, htmlDetails, mode, insideHead);
            return;
        }
        for (DomNode child : htmlDetails.getChildren()) {
            if (!(child instanceof HtmlSummary)) continue;
            this.appendNode(builder, child, mode, insideHead);
        }
    }

    private static HtmlSerializerTextBuilder.Mode whiteSpaceStyle(DomNode domNode, HtmlSerializerTextBuilder.Mode defaultMode) {
        WebWindow window;
        SgmlPage page;
        if (domNode instanceof DomElement && (page = domNode.getPage()) != null && (window = page.getEnclosingWindow()).getWebClient().getOptions().isCssEnabled()) {
            for (DomNode node = domNode; node != null; node = node.getParentNode()) {
                ComputedCssStyleDeclaration style;
                String value;
                if (!(node instanceof DomElement) || !StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{value = (style = window.getComputedStyle((DomElement)domNode, null)).getStyleAttribute(StyleAttributes.Definition.WHITE_SPACE, false)})) continue;
                if ("normal".equalsIgnoreCase(value)) {
                    return HtmlSerializerTextBuilder.Mode.WHITE_SPACE_NORMAL;
                }
                if ("nowrap".equalsIgnoreCase(value)) {
                    return HtmlSerializerTextBuilder.Mode.WHITE_SPACE_NORMAL;
                }
                if ("pre".equalsIgnoreCase(value)) {
                    return HtmlSerializerTextBuilder.Mode.WHITE_SPACE_PRE;
                }
                if ("pre-wrap".equalsIgnoreCase(value)) {
                    return HtmlSerializerTextBuilder.Mode.WHITE_SPACE_PRE;
                }
                if (!"pre-line".equalsIgnoreCase(value)) continue;
                return HtmlSerializerTextBuilder.Mode.WHITE_SPACE_PRE_LINE;
            }
        }
        return defaultMode;
    }

    protected static class HtmlSerializerTextBuilder {
        private State state_;
        private final StringBuilder builder_ = new StringBuilder();
        private int trimRightPos_ = 0;

        public HtmlSerializerTextBuilder() {
            this.state_ = State.EMPTY;
        }

        public void appendRequiredLineBreak() {
            if (this.state_ == State.EMPTY) {
                return;
            }
            this.builder_.setLength(this.trimRightPos_);
            if (this.trimRightPos_ == 0) {
                this.state_ = State.EMPTY;
            }
            this.builder_.append('\n');
            this.state_ = State.REQUIRED_LINE_BREAK_AT_END;
        }

        public void append(String content, Mode mode) {
            int length = content.length();
            if (length == 0) {
                return;
            }
            if (mode == Mode.PLAIN) {
                this.builder_.append(content);
                this.state_ = State.DEFAULT;
                this.trimRightPos_ = this.builder_.length();
                return;
            }
            --length;
            int i = -1;
            for (char c : content.toCharArray()) {
                ++i;
                if (c == '\r') {
                    if (length != i) continue;
                    c = '\n';
                }
                if (c == '\n') {
                    if (mode == Mode.WHITE_SPACE_PRE) {
                        switch (this.state_) {
                            case EMPTY: 
                            case BLOCK_SEPARATOR_AT_END: {
                                break;
                            }
                            default: {
                                this.builder_.append('\n');
                                this.state_ = State.NEWLINE_AT_END;
                                this.trimRightPos_ = this.builder_.length();
                                break;
                            }
                        }
                        continue;
                    }
                    if (mode == Mode.WHITE_SPACE_PRE_LINE) {
                        switch (this.state_) {
                            case EMPTY: 
                            case BLOCK_SEPARATOR_AT_END: {
                                break;
                            }
                            case BLANK_AT_END: {
                                this.builder_.setLength(this.trimRightPos_);
                                this.builder_.append('\n');
                                this.state_ = State.NEWLINE_AT_END;
                                this.trimRightPos_ = this.builder_.length();
                                break;
                            }
                            default: {
                                this.builder_.append('\n');
                                this.state_ = State.NEWLINE_AT_END;
                                this.trimRightPos_ = this.builder_.length();
                                break;
                            }
                        }
                        continue;
                    }
                    switch (this.state_) {
                        case EMPTY: 
                        case BLOCK_SEPARATOR_AT_END: 
                        case BLANK_AT_END: 
                        case BLANK_AT_END_AFTER_NEWLINE: 
                        case NEWLINE_AT_END: 
                        case BREAK_AT_END: 
                        case REQUIRED_LINE_BREAK_AT_END: {
                            break;
                        }
                        default: {
                            this.builder_.append(' ');
                            this.state_ = State.BLANK_AT_END;
                            break;
                        }
                    }
                    continue;
                }
                if (c == ' ' || c == '\t' || c == '\f') {
                    if (mode == Mode.WHITE_SPACE_PRE) {
                        if (c == '\t') {
                            this.builder_.append('\t');
                        } else {
                            this.builder_.append(' ');
                        }
                        this.state_ = State.BLANK_AT_END;
                        this.trimRightPos_ = this.builder_.length();
                        continue;
                    }
                    if (mode == Mode.WHITE_SPACE_PRE_LINE) {
                        switch (this.state_) {
                            case EMPTY: 
                            case BLANK_AT_END: 
                            case BLANK_AT_END_AFTER_NEWLINE: 
                            case NEWLINE_AT_END: 
                            case BREAK_AT_END: {
                                break;
                            }
                            default: {
                                this.builder_.append(' ');
                                this.state_ = State.BLANK_AT_END;
                                break;
                            }
                        }
                        continue;
                    }
                    switch (this.state_) {
                        case EMPTY: 
                        case BLOCK_SEPARATOR_AT_END: 
                        case BLANK_AT_END: 
                        case BLANK_AT_END_AFTER_NEWLINE: 
                        case NEWLINE_AT_END: 
                        case BREAK_AT_END: 
                        case REQUIRED_LINE_BREAK_AT_END: {
                            break;
                        }
                        default: {
                            this.builder_.append(' ');
                            this.state_ = State.BLANK_AT_END;
                            break;
                        }
                    }
                    continue;
                }
                this.builder_.append(c);
                this.state_ = State.DEFAULT;
                this.trimRightPos_ = this.builder_.length();
            }
        }

        public String getText() {
            return this.builder_.substring(0, this.trimRightPos_);
        }

        private static enum State {
            DEFAULT,
            EMPTY,
            BLANK_AT_END,
            BLANK_AT_END_AFTER_NEWLINE,
            NEWLINE_AT_END,
            BREAK_AT_END,
            BLOCK_SEPARATOR_AT_END,
            REQUIRED_LINE_BREAK_AT_END;

        }

        protected static enum Mode {
            PLAIN,
            WHITE_SPACE_NORMAL,
            WHITE_SPACE_PRE,
            WHITE_SPACE_PRE_LINE;

        }
    }
}

