/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.background;

import java.lang.ref.WeakReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.htmlunit.Page;
import org.htmlunit.WebWindow;
import org.htmlunit.html.HtmlPage;
import org.htmlunit.javascript.background.BasicJavaScriptJob;

abstract class JavaScriptExecutionJob
extends BasicJavaScriptJob {
    private static final Log LOG = LogFactory.getLog(JavaScriptExecutionJob.class);
    private final String label_;
    private final WeakReference<WebWindow> window_;

    JavaScriptExecutionJob(int initialDelay, Integer period, String label, WebWindow window) {
        super(initialDelay, period);
        this.label_ = label;
        this.window_ = new WeakReference<WebWindow>(window);
    }

    @Override
    public void run() {
        WebWindow w = (WebWindow)this.window_.get();
        if (w == null) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Executing " + this + "."));
        }
        try {
            if (w.isClosed()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Enclosing window is now closed. Execution cancelled.");
                }
                return;
            }
            if (!w.getWebClient().containsWebWindow(w)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Enclosing window is now closed. Execution cancelled.");
                }
                return;
            }
            Page enclosedPage = w.getEnclosedPage();
            if (enclosedPage == null || !enclosedPage.isHtmlPage()) {
                if (enclosedPage == null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"The page that originated this job doesn't exist anymore. Execution cancelled.");
                    }
                    return;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("The page that originated this job is no html page (" + enclosedPage.getClass().getName() + "). Execution cancelled."));
                }
                return;
            }
            this.runJavaScript((HtmlPage)enclosedPage);
        }
        finally {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Finished executing " + this + "."));
            }
        }
    }

    @Override
    public String toString() {
        return String.format("JavaScript Execution Job %d (in %s): %s", this.getId(), this.window_.get(), this.label_);
    }

    protected abstract void runJavaScript(HtmlPage var1);
}

