/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.html;

import org.htmlunit.BrowserVersionFeatures;
import org.htmlunit.javascript.JavaScriptEngine;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.configuration.JsxSetter;
import org.htmlunit.javascript.host.html.HTMLElement;

@JsxClass(isJSObject=false)
public class HTMLListElement
extends HTMLElement {
    @JsxGetter
    public boolean isCompact() {
        return this.getDomNodeOrDie().hasAttribute("compact");
    }

    @JsxSetter
    public void setCompact(Object compact) {
        if (JavaScriptEngine.toBoolean(compact)) {
            this.getDomNodeOrDie().setAttribute("compact", "");
        } else {
            this.getDomNodeOrDie().removeAttribute("compact");
        }
    }

    protected String getType() {
        boolean acceptArbitraryValues = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_TYPE_ACCEPTS_ARBITRARY_VALUES);
        String type = this.getDomNodeOrDie().getAttributeDirect("type");
        if (acceptArbitraryValues || "1".equals(type) || "a".equals(type) || "A".equals(type) || "i".equals(type) || "I".equals(type)) {
            return type;
        }
        return "";
    }

    protected void setType(String type) {
        boolean acceptArbitraryValues = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_TYPE_ACCEPTS_ARBITRARY_VALUES);
        if (acceptArbitraryValues || "1".equals(type) || "a".equals(type) || "A".equals(type) || "i".equals(type) || "I".equals(type)) {
            this.getDomNodeOrDie().setAttribute("type", type);
            return;
        }
        throw JavaScriptEngine.reportRuntimeError("Cannot set the type property to invalid value: '" + type + "'");
    }
}

