/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.protocol.data;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;

public class DataUrlDecoder {
    private static final Charset DEFAULT_CHARSET = StandardCharsets.US_ASCII;
    private static final String DEFAULT_MEDIA_TYPE = "text/plain";
    private final String mediaType_;
    private final Charset charset_;
    private final byte[] content_;

    protected DataUrlDecoder(byte[] data, String mediaType, Charset charset) {
        this.content_ = data;
        this.mediaType_ = mediaType;
        this.charset_ = charset;
    }

    public static DataUrlDecoder decode(URL url) throws UnsupportedEncodingException {
        return DataUrlDecoder.decodeDataURL(url.toExternalForm());
    }

    public static DataUrlDecoder decodeDataURL(String url) throws UnsupportedEncodingException {
        if (!url.startsWith("data:")) {
            throw new UnsupportedEncodingException("Invalid data url: '" + url + "' (wrong prefix)");
        }
        int comma = url.indexOf(44);
        if (comma < 0) {
            throw new UnsupportedEncodingException("Invalid data url: '" + url + "' (no data)");
        }
        String beforeData = url.substring("data:".length(), comma);
        boolean base64 = beforeData.endsWith(";base64");
        if (base64) {
            beforeData = beforeData.substring(0, beforeData.length() - 7);
        }
        String mediaType = DataUrlDecoder.extractMediaType(beforeData);
        Charset charset = DataUrlDecoder.extractCharset(beforeData);
        try {
            byte[] data = url.substring(comma + 1).getBytes(charset);
            data = DataUrlDecoder.decodeUrl(data);
            if (base64) {
                data = Base64.decodeBase64((byte[])data);
            }
            return new DataUrlDecoder(data, mediaType, charset);
        }
        catch (DecoderException e) {
            UnsupportedEncodingException ex = new UnsupportedEncodingException("Invalid data url: '" + url + "' (data decoding failed)");
            ex.initCause(e);
            throw ex;
        }
    }

    private static Charset extractCharset(String beforeData) {
        if (beforeData.contains(";")) {
            String charsetName = StringUtils.substringAfter((String)beforeData, (String)";");
            if ((charsetName = charsetName.trim()).startsWith("charset=")) {
                charsetName = charsetName.substring(8);
            }
            try {
                return Charset.forName(charsetName);
            }
            catch (IllegalCharsetNameException | UnsupportedCharsetException e) {
                return DEFAULT_CHARSET;
            }
        }
        return DEFAULT_CHARSET;
    }

    private static String extractMediaType(String beforeData) {
        if (beforeData.contains("/")) {
            if (beforeData.contains(";")) {
                return StringUtils.substringBefore((String)beforeData, (String)";");
            }
            return beforeData;
        }
        return DEFAULT_MEDIA_TYPE;
    }

    public String getMediaType() {
        return this.mediaType_;
    }

    public String getCharset() {
        return this.charset_.name();
    }

    public byte[] getBytes() {
        return this.content_;
    }

    public String getDataAsString() throws UnsupportedEncodingException {
        return new String(this.content_, this.charset_);
    }

    private static byte[] decodeUrl(byte[] bytes) throws DecoderException {
        if (bytes == null) {
            return null;
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            if (b == 37) {
                try {
                    int u = DataUrlDecoder.digit16(bytes[++i]);
                    int l = DataUrlDecoder.digit16(bytes[++i]);
                    buffer.write((char)((u << 4) + l));
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw new DecoderException("Invalid URL encoding: ", (Throwable)e);
                }
            }
            buffer.write(b);
        }
        return buffer.toByteArray();
    }

    private static int digit16(byte b) throws DecoderException {
        int i = Character.digit((char)b, 16);
        if (i == -1) {
            throw new DecoderException("Invalid URL encoding: not a valid digit (radix 16): " + b);
        }
        return i;
    }
}

