/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.vaadin.maps.leaflet.flow;

import com.vaadin.flow.component.ClientCallable;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.xdev.vaadin.maps.leaflet.flow.data.LCenter;
import software.xdev.vaadin.maps.leaflet.flow.data.LComponent;
import software.xdev.vaadin.maps.leaflet.flow.data.LTileLayer;

@NpmPackage(value="leaflet", version="^1.6.0")
@Tag(value="leaflet-map")
@JsModule(value="./leaflet/leafletCon.js")
public class LMap
extends Component
implements HasSize,
HasStyle {
    private static final String SET_VIEW_POINT_FUNCTION = "setViewPoint";
    private static final String DELETE_FUNCTION = "deleteItem";
    private static final String TILE_LAYER_FUNCTION = "setTileLayer";
    private static final String SET_ZOOM_FUNCTION = "setZoomLevel";
    private LCenter center;
    private final List<LComponent> components = new ArrayList<LComponent>();

    public LMap(double lat, double lon, int zoom) {
        this.center = new LCenter(lat, lon, zoom);
        this.setViewPoint(this.center);
        this.setFixZIndexEnabled(true);
    }

    @Deprecated
    public LMap() {
        this(50.921273, 10.359164, 6);
    }

    public void setZoom(int zoom) {
        this.getElement().callJsFunction(SET_ZOOM_FUNCTION, new Serializable[]{Integer.valueOf(zoom)});
    }

    public void setViewPoint(LCenter viewpoint) {
        this.getElement().callJsFunction(SET_VIEW_POINT_FUNCTION, new Serializable[]{viewpoint.toJson()});
    }

    public void setTileLayer(LTileLayer tl) {
        this.getElement().callJsFunction(TILE_LAYER_FUNCTION, new Serializable[]{tl.toJson()});
    }

    protected void setFixZIndexEnabled(boolean enabled) {
        this.getStyle().set("z-index", enabled ? "1" : null);
    }

    @Deprecated
    public void addLComponent(LComponent ... lObjects) {
        this.addLComponents(lObjects);
    }

    public void addLComponents(LComponent ... lComponents) {
        this.addLComponents(Arrays.asList(lComponents));
    }

    public void addLComponents(Collection<LComponent> lComponents) {
        for (LComponent lComponent : lComponents) {
            this.addLComponent(lComponent);
        }
    }

    protected void addLComponent(LComponent lComponent) {
        this.getComponents().add(lComponent);
        this.getElement().callJsFunction(lComponent.getJsFunctionForAddingToMap(), new Serializable[]{lComponent.toJson()});
    }

    @Deprecated
    public void removeItem(LComponent ... items) {
        this.removeLComponents(items);
    }

    public void removeLComponents(LComponent ... lComponents) {
        this.removeLComponents(Arrays.asList(lComponents));
    }

    public void removeLComponents(Collection<LComponent> lComponents) {
        for (LComponent lComponent : lComponents) {
            this.removeLComponent(lComponent);
        }
    }

    protected void removeLComponent(LComponent lComponent) {
        int index = this.components.indexOf(lComponent);
        if (index != -1 && this.components.remove(lComponent)) {
            this.getElement().callJsFunction(DELETE_FUNCTION, new Serializable[]{Integer.valueOf(index)});
        }
    }

    @Deprecated
    public List<LComponent> getItems() {
        return this.components;
    }

    public List<LComponent> getComponents() {
        return this.components;
    }

    public LCenter getCenter() {
        return this.center;
    }

    public void setCenter(LCenter start) {
        this.center = start;
        this.setViewPoint(start);
    }

    @ClientCallable
    protected void onMarkerClick(String tag) {
        ComponentUtil.fireEvent((Component)this, (ComponentEvent)new MarkerClickEvent(this, true, tag));
    }

    public Registration addMarkerClickListener(ComponentEventListener<MarkerClickEvent> listener) {
        return ComponentUtil.addListener((Component)this, MarkerClickEvent.class, listener);
    }

    public class MarkerClickEvent
    extends ComponentEvent<LMap> {
        private final String tag;

        public MarkerClickEvent(LMap source, boolean fromClient, String tag) {
            super((Component)source, fromClient);
            this.tag = tag;
        }

        public String getTag() {
            return this.tag;
        }
    }
}

