/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.vaadin.maps.leaflet.flow.data;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import elemental.json.Json;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import software.xdev.vaadin.maps.leaflet.flow.data.LComponent;
import software.xdev.vaadin.maps.leaflet.flow.data.LDivIcon;
import software.xdev.vaadin.maps.leaflet.flow.data.LIcon;
import software.xdev.vaadin.maps.leaflet.flow.data.LMarkerGeometry;
import software.xdev.vaadin.maps.leaflet.flow.data.LMarkerOptions;

public class LMarker
implements LComponent {
    private static final String MARKER_TYPE = "Point";
    private LMarkerGeometry geometry;
    private LMarkerOptions properties;
    private String tag;

    public LMarker(double lat, double lon) {
        this(lat, lon, "empty");
    }

    public LMarker(double lat, double lon, String tag) {
        this.geometry = new LMarkerGeometry(MARKER_TYPE, lat, lon);
        this.properties = new LMarkerOptions();
        this.tag = tag;
    }

    public LIcon getIcon() {
        return this.properties.getIcon();
    }

    public void setDivIcon(LDivIcon icon) {
        this.properties.setIcon(icon);
    }

    public LIcon getDivIcon() {
        return this.properties.getIcon();
    }

    public void setIcon(LIcon icon) {
        this.properties.setIcon(icon);
    }

    public LMarkerGeometry getGeometry() {
        return this.geometry;
    }

    public void setGeometry(LMarkerGeometry geometry) {
        this.geometry = geometry;
    }

    public LMarkerOptions getProperties() {
        return this.properties;
    }

    public void setProperties(LMarkerOptions properties) {
        this.properties = properties;
    }

    public double getLat() {
        return this.geometry.getCoordinates().get(0);
    }

    public void setLat(double lat) {
        this.geometry.getCoordinates().remove(0);
        this.geometry.getCoordinates().set(0, lat);
    }

    public double getLon() {
        return this.geometry.getCoordinates().get(1);
    }

    public void setLon(double lon) {
        this.geometry.getCoordinates().remove(1);
        this.geometry.getCoordinates().set(1, lon);
    }

    public String getPopup() {
        return this.properties.getPopup();
    }

    public void setPopup(String popup) {
        this.properties.setPopup(popup);
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    @Override
    public JsonObject toJson() {
        JsonObject jsonObject = Json.createObject();
        ObjectMapper mapper = new ObjectMapper();
        try {
            jsonObject.put("type", (JsonValue)Json.create((String)"Feature"));
            jsonObject.put("geometry", (JsonValue)Json.parse((String)mapper.writeValueAsString((Object)this.geometry)));
            jsonObject.put("properties", (JsonValue)Json.parse((String)mapper.writeValueAsString((Object)this.properties)));
            jsonObject.put("tag", (JsonValue)Json.create((String)this.tag));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        return jsonObject;
    }

    @Override
    public String getJsFunctionForAddingToMap() {
        return "addMarker";
    }
}

