/*
 * Decompiled with CFR 0.152.
 */
package software.xdev.vaadin.maps.leaflet.flow.data;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import elemental.json.Json;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import java.util.ArrayList;
import java.util.List;
import software.xdev.vaadin.maps.leaflet.flow.data.LComponent;
import software.xdev.vaadin.maps.leaflet.flow.data.LPoint;
import software.xdev.vaadin.maps.leaflet.flow.data.LPolygonGeometry;
import software.xdev.vaadin.maps.leaflet.flow.data.LPolygonOptions;

public class LPolygon
implements LComponent {
    private final LPolygonGeometry geometry;
    private final LPolygonOptions properties;

    public LPolygon(LPoint ... points) {
        ArrayList<List<Double>> posis = new ArrayList<List<Double>>();
        this.properties = new LPolygonOptions();
        for (LPoint p : points) {
            posis.add(p.getCoords());
        }
        this.geometry = new LPolygonGeometry("Polygon", posis);
    }

    public LPolygon(List<LPoint> points) {
        ArrayList<List<Double>> posis = new ArrayList<List<Double>>();
        for (LPoint p : points) {
            posis.add(p.getCoords());
        }
        this.properties = new LPolygonOptions();
        this.geometry = new LPolygonGeometry("Polygon", posis);
    }

    public boolean isStroke() {
        return this.properties.isStroke();
    }

    public void setStroke(boolean stroke) {
        this.properties.setStroke(stroke);
    }

    public String getStrokeColor() {
        return this.properties.getColor();
    }

    public void setStrokeColor(String strokeColor) {
        this.properties.setColor(strokeColor);
    }

    public double getStrokeOpacity() {
        return this.properties.getOpacity();
    }

    public void setStrokeOpacity(double strokeOpacity) {
        this.properties.setOpacity(strokeOpacity);
    }

    public int getStrokeWeight() {
        return this.properties.getWeight();
    }

    public void setStrokeWeight(int strokeWeight) {
        this.properties.setWeight(strokeWeight);
    }

    public String getLineJoin() {
        return this.properties.getLineJoin();
    }

    public void setLineJoin(String lineJoin) {
        this.properties.setLineJoin(lineJoin);
    }

    public String getDashArray() {
        return this.properties.getDashArray();
    }

    public void setDashArray(String dashArray) {
        this.properties.setDashArray(dashArray);
    }

    public String getDashOffset() {
        return this.properties.getDashOffset();
    }

    public void setDashOffset(String dashOffset) {
        this.properties.setDashOffset(dashOffset);
    }

    public boolean isFill() {
        return this.properties.isFill();
    }

    public void setFill(boolean fill) {
        this.properties.setFill(fill);
    }

    public String getFillColor() {
        return this.properties.getFillColor();
    }

    public void setFillColor(String fillColor) {
        this.properties.setFillColor(fillColor);
    }

    public double getFillOpacity() {
        return this.properties.getFillOpacity();
    }

    public void setFillOpacity(double fillOpacity) {
        this.properties.setFillOpacity(fillOpacity);
    }

    public String getPopup() {
        return this.properties.getPopup();
    }

    public void setPopup(String popup) {
        this.properties.setPopup(popup);
    }

    public String getFillRule() {
        return this.properties.getFillRule();
    }

    public void setFillRule(String fillRule) {
        this.properties.setFillRule(fillRule);
    }

    public boolean isNoClip() {
        return this.properties.isNoClip();
    }

    public void setNoClip(boolean noClip) {
        this.properties.setNoClip(noClip);
    }

    public double getSmoothFactor() {
        return this.properties.getSmoothFactor();
    }

    public void setSmoothFactor(double smoothFactor) {
        this.properties.setSmoothFactor(smoothFactor);
    }

    @Override
    public JsonObject toJson() {
        JsonObject jsonObject = Json.createObject();
        ObjectMapper mapper = new ObjectMapper();
        try {
            jsonObject.put("type", (JsonValue)Json.create((String)"Feature"));
            jsonObject.put("geometry", (JsonValue)Json.parse((String)mapper.writeValueAsString((Object)this.geometry)));
            jsonObject.put("properties", (JsonValue)Json.parse((String)mapper.writeValueAsString((Object)this.properties)));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        return jsonObject;
    }

    @Override
    public String getJsFunctionForAddingToMap() {
        return "addPolygon";
    }
}

