/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.nio.file;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.nio.file.OverthereFileSystem;
import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Stack;

public class OvertherePath
implements Path {
    private OverthereFileSystem fileSystem;
    private List<String> segments;
    private boolean absolute;
    private final Splitter pathSplitter;

    OvertherePath(OverthereFileSystem fileSystem, String path) {
        this.fileSystem = fileSystem;
        String sep = fileSystem.getSeparator();
        this.absolute = path.startsWith(sep);
        this.pathSplitter = Splitter.on((String)sep).omitEmptyStrings();
        this.segments = Lists.newArrayList((Iterable)this.pathSplitter.split((CharSequence)path));
    }

    OvertherePath(OverthereFileSystem fileSystem, List<String> segments, boolean absolute) {
        this.fileSystem = fileSystem;
        this.segments = segments;
        this.absolute = absolute;
        this.pathSplitter = Splitter.on((String)fileSystem.getSeparator()).omitEmptyStrings();
    }

    @Override
    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    OverthereFileSystem getOverthereFileSystem() {
        return this.fileSystem;
    }

    OverthereFile getOverthereFile() {
        return this.fileSystem.getConnection().getFile(this.toString());
    }

    @Override
    public Path getRoot() {
        return this.absolute ? this.fileSystem.getRoot() : null;
    }

    @Override
    public boolean isAbsolute() {
        return this.absolute;
    }

    @Override
    public Path getFileName() {
        int last = this.segments.size();
        return this.slicePath(last - 1, last, false);
    }

    @Override
    public Path getParent() {
        return this.slicePath(0, this.segments.size() - 1, this.absolute);
    }

    @Override
    public int getNameCount() {
        return this.segments.size();
    }

    @Override
    public Path getName(int index) {
        Preconditions.checkArgument((index >= 0 && index < this.segments.size() ? 1 : 0) != 0, (String)"Cannot call getName with index = %s on path: %s", (Object[])new Object[]{index, this.toString()});
        return this.slicePath(index, index + 1, false);
    }

    @Override
    public Path subpath(int beginIndex, int endIndex) {
        Preconditions.checkArgument((beginIndex >= 0 && beginIndex < this.segments.size() ? 1 : 0) != 0, (String)"Cannot call subpath with beginIndex = %s on path: %s", (Object[])new Object[]{beginIndex, this.toString()});
        Preconditions.checkArgument((endIndex > beginIndex && endIndex <= this.segments.size() ? 1 : 0) != 0, (String)"Cannot call subpath with endIndex = %s on path: %s", (Object[])new Object[]{endIndex, this.toString()});
        return this.slicePath(beginIndex, endIndex, false);
    }

    private Path slicePath(int beginIndex, int endIndex, boolean absolute) {
        if (this.segments.isEmpty()) {
            return null;
        }
        return new OvertherePath(this.fileSystem, this.segments.subList(beginIndex, endIndex), absolute);
    }

    @Override
    public boolean startsWith(Path other) {
        if (!(other instanceof OvertherePath)) {
            return false;
        }
        OvertherePath otherPath = (OvertherePath)other;
        if (!otherPath.getFileSystem().equals(this.fileSystem) || otherPath.segments.size() > this.segments.size() || otherPath.absolute != this.absolute) {
            return false;
        }
        for (int i = 0; i < otherPath.segments.size(); ++i) {
            if (otherPath.segments.get(i).equals(this.segments.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean startsWith(String other) {
        return this.startsWith(this.fileSystem.getPath(other, new String[0]));
    }

    @Override
    public boolean endsWith(Path other) {
        if (!(other instanceof OvertherePath)) {
            return false;
        }
        OvertherePath otherPath = (OvertherePath)other;
        int otherSize = otherPath.segments.size();
        int size = this.segments.size();
        if (!otherPath.getFileSystem().equals(this.fileSystem) || otherSize > size || otherSize == size && otherPath.absolute && !this.absolute) {
            return false;
        }
        for (int i = 0; i < otherSize; ++i) {
            if (otherPath.segments.get(otherSize - i - 1).equals(this.segments.get(size - i - 1))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean endsWith(String other) {
        return this.endsWith(this.fileSystem.getPath(other, new String[0]));
    }

    @Override
    public Path normalize() {
        Stack<String> filteredSegments = new Stack<String>();
        for (String segment : this.segments) {
            if (".".equals(segment)) continue;
            if ("..".equals(segment)) {
                if (filteredSegments.isEmpty()) continue;
                filteredSegments.pop();
                continue;
            }
            filteredSegments.push(segment);
        }
        return new OvertherePath(this.fileSystem, Lists.newArrayList(filteredSegments), this.absolute);
    }

    @Override
    public Path resolve(Path other) {
        if (other.isAbsolute()) {
            return other;
        }
        ArrayList strings = Lists.newArrayList(this.segments);
        for (int i = 0; i < other.getNameCount(); ++i) {
            strings.add(other.getName(i).toString());
        }
        return new OvertherePath(this.fileSystem, strings, this.absolute);
    }

    @Override
    public Path resolve(String other) {
        return this.resolve(new OvertherePath(this.fileSystem, other));
    }

    @Override
    public Path resolveSibling(Path other) {
        return this.getParent().resolve(other);
    }

    @Override
    public Path resolveSibling(String other) {
        return this.getParent().resolve(other);
    }

    @Override
    public Path relativize(Path other) {
        int i;
        if (this.absolute ^ other.isAbsolute()) {
            throw new IllegalArgumentException(String.format("Path [%s] and [%s] are not both absolute or non-absolute", this, other));
        }
        if (this.equals(other)) {
            return this.fileSystem.getPath("", new String[0]);
        }
        int longestCommonSubstring = 0;
        Iterator<Path> otherIt = other.iterator();
        ArrayList newSegments = Lists.newArrayList();
        for (Path path : this) {
            if (!otherIt.hasNext()) continue;
            if (!path.equals(otherIt.next())) break;
            ++longestCommonSubstring;
        }
        for (i = 0; i < this.segments.size() - longestCommonSubstring; ++i) {
            newSegments.add("..");
        }
        for (i = longestCommonSubstring; i < other.getNameCount(); ++i) {
            newSegments.add(other.getName(i).toString());
        }
        return new OvertherePath(this.fileSystem, newSegments, false);
    }

    @Override
    public URI toUri() {
        URI uri = this.fileSystem.getUri();
        if (this.isAbsolute()) {
            try {
                String host = uri.getHost();
                return new URI(uri.getScheme(), uri.getUserInfo(), host, uri.getPort(), this.getPathString(), uri.getQuery(), uri.getFragment());
            }
            catch (URISyntaxException e) {
                throw new IOError(e);
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public Path toAbsolutePath() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Path toRealPath(LinkOption ... options) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public File toFile() {
        throw new UnsupportedOperationException();
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?>[] events, WatchEvent.Modifier ... modifiers) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?> ... events) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<Path> iterator() {
        return new Iterator<Path>(){
            private int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < OvertherePath.this.getNameCount();
            }

            @Override
            public Path next() {
                if (this.i < OvertherePath.this.getNameCount()) {
                    Path result = OvertherePath.this.getName(this.i);
                    ++this.i;
                    return result;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public int compareTo(Path other) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString() {
        return this.getPathString();
    }

    private String getPathString() {
        String sep = this.getFileSystem().getSeparator();
        return (this.absolute ? sep : "") + Joiner.on((String)sep).join(this.segments);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OvertherePath)) {
            return false;
        }
        OvertherePath other = (OvertherePath)o;
        return this.fileSystem.equals(other.fileSystem) && this.absolute == other.absolute && this.segments.equals(other.segments);
    }

    @Override
    public int hashCode() {
        int result = this.fileSystem != null ? this.fileSystem.hashCode() : 0;
        result = 31 * result + (this.segments != null ? this.segments.hashCode() : 0);
        result = 31 * result + (this.absolute ? 1 : 0);
        return result;
    }
}

