/*
 * Decompiled with CFR 0.152.
 */
package com.xemantic.ai.money;

import com.xemantic.ai.money.Money;
import java.math.BigDecimal;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0015B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0011\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u0001H\u0096\u0002J\u0011\u0010\b\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u0001H\u0096\u0002J\u0011\u0010\t\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u0001H\u0096\u0002J\u0011\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000bH\u0096\u0002J\u0011\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0001H\u0096\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u000e\u001a\u0004\u0018\u00010\u0013H\u0096\u0002J\b\u0010\u0014\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/xemantic/ai/money/JvmMoney;", "Lcom/xemantic/ai/money/Money;", "value", "Ljava/math/BigDecimal;", "<init>", "(Ljava/math/BigDecimal;)V", "plus", "amount", "minus", "times", "ratio", "Lcom/xemantic/ai/money/Money$Ratio;", "compareTo", "", "other", "toString", "", "equals", "", "", "hashCode", "JvmRatio", "xemantic-ai-money"})
public final class JvmMoney
implements Money {
    @NotNull
    private final BigDecimal value;

    public JvmMoney(@NotNull BigDecimal value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.value = value;
    }

    @Override
    @NotNull
    public Money plus(@NotNull Money amount) {
        Intrinsics.checkNotNullParameter((Object)amount, (String)"amount");
        BigDecimal bigDecimal = this.value.add(((JvmMoney)amount).value);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"add(...)");
        BigDecimal bigDecimal2 = bigDecimal.stripTrailingZeros();
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal2, (String)"stripTrailingZeros(...)");
        return new JvmMoney(bigDecimal2);
    }

    @Override
    @NotNull
    public Money minus(@NotNull Money amount) {
        Intrinsics.checkNotNullParameter((Object)amount, (String)"amount");
        BigDecimal bigDecimal = this.value.subtract(((JvmMoney)amount).value);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"subtract(...)");
        BigDecimal bigDecimal2 = bigDecimal.stripTrailingZeros();
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal2, (String)"stripTrailingZeros(...)");
        return new JvmMoney(bigDecimal2);
    }

    @Override
    @NotNull
    public Money times(@NotNull Money amount) {
        Intrinsics.checkNotNullParameter((Object)amount, (String)"amount");
        BigDecimal bigDecimal = this.value.multiply(((JvmMoney)amount).value);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"multiply(...)");
        BigDecimal bigDecimal2 = bigDecimal.stripTrailingZeros();
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal2, (String)"stripTrailingZeros(...)");
        return new JvmMoney(bigDecimal2);
    }

    @Override
    @NotNull
    public Money times(@NotNull Money.Ratio ratio) {
        Intrinsics.checkNotNullParameter((Object)ratio, (String)"ratio");
        BigDecimal bigDecimal = this.value.multiply(((JvmRatio)ratio).getValue$xemantic_ai_money());
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"multiply(...)");
        BigDecimal bigDecimal2 = bigDecimal.stripTrailingZeros();
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal2, (String)"stripTrailingZeros(...)");
        return new JvmMoney(bigDecimal2);
    }

    @Override
    public int compareTo(@NotNull Money other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.value.compareTo(((JvmMoney)other).value);
    }

    @NotNull
    public String toString() {
        String string = this.value.toPlainString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toPlainString(...)");
        return string;
    }

    public boolean equals(@Nullable Object other) {
        return other != null && other instanceof JvmMoney && Intrinsics.areEqual((Object)this.value, (Object)((JvmMoney)other).value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    @NotNull
    public Money times(int scalar) {
        return Money.DefaultImpls.times(this, scalar);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0011\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0096\u0002J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0096\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lcom/xemantic/ai/money/JvmMoney$JvmRatio;", "Lcom/xemantic/ai/money/Money$Ratio;", "value", "Ljava/math/BigDecimal;", "<init>", "(Ljava/math/BigDecimal;)V", "getValue$xemantic_ai_money", "()Ljava/math/BigDecimal;", "times", "Lcom/xemantic/ai/money/Money;", "amount", "toString", "", "equals", "", "other", "", "hashCode", "", "xemantic-ai-money"})
    public static final class JvmRatio
    implements Money.Ratio {
        @NotNull
        private final BigDecimal value;

        public JvmRatio(@NotNull BigDecimal value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.value = value;
        }

        @NotNull
        public final BigDecimal getValue$xemantic_ai_money() {
            return this.value;
        }

        @Override
        @NotNull
        public Money times(@NotNull Money amount) {
            Intrinsics.checkNotNullParameter((Object)amount, (String)"amount");
            BigDecimal bigDecimal = this.value.multiply(((JvmMoney)amount).value);
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"multiply(...)");
            BigDecimal bigDecimal2 = bigDecimal.stripTrailingZeros();
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal2, (String)"stripTrailingZeros(...)");
            return new JvmMoney(bigDecimal2);
        }

        @NotNull
        public String toString() {
            String string = this.value.toPlainString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toPlainString(...)");
            return string;
        }

        public boolean equals(@Nullable Object other) {
            return other != null && other instanceof JvmRatio && Intrinsics.areEqual((Object)this.value, (Object)((JvmRatio)other).value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

