/*
 * Decompiled with CFR 0.152.
 */
package com.xhinliang.lunarcalendar;

import com.xhinliang.lunarcalendar.DPCNCalendar;
import com.xhinliang.lunarcalendar.Festivals;
import com.xhinliang.lunarcalendar.LunarCalendar;
import com.xhinliang.lunarcalendar.utils.TextUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

class DPCManager {
    private static final Map<Integer, Map<Integer, LunarCalendar[][]>> DATE_CACHE = new WeakHashMap<Integer, Map<Integer, LunarCalendar[][]>>();
    private static volatile DPCManager sManager;

    DPCManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static DPCManager getInstance() {
        if (null != sManager) return sManager;
        Class<DPCManager> clazz = DPCManager.class;
        synchronized (DPCManager.class) {
            if (sManager != null) return sManager;
            sManager = new DPCManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sManager;
        }
    }

    LunarCalendar[][] obtainDPInfo(int year, int month) {
        Map<Integer, LunarCalendar[][]> dataOfYear = DATE_CACHE.get(year);
        if (null != dataOfYear && dataOfYear.size() != 0) {
            LunarCalendar[][] dataOfMonth = dataOfYear.get(month);
            if (dataOfMonth != null) {
                return dataOfMonth;
            }
            dataOfMonth = this.buildDPInfo(year, month);
            dataOfYear.put(month, dataOfMonth);
            return dataOfMonth;
        }
        if (null == dataOfYear) {
            dataOfYear = new HashMap<Integer, LunarCalendar[][]>();
        }
        LunarCalendar[][] dataOfMonth = this.buildDPInfo(year, month);
        dataOfYear.put(month, dataOfMonth);
        DATE_CACHE.put(year, dataOfYear);
        return dataOfMonth;
    }

    private LunarCalendar[][] buildDPInfo(int year, int month) {
        LunarCalendar[][] info = new LunarCalendar[6][7];
        int[][] monthGregorian = DPCNCalendar.buildMonthGregorian(year, month);
        Festivals[][] strF = DPCNCalendar.buildMonthFestivals(year, month);
        Set<Integer> weekends = DPCNCalendar.buildMonthWeekend(year, month);
        for (int i = 0; i < info.length; ++i) {
            for (int j = 0; j < info[i].length; ++j) {
                if (monthGregorian[i][j] == -1) continue;
                LunarCalendar tmp = new LunarCalendar(year, month, monthGregorian[i][j]);
                String strG = tmp.getDay() + "";
                tmp.setFestivals(strF[i][j]);
                tmp.setIsToday(DPCNCalendar.isToday(tmp));
                if (weekends.contains(tmp.getDay())) {
                    tmp.setIsWeekend(true);
                }
                if (TextUtils.isNotEmpty(strG)) {
                    tmp.setSolarTerm(DPCNCalendar.getSolarTerm(year, month, tmp.getDay()));
                }
                info[i][j] = tmp;
            }
        }
        return info;
    }

    LunarCalendar getDPInfo(int year, int month, int day) {
        LunarCalendar[][] monthInfo;
        LunarCalendar[][] lunarCalendarArray = monthInfo = this.obtainDPInfo(year, month);
        int n = lunarCalendarArray.length;
        for (int i = 0; i < n; ++i) {
            LunarCalendar[] items;
            for (LunarCalendar item : items = lunarCalendarArray[i]) {
                if (item == null || item.getDay() != day) continue;
                return item;
            }
        }
        throw new RuntimeException("This day is NOT FOUND!");
    }
}

