/*
 * Decompiled with CFR 0.152.
 */
package com.xhinliang.lunarcalendar;

import com.xhinliang.lunarcalendar.Festivals;
import com.xhinliang.lunarcalendar.Gregorian;
import com.xhinliang.lunarcalendar.Lunar;
import com.xhinliang.lunarcalendar.LunarCalendar;
import com.xhinliang.lunarcalendar.utils.SolarTerm;
import com.xhinliang.lunarcalendar.utils.TextUtils;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

class DPCNCalendar {
    static final int NOT_A_DAY = -1;
    private static final int[] FIRST_DAY_OF_LUNAR_IN_GREGORIAN = new int[]{1897, 30122, 5482, 67949, 2396, 5294, 43597, 6732, 6954, 36181, 2772, 4954, 18781, 2396, 54427, 5274, 6730, 47781, 5800, 6868, 21210, 4790, 59703, 2350, 5270, 46667, 3402, 3496, 38325, 1388, 4782, 18735, 2350, 52374, 6804, 7498, 44457, 2906, 1388, 29294, 4700, 63789, 6442, 6804, 56138, 5802, 2772, 38235, 1210, 4698, 22827, 5418, 63125, 3476, 5802, 43701, 2484, 5302, 27223, 2646, 70954, 7466, 3412, 54698, 5482, 2412, 38062, 5294, 2636, 32038, 6954, 60245, 2772, 4826, 43357, 2394, 5274, 39501, 6730, 72357, 5800, 5844, 53978, 4790, 2358, 38039, 5270, 87627, 3402, 3496, 54708, 5484, 4782, 43311, 2350, 3222, 27978, 7498, 68965, 2904, 5484, 45677, 4700, 6444, 39573, 6804, 6986, 19285, 2772, 62811, 1210, 4698, 47403, 5418, 5780, 38570, 5546, 76469, 2420, 5302, 51799, 2646, 5414, 36501, 3412, 5546, 18869, 2412, 54446, 5276, 6732, 48422, 6822, 2900, 28010, 4826, 92509, 2394, 5274, 55883, 6730, 6820, 47956, 5812, 2778, 18779, 2358, 62615, 5270, 5450, 46757, 3492, 5556, 27318, 4718, 67887, 2350, 3222, 52554, 7498, 3428, 38252, 5468, 4700, 31022, 6444, 64149, 6804, 6986, 43861, 2772, 5338, 35421, 2650, 70955, 5418, 5780, 54954, 5546, 2740, 38074, 5302, 2646, 29991, 3366, 61011, 3412, 5546, 43445, 2412, 5294, 35406, 6732, 72998, 6820, 6996, 52586, 2778, 2396, 38045, 5274, 6698, 23333, 6820, 64338};
    private static final int[] DAYS_AND_LEAP_MONTH_OF_LUNAR = new int[]{1897, 971830, 972362, 972863, 973395, 973896, 974397, 974928, 975428, 975929, 976461, 976962, 977462, 977994, 978494, 979026, 979526, 980026, 980558, 981059, 981559, 982091, 982593, 983124, 983624, 984124, 984656, 985157, 985656, 986189, 986690, 987191, 987722, 988222, 988753, 989254, 989754, 990286, 990788, 991288, 991819, 992319, 992851, 993352, 993851, 994383, 994885, 995385, 995917, 996418, 996918, 997450, 997949, 998481, 998982, 999483, 1000014, 1000515, 1001016, 1001548, 1002047, 1002578, 1003080, 1003580, 1004111, 1004613, 1005113, 1005645, 1006146, 1006645, 1007177, 1007678, 1008209, 1008710, 1009211, 1009743, 1010243, 1010743, 1011275, 1011775, 1012306, 1012807, 1013308, 1013840, 1014341, 1014841, 1015373, 1015874, 1016404, 1016905, 1017405, 1017937, 1018438, 1018939, 1019471, 1019972, 1020471, 1021002, 1021503, 1022035, 1022535, 1023036, 1023568, 1024069, 1024568, 1025100, 1025601, 1026102, 1026633, 1027133, 1027666, 1028167, 1028666, 1029198, 1029699, 1030199, 1030730, 1031231, 1031763, 1032264, 1032764, 1033296, 1033797, 1034297, 1034828, 1035329, 1035830, 1036362, 1036861, 1037393, 1037894, 1038394, 1038925, 1039427, 1039927, 1040459, 1040959, 1041491, 1041992, 1042492, 1043023, 1043524, 1044024, 1044556, 1045057, 1045558, 1046090, 1046590, 1047121, 1047622, 1048122, 1048654, 1049154, 1049655, 1050187, 1050689, 1051219, 1051720, 1052220, 1052751, 1053252, 1053752, 1054284, 1054786, 1055285, 1055817, 1056317, 1056849, 1057349, 1057850, 1058382, 1058883, 1059383, 1059915, 1060415, 1060947, 1061447, 1061947, 1062479, 1062981, 1063480, 1064012, 1064514, 1065014, 1065545, 1066045, 1066577, 1067078, 1067578, 1068110, 1068611, 1069112, 1069642, 1070142, 1070674, 1071175, 1071675, 1072207, 1072709, 1073209, 1073740, 1074241, 1074741, 1075273, 1075773};
    private static final Calendar calendar = Calendar.getInstance();
    private static final String[][] FESTIVAL_GREGORIAN = new String[][]{{"\u5143\u65e6"}, {"\u4e16\u754c\u6e7f\u5730\u65e5", "\u60c5\u4eba\u8282"}, {"\u5168\u56fd\u7231\u8033\u65e5", "\u9752\u5e74\u5fd7\u613f\u8005\u670d\u52a1\u65e5", "\u56fd\u9645\u5987\u5973\u8282", "\u4fdd\u62a4\u6bcd\u4eb2\u6cb3\u65e5", "\u4e2d\u56fd\u690d\u6811\u8282", "\u767d\u8272\u60c5\u4eba\u8282&\u56fd\u9645\u8b66\u5bdf\u65e5", "\u4e16\u754c\u6d88\u8d39\u8005\u6743\u76ca\u65e5", "\u4e16\u754c\u68ee\u6797\u65e5&\u4e16\u754c\u7761\u7720\u65e5", "\u4e16\u754c\u6c34\u65e5", "\u4e16\u754c\u6c14\u8c61\u65e5", "\u4e16\u754c\u9632\u6cbb\u7ed3\u6838\u75c5\u65e5"}, {"\u611a\u4eba\u8282", "\u6e05\u660e\u8282", "\u4e16\u754c\u536b\u751f\u65e5", "\u4e16\u754c\u5730\u7403\u65e5", "\u4e16\u754c\u77e5\u8bc6\u4ea7\u6743\u65e5"}, {"\u56fd\u9645\u52b3\u52a8\u8282", "\u4e16\u754c\u54ee\u5598\u65e5", "\u4e2d\u56fd\u9752\u5e74\u8282", "\u4e16\u754c\u7ea2\u5341\u5b57\u65e5", "\u56fd\u9645\u62a4\u58eb\u8282", "\u56fd\u9645\u5bb6\u5ead\u65e5", "\u4e16\u754c\u7535\u4fe1\u65e5", "\u5168\u56fd\u5b66\u751f\u8425\u517b\u65e5", "\u56fd\u9645\u751f\u7269\u591a\u6837\u6027\u65e5", "\u56fd\u9645\u725b\u5976\u65e5", "\u4e16\u754c\u65e0\u70df\u65e5"}, {"\u56fd\u9645\u513f\u7ae5\u8282", "\u4e16\u754c\u73af\u5883\u65e5", "\u5168\u56fd\u7231\u773c\u65e5", "\u4e16\u754c\u9632\u6cbb\u8352\u6f20\u5316\u65e5", "\u56fd\u9645\u5965\u6797\u5339\u514b\u65e5", "\u5168\u56fd\u571f\u5730\u65e5", "\u56fd\u9645\u7981\u6bd2\u65e5"}, {"\u4e2d\u56fd\u5171\u4ea7\u515a\u8bde\u751f\u65e5&\u56fd\u9645\u5efa\u7b51\u65e5", "\u4e2d\u56fd\u6297\u6218\u7eaa\u5ff5\u65e5", "\u4e16\u754c\u4eba\u53e3\u65e5"}, {"\u4e2d\u56fd\u89e3\u653e\u519b\u5efa\u519b\u8282", "\u56fd\u9645\u9752\u5e74\u8282"}, {"\u6297\u6218\u80dc\u5229\u65e5", "\u56fd\u9645\u626b\u76f2\u65e5", "\u4e2d\u56fd\u6559\u5e08\u8282", "\u4e2d\u56fd\u8111\u5065\u5eb7\u65e5&\u81ed\u6c27\u5c42\u4fdd\u62a4\u65e5", "\u5168\u56fd\u7231\u7259\u65e5", "\u4e16\u754c\u505c\u706b\u65e5", "\u4e16\u754c\u65c5\u6e38\u65e5"}, {"\u56fd\u5e86\u8282&\u56fd\u9645\u8001\u5e74\u4eba\u65e5", "\u4e16\u754c\u52a8\u7269\u65e5", "\u4e16\u754c\u6559\u5e08\u65e5", "\u5168\u56fd\u9ad8\u8840\u538b\u65e5", "\u4e16\u754c\u90ae\u653f\u65e5", "\u4e16\u754c\u7cbe\u795e\u536b\u751f\u65e5", "\u4e16\u754c\u6807\u51c6\u65e5", "\u56fd\u9645\u76f2\u4eba\u8282&\u4e16\u754c\u519c\u6751\u5987\u5973\u65e5", "\u4e16\u754c\u7cae\u98df\u65e5", "\u56fd\u9645\u6d88\u9664\u8d2b\u56f0\u65e5", "\u8054\u5408\u56fd\u65e5&\u4e16\u754c\u53d1\u5c55\u65b0\u95fb\u65e5", "\u4e2d\u56fd\u7537\u6027\u5065\u5eb7\u65e5", "\u4e07\u5723\u8282"}, {"\u4e2d\u56fd\u8bb0\u8005\u8282", "\u6d88\u9632\u5ba3\u4f20\u65e5", "\u4e16\u754c\u7cd6\u5c3f\u75c5\u65e5", "\u56fd\u9645\u5927\u5b66\u751f\u8282", "\u6d88\u9664\u5bf9\u5987\u5973\u66b4\u529b\u65e5"}, {"\u4e16\u754c\u7231\u6ecb\u75c5\u65e5", "\u4e16\u754c\u6b8b\u75be\u4eba\u65e5", "\u5168\u56fd\u6cd5\u5236\u5ba3\u4f20\u65e5", "\u4e16\u754c\u8db3\u7403\u65e5", "\u5723\u8bde\u8282"}};
    private static final int[][] FESTIVAL_G_DATE = new int[][]{{1}, {2, 14}, {3, 5, 8, 9, 12, 14, 15, 21, 22, 23, 24}, {1, 5, 7, 22, 26}, {1, 3, 4, 8, 12, 15, 17, 20, 22, 23, 31}, {1, 5, 6, 17, 23, 25, 26}, {1, 7, 11}, {1, 12}, {3, 8, 10, 16, 20, 21, 27}, {1, 4, 5, 8, 9, 10, 14, 15, 16, 17, 24, 29, 31}, {8, 9, 14, 17, 25}, {1, 3, 4, 9, 25}};
    private static final String[][] FESTIVAL_L = new String[][]{{"\u6625\u8282", "\u5143\u5bb5"}, new String[0], new String[0], new String[0], {"\u7aef\u5348"}, new String[0], {"\u4e5e\u5de7"}, {"\u4e2d\u79cb"}, {"\u91cd\u9633"}, new String[0], new String[0], {"\u814a\u516b", "\u626b\u623f", "\u9664\u5915"}};
    private static final int[][] FESTIVAL_LUNAR_DATE = new int[][]{{1, 15}, new int[0], new int[0], new int[0], {5}, new int[0], {7}, {15}, {9}, new int[0], new int[0], {8, 24, 30}};
    private static final String[][] SOLAR_TERM = new String[][]{{"\u5c0f\u5bd2", "\u5927\u5bd2"}, {"\u7acb\u6625", "\u96e8\u6c34"}, {"\u60ca\u86f0", "\u6625\u5206"}, {"\u6e05\u660e", "\u8c37\u96e8"}, {"\u7acb\u590f", "\u5c0f\u6ee1"}, {"\u8292\u79cd", "\u590f\u81f3"}, {"\u5c0f\u6691", "\u5927\u6691"}, {"\u7acb\u79cb", "\u5904\u6691"}, {"\u767d\u9732", "\u79cb\u5206"}, {"\u5bd2\u9732", "\u971c\u964d"}, {"\u7acb\u51ac", "\u5c0f\u96ea"}, {"\u5927\u96ea", "\u51ac\u81f3"}};
    private static final HashMap<Integer, String[][]> CACHE_SOLAR_TERM = new HashMap();
    private static final SolarTerm mSolarTerm = new SolarTerm();

    private DPCNCalendar() {
    }

    static Lunar getLunar(int year, int month, int day) {
        Gregorian gregorian = new Gregorian(year, month, day);
        return DPCNCalendar.gregorianToLunar(gregorian);
    }

    static Festivals[][] buildMonthFestivals(int year, int month) {
        int[][] gregorianMonth = DPCNCalendar.buildMonthGregorian(year, month);
        Gregorian gregorian = new Gregorian(2000, 1, 1);
        Festivals[][] tmp = new Festivals[6][7];
        for (int i = 0; i < tmp.length; ++i) {
            for (int j = 0; j < tmp[0].length; ++j) {
                if (gregorianMonth[i][j] == -1) continue;
                tmp[i][j] = new Festivals();
                gregorian.reset(year, month, gregorianMonth[i][j]);
                Lunar lunar = DPCNCalendar.gregorianToLunar(gregorian);
                String result = DPCNCalendar.getFestivalLunar(lunar);
                if (TextUtils.isNotEmpty(result)) {
                    tmp[i][j].add(result);
                }
                if (TextUtils.isNotEmpty(result = DPCNCalendar.getFestivalGregorian(gregorian))) {
                    tmp[i][j].add(result);
                }
                if (!TextUtils.isNotEmpty(result = DPCNCalendar.getSolarTerm(year, month, gregorian.day))) continue;
                tmp[i][j].add(result);
            }
        }
        return tmp;
    }

    static Festivals buildDayFestivals(int year, int month, int day) {
        Gregorian gregorian = new Gregorian(year, month, day);
        Festivals festivals = new Festivals();
        gregorian.reset(year, month, day);
        Lunar lunar = DPCNCalendar.gregorianToLunar(gregorian);
        String result = DPCNCalendar.getFestivalLunar(lunar);
        if (TextUtils.isNotEmpty(result)) {
            festivals.add(result);
        }
        if (TextUtils.isNotEmpty(result = DPCNCalendar.getFestivalGregorian(gregorian))) {
            festivals.add(result);
        }
        if (TextUtils.isNotEmpty(result = DPCNCalendar.getSolarTerm(year, month, gregorian.day))) {
            festivals.add(result);
        }
        return festivals;
    }

    static String getSolarTerm(int year, int month, int day) {
        String[] stOfMonth;
        String[][] tmp = CACHE_SOLAR_TERM.get(year);
        if (null == tmp) {
            tmp = mSolarTerm.buildSolarTerm(year);
            CACHE_SOLAR_TERM.put(year, tmp);
        }
        if (Integer.valueOf((stOfMonth = tmp[month - 1])[0]) == day) {
            return SOLAR_TERM[month - 1][0];
        }
        if (Integer.valueOf(stOfMonth[1]) == day) {
            return SOLAR_TERM[month - 1][1];
        }
        return null;
    }

    private static String getFestivalLunar(Lunar lunar) {
        int[] daysInMonth = FESTIVAL_LUNAR_DATE[lunar.month - 1];
        for (int i = 0; i < daysInMonth.length; ++i) {
            if (lunar.day != daysInMonth[i]) continue;
            return FESTIVAL_L[lunar.month - 1][i];
        }
        return null;
    }

    private static String getFestivalGregorian(Gregorian gregorian) {
        int[] daysInMonth = FESTIVAL_G_DATE[gregorian.month - 1];
        for (int i = 0; i < daysInMonth.length; ++i) {
            if (gregorian.day != daysInMonth[i]) continue;
            return FESTIVAL_GREGORIAN[gregorian.month - 1][i];
        }
        return null;
    }

    private static Lunar gregorianToLunar(Gregorian gregorian) {
        int index = gregorian.year - DAYS_AND_LEAP_MONTH_OF_LUNAR[0];
        int data = gregorian.year << 9 | gregorian.month << 5 | gregorian.day;
        if (DAYS_AND_LEAP_MONTH_OF_LUNAR[index] > data) {
            --index;
        }
        int lunarFirstDayInGregorian = DAYS_AND_LEAP_MONTH_OF_LUNAR[index];
        int y = DPCNCalendar.getBitInt(lunarFirstDayInGregorian, 12, 9);
        int m = DPCNCalendar.getBitInt(lunarFirstDayInGregorian, 4, 5);
        int d = DPCNCalendar.getBitInt(lunarFirstDayInGregorian, 5, 0);
        long offset = DPCNCalendar.gregorianToNum(gregorian.year, gregorian.month, gregorian.day) - DPCNCalendar.gregorianToNum(y, m, d);
        int days = FIRST_DAY_OF_LUNAR_IN_GREGORIAN[index];
        int leap = DPCNCalendar.getBitInt(days, 4, 13);
        int lunarY = index + DAYS_AND_LEAP_MONTH_OF_LUNAR[0];
        int lunarM = 1;
        ++offset;
        for (int i = 0; i < 13; ++i) {
            int dm;
            int n = dm = DPCNCalendar.getBitInt(days, 1, 12 - i) == 1 ? 30 : 29;
            if (offset <= (long)dm) break;
            ++lunarM;
            offset -= (long)dm;
        }
        int lunarD = (int)offset;
        Lunar lunar = new Lunar(lunarY, lunarM, lunarD);
        lunar.isLeap = false;
        if (leap != 0 && lunarM > leap) {
            lunar.month = lunarM - 1;
            if (lunarM == leap + 1) {
                lunar.isLeap = true;
            }
        }
        return lunar;
    }

    private static boolean isLeapYear(int year) {
        return year % 4 == 0 && year % 100 != 0 || year % 400 == 0;
    }

    static boolean isToday(LunarCalendar day) {
        Calendar c1 = Calendar.getInstance();
        Calendar c2 = Calendar.getInstance();
        c1.set(day.getYear(), day.getMonth() - 1, day.getDay());
        return c1.get(1) == c2.get(1) && c1.get(2) == c2.get(2) && c1.get(5) == c2.get(5);
    }

    static int[][] buildMonthGregorian(int year, int month) {
        calendar.clear();
        int[][] tmp = new int[6][7];
        calendar.set(year, month - 1, 1);
        int daysInMonth = DPCNCalendar.getDaysInMonth(year, month);
        int dayOfWeek = calendar.get(7) - 1;
        int day = 1;
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 7; ++j) {
                tmp[i][j] = -1;
                if (i == 0 && j >= dayOfWeek) {
                    tmp[i][j] = day++;
                    continue;
                }
                if (i <= 0 || day > daysInMonth) continue;
                tmp[i][j] = day++;
            }
        }
        return tmp;
    }

    private static int getDaysInMonth(int year, int month) {
        if (month == 4 || month == 6 || month == 9 || month == 11) {
            return 30;
        }
        if (month == 2) {
            if (DPCNCalendar.isLeapYear(year)) {
                return 29;
            }
            return 28;
        }
        return 31;
    }

    static Set<Integer> buildMonthWeekend(int year, int month) {
        HashSet<Integer> set = new HashSet<Integer>();
        calendar.clear();
        calendar.set(year, month - 1, 1);
        do {
            int day;
            if ((day = calendar.get(7)) == 7 || day == 1) {
                set.add(calendar.get(5));
            }
            calendar.add(6, 1);
        } while (calendar.get(2) == month - 1);
        return set;
    }

    private static long gregorianToNum(int year, int month, int day) {
        month = (month + 9) % 12;
        return 365 * (year -= month / 10) + year / 4 - year / 100 + year / 400 + (month * 306 + 5) / 10 + (day - 1);
    }

    private static int getBitInt(int data, int length, int shift) {
        return (data & (1 << length) - 1 << shift) >> shift;
    }
}

