/*
 * Decompiled with CFR 0.152.
 */
package com.xhinliang.lunarcalendar;

import com.xhinliang.lunarcalendar.DPCManager;
import com.xhinliang.lunarcalendar.DPCNCalendar;
import com.xhinliang.lunarcalendar.Festivals;
import com.xhinliang.lunarcalendar.Lunar;
import com.xhinliang.lunarcalendar.utils.TextUtils;
import java.util.Date;
import java.util.GregorianCalendar;

public class LunarCalendar {
    private static final String[] MONTH_NAME = new String[]{"\u96f6", "\u6b63", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d", "\u5341", "\u51ac", "\u814a"};
    private boolean isToday;
    private boolean isWeekend;
    private String solarTerm;
    private Festivals festivals;
    private int year;
    private int month;
    private int day;
    private Lunar lunar;

    public Lunar getLunar() {
        if (this.lunar == null) {
            this.lunar = DPCNCalendar.getLunar(this.year, this.month, this.day);
        }
        return this.lunar;
    }

    LunarCalendar(int year, int month, int day) {
        this.year = year;
        this.month = month;
        this.day = day;
    }

    public static LunarCalendar obtainCalendar(int year, int month, int day) {
        return DPCManager.getInstance().getDPInfo(year, month, day);
    }

    public static LunarCalendar[][] obtainCalendar(int year, int month) {
        return DPCManager.getInstance().obtainDPInfo(year, month);
    }

    void setFestivals(Festivals festivals) {
        this.festivals = festivals;
    }

    void setIsToday(boolean isToday) {
        this.isToday = isToday;
    }

    void setSolarTerm(String solarTerm) {
        this.solarTerm = solarTerm;
    }

    void setIsWeekend(boolean isWeekend) {
        this.isWeekend = isWeekend;
    }

    public Festivals getFestivals() {
        if (this.festivals == null) {
            this.festivals = DPCNCalendar.buildDayFestivals(this.year, this.month, this.day);
        }
        return this.festivals;
    }

    public String getSolarTerm() {
        return this.solarTerm;
    }

    public Date getDate() {
        GregorianCalendar calendar = new GregorianCalendar(this.year, this.month - 1, this.day);
        return calendar.getTime();
    }

    public long getMillis() {
        return this.getDate().getTime();
    }

    public boolean isWeekend() {
        return this.isWeekend;
    }

    public boolean isToday() {
        return this.isToday;
    }

    public int getDay() {
        return this.day;
    }

    public int getMonth() {
        return this.month;
    }

    public int getYear() {
        return this.year;
    }

    public String getLunarDay() {
        this.checkLunar();
        char[] c = String.valueOf(this.lunar.day).toCharArray();
        return TextUtils.lunarNumToStr(c);
    }

    private void checkLunar() {
        if (this.lunar == null) {
            this.lunar = this.getLunar();
        }
    }

    public String getLunarMonth() {
        this.checkLunar();
        return MONTH_NAME[this.lunar.month];
    }

    public String getLunarYear() {
        this.checkLunar();
        return TextUtils.getChineseNumber(this.lunar.year);
    }

    public String getFullLunarStr() {
        this.checkLunar();
        return String.format("%s\u5e74%s\u6708%s", this.getLunarYear(), this.getLunarMonth(), this.getLunarDay());
    }

    public String getSubTitle() {
        if (!this.festivals.getSet().isEmpty()) {
            return this.festivals.getSet().iterator().next();
        }
        if (this.solarTerm != null) {
            return this.solarTerm;
        }
        return this.getLunarDay();
    }

    public String toString() {
        return "LunarCalendar{isToday=" + this.isToday + ", isWeekend=" + this.isWeekend + ", solarTerm='" + this.solarTerm + '\'' + ", festivals=" + this.festivals + ", year=" + this.year + ", month=" + this.month + ", day=" + this.day + '}';
    }
}

