/*
 * Decompiled with CFR 0.152.
 */
package com.xhinliang.lunarcalendar.utils;

public class TextUtils {
    private static final String[] LUNAR_HEADER = new String[]{"\u521d", "\u5341", "\u5eff", "\u5345", "\u6b63", "\u814a", "\u51ac", "\u95f0"};
    private static final String[] NUMBER_CAPITAL = new String[]{"\u96f6", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d", "\u5341"};

    private TextUtils() {
    }

    public static boolean isNotEmpty(String string) {
        return string != null && string.length() != 0;
    }

    public static String getChineseNumber(int number) {
        StringBuilder builder = new StringBuilder();
        int bit = TextUtils.getBit(number);
        int temp = (int)Math.pow(10.0, bit - 1);
        for (int i = 0; i < bit; ++i) {
            int num = number / temp;
            builder.append(NUMBER_CAPITAL[num]);
            number %= temp;
            temp /= 10;
        }
        return builder.toString();
    }

    private static int getBit(int number) {
        int temp = 10;
        int bit = 1;
        while (number / temp != 0) {
            temp *= 10;
            ++bit;
        }
        return bit;
    }

    static String[][] arraysConvert(String[] src, int column) {
        int row = src.length / column;
        String[][] tmp = new String[row][src.length / row];
        for (int i = 0; i < row; ++i) {
            tmp[i] = new String[column];
            System.arraycopy(src, i * column, tmp[i], 0, column);
        }
        return tmp;
    }

    public static String lunarNumToStr(char[] c) {
        String result = "";
        if (c.length == 1) {
            for (int i = 1; i < 10; ++i) {
                if (c[0] != String.valueOf(i).charAt(0)) continue;
                result = LUNAR_HEADER[0] + NUMBER_CAPITAL[i];
            }
        } else if (c[0] == '1') {
            if (c[1] == '0') {
                result = LUNAR_HEADER[0] + LUNAR_HEADER[1];
            } else {
                for (int i = 1; i < 10; ++i) {
                    if (c[1] != String.valueOf(i).charAt(0)) continue;
                    result = LUNAR_HEADER[1] + NUMBER_CAPITAL[i];
                }
            }
        } else if (c[0] == '2') {
            if (c[1] == '0') {
                result = LUNAR_HEADER[2] + LUNAR_HEADER[1];
            } else {
                for (int i = 1; i < 10; ++i) {
                    if (c[1] != String.valueOf(i).charAt(0)) continue;
                    result = LUNAR_HEADER[2] + NUMBER_CAPITAL[i];
                }
            }
        } else if (c[1] == '0') {
            result = LUNAR_HEADER[3] + LUNAR_HEADER[1];
        } else {
            for (int i = 1; i < 10; ++i) {
                if (c[1] != String.valueOf(i).charAt(0)) continue;
                result = LUNAR_HEADER[3] + NUMBER_CAPITAL[i];
            }
        }
        return result;
    }
}

