/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.convert.impl;

import com.xiaoleilu.hutool.convert.AbstractConverter;
import com.xiaoleilu.hutool.date.DateUtil;
import com.xiaoleilu.hutool.util.StrUtil;
import java.sql.Timestamp;
import java.util.Calendar;

public class SqlTimestampConverter
extends AbstractConverter<Timestamp> {
    private String format;

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    @Override
    protected Timestamp convertInternal(Object value) {
        if (value instanceof Calendar) {
            return new Timestamp(((Calendar)value).getTime().getTime());
        }
        if (value instanceof Long) {
            return new Timestamp((Long)value);
        }
        String valueStr = this.convertToStr(value);
        try {
            long date = StrUtil.isBlank(this.format) ? DateUtil.parse(valueStr).getTime() : DateUtil.parse(valueStr, this.format).getTime();
            return new Timestamp(date);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

