/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.http;

import com.xiaoleilu.hutool.http.CookiePool;
import com.xiaoleilu.hutool.http.Header;
import com.xiaoleilu.hutool.http.HttpException;
import com.xiaoleilu.hutool.http.HttpUtil;
import com.xiaoleilu.hutool.http.Method;
import com.xiaoleilu.hutool.http.ssl.SSLSocketFactoryBuilder;
import com.xiaoleilu.hutool.http.ssl.TrustAnyHostnameVerifier;
import com.xiaoleilu.hutool.lang.Validator;
import com.xiaoleilu.hutool.log.Log;
import com.xiaoleilu.hutool.log.LogFactory;
import com.xiaoleilu.hutool.util.CollectionUtil;
import com.xiaoleilu.hutool.util.ObjectUtil;
import com.xiaoleilu.hutool.util.StrUtil;
import com.xiaoleilu.hutool.util.URLUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;

public class HttpConnection {
    private static final Log log = LogFactory.get();
    private URL url;
    private Method method;
    private Proxy proxy;
    private HttpURLConnection conn;

    public static HttpConnection create(String urlStr, Method method) {
        return new HttpConnection(urlStr, method);
    }

    public static HttpConnection create(String urlStr, Method method, int timeout) {
        return new HttpConnection(urlStr, method, timeout);
    }

    public static HttpConnection create(String urlStr, Method method, HostnameVerifier hostnameVerifier, SSLSocketFactory ssf) {
        return new HttpConnection(urlStr, method, hostnameVerifier, ssf, 0, null);
    }

    public static HttpConnection create(String urlStr, Method method, HostnameVerifier hostnameVerifier, SSLSocketFactory ssf, int timeout, Proxy proxy) {
        return new HttpConnection(urlStr, method, hostnameVerifier, ssf, timeout, proxy);
    }

    public HttpConnection(String urlStr, Method method) {
        this(urlStr, method, null, null, 0, null);
    }

    public HttpConnection(String urlStr, Method method, int timeout) {
        this(urlStr, method, null, null, timeout, null);
    }

    public HttpConnection(String urlStr, Method method, HostnameVerifier hostnameVerifier, SSLSocketFactory ssf, int timeout, Proxy proxy) {
        if (StrUtil.isBlank(urlStr)) {
            throw new HttpException("Url is blank !");
        }
        if (!Validator.isUrl(urlStr)) {
            throw new HttpException("{} is not a url !", urlStr);
        }
        this.url = URLUtil.url(urlStr);
        this.method = ObjectUtil.isNull((Object)method) ? Method.GET : method;
        this.proxy = proxy;
        try {
            this.conn = HttpUtil.isHttps(urlStr) ? this.openHttps(hostnameVerifier, ssf) : this.openHttp();
        }
        catch (Exception e) {
            throw new HttpException(e.getMessage(), e);
        }
        if (timeout > 0) {
            this.setConnectionAndReadTimeout(timeout);
        }
        this.initConn();
    }

    public HttpConnection initConn() {
        try {
            this.conn.setRequestMethod(this.method.toString());
        }
        catch (ProtocolException e) {
            throw new HttpException(e.getMessage(), e);
        }
        this.conn.setDoInput(true);
        if (Method.POST.equals((Object)this.method) || Method.PUT.equals((Object)this.method) || Method.PATCH.equals((Object)this.method) || Method.DELETE.equals((Object)this.method)) {
            this.conn.setDoOutput(true);
            this.conn.setUseCaches(false);
        }
        this.header(Header.ACCEPT, "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8", true);
        this.header(Header.ACCEPT_ENCODING, "gzip", true);
        this.header(Header.CONTENT_TYPE, "application/x-www-form-urlencoded", true);
        this.header(Header.USER_AGENT, "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:36.0) Gecko/20100101 Firefox/36.0 Hutool", true);
        this.setCookie(CookiePool.get(this.url.getHost()));
        return this;
    }

    public Method getMethod() {
        return this.method;
    }

    public HttpConnection setMethod(Method method) {
        this.method = method;
        return this;
    }

    public URL getUrl() {
        return this.url;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public HttpURLConnection getHttpURLConnection() {
        return this.conn;
    }

    public HttpConnection header(String header, String value, boolean isOverride) {
        if (null != this.conn) {
            if (isOverride) {
                this.conn.setRequestProperty(header, value);
            } else {
                this.conn.addRequestProperty(header, value);
            }
        }
        return this;
    }

    public HttpConnection header(Header header, String value, boolean isOverride) {
        return this.header(header.toString(), value, isOverride);
    }

    public HttpConnection header(Map<String, List<String>> headers, boolean isOverride) {
        if (CollectionUtil.isNotEmpty(headers)) {
            for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
                String name = entry.getKey();
                for (String value : entry.getValue()) {
                    this.header(name, StrUtil.nullToEmpty(value), isOverride);
                }
            }
        }
        return this;
    }

    public String header(String name) {
        return this.conn.getHeaderField(name);
    }

    public String header(Header name) {
        return this.header(name.toString());
    }

    public Map<String, List<String>> headers() {
        return this.conn.getHeaderFields();
    }

    public HttpConnection disableCache() {
        this.conn.setUseCaches(false);
        return this;
    }

    public HttpConnection setConnectTimeout(int timeout) {
        if (timeout > 0 && null != this.conn) {
            this.conn.setConnectTimeout(timeout);
        }
        return this;
    }

    public HttpConnection setReadTimeout(int timeout) {
        if (timeout > 0 && null != this.conn) {
            this.conn.setReadTimeout(timeout);
        }
        return this;
    }

    public HttpConnection setConnectionAndReadTimeout(int timeout) {
        this.setConnectTimeout(timeout);
        this.setReadTimeout(timeout);
        return this;
    }

    public HttpConnection setCookie(String cookie) {
        if (cookie != null) {
            this.header(Header.COOKIE, cookie, true);
        }
        return this;
    }

    public HttpConnection setChunkedStreamingMode(int blockSize) {
        this.conn.setChunkedStreamingMode(blockSize);
        return this;
    }

    public HttpConnection setInstanceFollowRedirects(boolean isInstanceFollowRedirects) {
        this.conn.setInstanceFollowRedirects(isInstanceFollowRedirects);
        return this;
    }

    public HttpConnection connect() throws IOException {
        if (null != this.conn) {
            this.conn.connect();
        }
        return this;
    }

    public HttpConnection disconnect() {
        if (null != this.conn) {
            this.conn.disconnect();
        }
        return this;
    }

    public InputStream getInputStream() throws IOException {
        String setCookie = this.header(Header.SET_COOKIE);
        if (!StrUtil.isBlank(setCookie)) {
            log.debug("Set cookie: [{}]", setCookie);
            CookiePool.put(this.url.getHost(), setCookie);
        }
        if (null != this.conn) {
            return this.conn.getInputStream();
        }
        return null;
    }

    public InputStream getErrorStream() throws IOException {
        if (null != this.conn) {
            return this.conn.getErrorStream();
        }
        return null;
    }

    public OutputStream getOutputStream() throws IOException {
        if (null == this.conn) {
            throw new IOException("HttpURLConnection has not been initialized.");
        }
        return this.conn.getOutputStream();
    }

    public int responseCode() throws IOException {
        if (null != this.conn) {
            return this.conn.getResponseCode();
        }
        return 0;
    }

    public String charset() {
        return HttpUtil.getCharset(this.conn);
    }

    public String toString() {
        StringBuilder sb = StrUtil.builder();
        sb.append("Request URL: ").append(this.url).append("\r\n");
        sb.append("Request Method: ").append((Object)this.method).append("\r\n");
        return sb.toString();
    }

    private HttpURLConnection openHttp() throws IOException {
        return (HttpURLConnection)this.openConnection();
    }

    private HttpsURLConnection openHttps(HostnameVerifier hostnameVerifier, SSLSocketFactory ssf) throws IOException, NoSuchAlgorithmException, KeyManagementException {
        HttpsURLConnection httpsURLConnection = (HttpsURLConnection)this.openConnection();
        httpsURLConnection.setHostnameVerifier(null != hostnameVerifier ? hostnameVerifier : new TrustAnyHostnameVerifier());
        httpsURLConnection.setSSLSocketFactory(null != ssf ? ssf : SSLSocketFactoryBuilder.create().build());
        return httpsURLConnection;
    }

    private URLConnection openConnection() throws IOException {
        return null == this.proxy ? this.url.openConnection() : this.url.openConnection(this.proxy);
    }
}

