/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.cron;

import com.xiaoleilu.hutool.cron.CronException;
import com.xiaoleilu.hutool.cron.Scheduler;
import com.xiaoleilu.hutool.cron.pattern.CronPattern;
import com.xiaoleilu.hutool.cron.task.Task;
import java.util.ArrayList;
import java.util.TimeZone;

public class TaskTable {
    private Scheduler scheduler;
    private TimeZone timezone;
    private ArrayList<String> ids = new ArrayList();
    private ArrayList<CronPattern> patterns = new ArrayList();
    private ArrayList<Task> tasks = new ArrayList();
    private int size;

    public TaskTable(Scheduler scheduler) {
        this.scheduler = scheduler;
        this.timezone = scheduler.getTimeZone();
    }

    public TaskTable add(String id, CronPattern pattern, Task task) {
        if (this.ids.contains(id)) {
            throw new CronException("Id [{}] has been existed!", id);
        }
        this.ids.add(id);
        this.patterns.add(pattern);
        this.tasks.add(task);
        ++this.size;
        return this;
    }

    public synchronized void remove(String id) throws IndexOutOfBoundsException {
        int index = this.ids.indexOf(id);
        if (index > -1) {
            this.tasks.remove(index);
            this.patterns.remove(index);
            this.ids.remove(index);
        }
    }

    public void executeTaskIfMatch(long millis, boolean isMatchSecond, boolean isMatchYear) {
        for (int i = 0; i < this.size; ++i) {
            if (!this.patterns.get(i).match(this.timezone, millis, isMatchSecond, isMatchYear)) continue;
            this.scheduler.taskExecutorManager.spawnExecutor(this.tasks.get(i));
        }
    }

    public void executeTaskIfMatch(long millis) {
        this.executeTaskIfMatch(millis, this.scheduler.matchSecond, this.scheduler.matchYear);
    }
}

