/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.date;

import com.xiaoleilu.hutool.date.BetweenFormater;
import com.xiaoleilu.hutool.date.DateBetween;
import com.xiaoleilu.hutool.date.DateException;
import com.xiaoleilu.hutool.date.DateField;
import com.xiaoleilu.hutool.date.DatePattern;
import com.xiaoleilu.hutool.date.DateUnit;
import com.xiaoleilu.hutool.date.DateUtil;
import com.xiaoleilu.hutool.date.Month;
import com.xiaoleilu.hutool.date.Season;
import com.xiaoleilu.hutool.date.Week;
import com.xiaoleilu.hutool.date.format.DateParser;
import com.xiaoleilu.hutool.date.format.DatePrinter;
import com.xiaoleilu.hutool.date.format.FastDateFormat;
import com.xiaoleilu.hutool.util.ObjectUtil;
import com.xiaoleilu.hutool.util.StrUtil;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;

public class DateTime
extends java.util.Date {
    private static final long serialVersionUID = -5395712593979185936L;
    private boolean mutable = true;

    public static DateTime of(java.util.Date date) {
        return new DateTime(date);
    }

    public static DateTime of(Calendar calendar) {
        return new DateTime(calendar);
    }

    public static DateTime of(String dateStr, String format) {
        return new DateTime(dateStr, format);
    }

    public static DateTime now() {
        return new DateTime();
    }

    public DateTime() {
    }

    public DateTime(java.util.Date date) {
        this(date.getTime());
    }

    public DateTime(Calendar calendar) {
        this(calendar.getTime());
    }

    public DateTime(long timeMillis) {
        super(timeMillis);
    }

    public DateTime(String dateStr, String format) {
        this(dateStr, FastDateFormat.getInstance(format));
    }

    public DateTime(String dateStr, DateFormat dateFormat) {
        this(DateTime.parse(dateStr, dateFormat));
    }

    public DateTime(String dateStr, DateParser dateParser) {
        this(DateTime.parse(dateStr, dateParser));
    }

    public DateTime offsite(DateField datePart, int offsite) {
        Calendar cal = this.toCalendar();
        cal.add(datePart.getValue(), offsite);
        DateTime dt = this.mutable ? this : ObjectUtil.clone(this);
        return dt.setTimeInternal(cal.getTimeInMillis());
    }

    public DateTime offsiteNew(DateField datePart, int offsite) {
        Calendar cal = this.toCalendar();
        cal.add(datePart.getValue(), offsite);
        DateTime dt = ObjectUtil.clone(this);
        return dt.setTimeInternal(cal.getTimeInMillis());
    }

    public int getField(DateField field) {
        return this.getField(field.getValue());
    }

    public int getField(int field) {
        return this.toCalendar().get(field);
    }

    public DateTime setField(DateField field, int value) {
        return this.setField(field.getValue(), value);
    }

    public DateTime setField(int field, int value) {
        Calendar calendar = this.toCalendar();
        calendar.set(field, value);
        DateTime dt = this;
        if (!this.mutable) {
            dt = ObjectUtil.clone(this);
        }
        return dt.setTimeInternal(calendar.getTimeInMillis());
    }

    @Override
    public void setTime(long time) {
        if (!this.mutable) {
            throw new DateException("This is not a mutable object !");
        }
        super.setTime(time);
    }

    public int year() {
        return this.getField(DateField.YEAR);
    }

    public int season() {
        return this.monthStartFromOne() / 3 + 1;
    }

    public Season seasonEnum() {
        return Season.of(this.season());
    }

    public int month() {
        return this.getField(DateField.MONTH);
    }

    public int monthStartFromOne() {
        return this.month() + 1;
    }

    public Month monthEnum() {
        return Month.of(this.month());
    }

    public int weekOfYear() {
        return this.getField(DateField.WEEK_OF_YEAR);
    }

    public int weekOfMonth() {
        return this.getField(DateField.WEEK_OF_MONTH);
    }

    public int dayOfMonth() {
        return this.getField(DateField.DAY_OF_MONTH);
    }

    public int dayOfWeek() {
        return this.getField(DateField.DAY_OF_WEEK);
    }

    public int dayOfWeekInMonth() {
        return this.getField(DateField.DAY_OF_WEEK_IN_MONTH);
    }

    public Week dayOfWeekEnum() {
        return Week.of(this.dayOfWeek());
    }

    public int hour(boolean is24HourClock) {
        return this.getField(is24HourClock ? DateField.HOUR_OF_DAY : DateField.HOUR);
    }

    public int minute() {
        return this.getField(DateField.MINUTE);
    }

    public int second() {
        return this.getField(DateField.SECOND);
    }

    public int millsecond() {
        return this.getField(DateField.MILLISECOND);
    }

    public boolean isAM() {
        return 0 == this.getField(DateField.AM_PM);
    }

    public boolean isPM() {
        return 1 == this.getField(DateField.AM_PM);
    }

    public boolean isLeapYear() {
        return DateUtil.isLeapYear(this.year());
    }

    public Calendar toCalendar() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(this);
        return cal;
    }

    public Calendar toCalendar(Locale locale) {
        Calendar cal = Calendar.getInstance(locale);
        cal.setTime(this);
        return cal;
    }

    public Calendar toCalendar(TimeZone zone) {
        return this.toCalendar(zone, Locale.getDefault(Locale.Category.FORMAT));
    }

    public Calendar toCalendar(TimeZone zone, Locale locale) {
        Calendar cal = Calendar.getInstance(zone, locale);
        cal.setTime(this);
        return cal;
    }

    public Timestamp toTimestamp() {
        return new Timestamp(this.getTime());
    }

    public Date toSqlDate() {
        return new Date(this.getTime());
    }

    public DateBetween between(java.util.Date date) {
        return new DateBetween(this, date);
    }

    public long between(java.util.Date date, DateUnit unit) {
        return new DateBetween(this, date).between(unit);
    }

    public String between(java.util.Date date, DateUnit unit, BetweenFormater.Level formatLevel) {
        return new DateBetween(this, date).toString(formatLevel);
    }

    public boolean isIn(java.util.Date beginDate, java.util.Date endDate) {
        long beginMills = beginDate.getTime();
        long endMills = endDate.getTime();
        long thisMills = this.getTime();
        return thisMills >= Math.min(beginMills, endMills) && thisMills <= Math.max(beginMills, endMills);
    }

    public boolean isBeforeOrEquals(java.util.Date date) {
        if (null == date) {
            throw new NullPointerException("Date to compare is null !");
        }
        return this.compareTo(date) <= 0;
    }

    public boolean isAfterOrEquals(java.util.Date date) {
        if (null == date) {
            throw new NullPointerException("Date to compare is null !");
        }
        return this.compareTo(date) >= 0;
    }

    public boolean isMutable() {
        return this.mutable;
    }

    public DateTime setMutable(boolean mutable) {
        this.mutable = mutable;
        return this;
    }

    @Override
    public String toString() {
        return this.toString(DatePattern.NORM_DATETIME_FORMAT);
    }

    public String toString(String format) {
        return this.toString(FastDateFormat.getInstance(format));
    }

    public String toString(DatePrinter format) {
        return format.format(this);
    }

    public String toString(DateFormat format) {
        return format.format(this);
    }

    public String toMsStr() {
        return this.toString(DatePattern.NORM_DATETIME_MS_FORMAT);
    }

    private static java.util.Date parse(String dateStr, DateFormat dateFormat) {
        try {
            return dateFormat.parse(dateStr);
        }
        catch (Exception e) {
            String pattern = dateFormat instanceof SimpleDateFormat ? ((SimpleDateFormat)dateFormat).toPattern() : dateFormat.toString();
            throw new DateException(StrUtil.format((CharSequence)"Parse [{}] with format [{}] error!", dateStr, pattern), e);
        }
    }

    private static java.util.Date parse(String dateStr, DateParser parser) {
        try {
            return parser.parse(dateStr);
        }
        catch (Exception e) {
            throw new DateException(StrUtil.format((CharSequence)"Parse [{}] with format [{}] error!", dateStr, parser.getPattern()), e);
        }
    }

    private DateTime setTimeInternal(long time) {
        super.setTime(time);
        return this;
    }
}

