/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.db.dialect.impl;

import com.xiaoleilu.hutool.db.DbRuntimeException;
import com.xiaoleilu.hutool.db.DbUtil;
import com.xiaoleilu.hutool.db.Page;
import com.xiaoleilu.hutool.db.dialect.DialectName;
import com.xiaoleilu.hutool.db.dialect.impl.AnsiSqlDialect;
import com.xiaoleilu.hutool.db.sql.Query;
import com.xiaoleilu.hutool.db.sql.SqlBuilder;
import com.xiaoleilu.hutool.util.StrUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class OracleDialect
extends AnsiSqlDialect {
    @Override
    public PreparedStatement psForPage(Connection conn, Query query) throws SQLException {
        if (query == null || StrUtil.hasBlank(query.getTableNames())) {
            throw new DbRuntimeException("Table name is null !");
        }
        Page page = query.getPage();
        if (null == page) {
            return super.psForFind(conn, query);
        }
        SqlBuilder find = SqlBuilder.create(this.wrapper).query(query).orderBy(page.getOrders());
        int[] startEnd = page.getStartEnd();
        SqlBuilder sql = SqlBuilder.create(this.wrapper);
        sql.append("SELECT * FROM ( SELECT row_.*, rownum rownum_ from ( ").append(find).append(" ) row_ where rownum <= ").append(startEnd[1]).append(") table_alias").append(" where table_alias.rownum_ >= ").append(startEnd[0]);
        PreparedStatement ps = conn.prepareStatement(sql.build());
        DbUtil.fillParams(ps, find.getParamValues());
        return ps;
    }

    @Override
    public DialectName dialectName() {
        return DialectName.ORACLE;
    }
}

