/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.db.ds.dbcp;

import com.xiaoleilu.hutool.db.DbRuntimeException;
import com.xiaoleilu.hutool.db.DbUtil;
import com.xiaoleilu.hutool.db.ds.DSFactory;
import com.xiaoleilu.hutool.io.IoUtil;
import com.xiaoleilu.hutool.setting.Setting;
import com.xiaoleilu.hutool.util.CollectionUtil;
import com.xiaoleilu.hutool.util.StrUtil;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;

public class DbcpDSFactory
extends DSFactory {
    public static final String DS_NAME = "Common-DBCP2";
    private Map<String, BasicDataSource> dsMap = new ConcurrentHashMap<String, BasicDataSource>();

    public DbcpDSFactory() {
        this(null);
    }

    public DbcpDSFactory(Setting setting) {
        super(DS_NAME, BasicDataSource.class, setting);
    }

    @Override
    public synchronized DataSource getDataSource(String group) {
        BasicDataSource existedDataSource;
        if (group == null) {
            group = "";
        }
        if ((existedDataSource = this.dsMap.get(group)) != null) {
            return existedDataSource;
        }
        BasicDataSource ds = this.createDataSource(group);
        this.dsMap.put(group, ds);
        return ds;
    }

    @Override
    public void close(String group) {
        BasicDataSource ds;
        if (group == null) {
            group = "";
        }
        if ((ds = this.dsMap.get(group)) != null) {
            IoUtil.close((AutoCloseable)ds);
            this.dsMap.remove(group);
        }
    }

    @Override
    public void destroy() {
        if (CollectionUtil.isNotEmpty(this.dsMap)) {
            Collection<BasicDataSource> values = this.dsMap.values();
            for (BasicDataSource ds : values) {
                IoUtil.close((AutoCloseable)ds);
            }
            this.dsMap.clear();
        }
    }

    private BasicDataSource createDataSource(String group) {
        Setting config = this.setting.getSetting(group);
        if (CollectionUtil.isEmpty(config)) {
            throw new DbRuntimeException("No DBCP config for group: [{}]", group);
        }
        BasicDataSource ds = new BasicDataSource();
        ds.setUrl(this.getAndRemoveProperty(config, "url", "jdbcUrl"));
        ds.setUsername(this.getAndRemoveProperty(config, "username", "user"));
        ds.setPassword(this.getAndRemoveProperty(config, "password", "pass"));
        String driver = this.getAndRemoveProperty(config, "driver", "driverClassName");
        if (StrUtil.isNotBlank(driver)) {
            ds.setDriverClassName(driver);
        } else {
            ds.setDriverClassName(DbUtil.identifyDriver(ds.getUrl()));
        }
        config.toBean(ds);
        return ds;
    }

    private String getAndRemoveProperty(Setting setting, String key1, String key2) {
        String value = (String)setting.remove(key1);
        if (StrUtil.isBlank(value)) {
            value = (String)setting.remove(key2);
        }
        return value;
    }
}

