/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.util;

import com.xiaoleilu.hutool.collection.EnumerationIterator;
import com.xiaoleilu.hutool.collection.IteratorEnumeration;
import com.xiaoleilu.hutool.convert.Convert;
import com.xiaoleilu.hutool.convert.ConverterRegistry;
import com.xiaoleilu.hutool.exceptions.UtilException;
import com.xiaoleilu.hutool.lang.BoundedPriorityQueue;
import com.xiaoleilu.hutool.lang.Editor;
import com.xiaoleilu.hutool.lang.Matcher;
import com.xiaoleilu.hutool.util.ArrayUtil;
import com.xiaoleilu.hutool.util.ClassUtil;
import com.xiaoleilu.hutool.util.ObjectUtil;
import com.xiaoleilu.hutool.util.PageUtil;
import com.xiaoleilu.hutool.util.StrUtil;
import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;

public class CollectionUtil {
    private CollectionUtil() {
    }

    public static <T> Collection<T> union(Collection<T> coll1, Collection<T> coll2) {
        ArrayList<Object> list = new ArrayList<Object>();
        if (CollectionUtil.isEmpty(coll1)) {
            list.addAll(coll2);
        } else if (CollectionUtil.isEmpty(coll2)) {
            list.addAll(coll1);
        } else {
            Map<T, Integer> map1 = CollectionUtil.countMap(coll1);
            Map<T, Integer> map2 = CollectionUtil.countMap(coll2);
            HashSet elts = CollectionUtil.newHashSet(coll2);
            for (Object t : elts) {
                int m = Math.max(Convert.toInt(map1.get(t), 0), Convert.toInt(map2.get(t), 0));
                for (int i = 0; i < m; ++i) {
                    list.add(t);
                }
            }
        }
        return list;
    }

    @SafeVarargs
    public static <T> Collection<T> union(Collection<T> coll1, Collection<T> coll2, Collection<T> ... otherColls) {
        Collection<T> union = CollectionUtil.union(coll1, coll2);
        for (Collection<T> coll : otherColls) {
            union = CollectionUtil.union(union, coll);
        }
        return union;
    }

    public static <T> Collection<T> intersection(Collection<T> coll1, Collection<T> coll2) {
        ArrayList list = new ArrayList();
        if (CollectionUtil.isNotEmpty(coll1) && CollectionUtil.isNotEmpty(coll2)) {
            Map<T, Integer> map1 = CollectionUtil.countMap(coll1);
            Map<T, Integer> map2 = CollectionUtil.countMap(coll2);
            HashSet elts = CollectionUtil.newHashSet(coll2);
            for (Object t : elts) {
                int m = Math.min(Convert.toInt(map1.get(t), 0), Convert.toInt(map2.get(t), 0));
                for (int i = 0; i < m; ++i) {
                    list.add(t);
                }
            }
        }
        return list;
    }

    @SafeVarargs
    public static <T> Collection<T> intersection(Collection<T> coll1, Collection<T> coll2, Collection<T> ... otherColls) {
        Collection<T> intersection = CollectionUtil.intersection(coll1, coll2);
        if (CollectionUtil.isEmpty(intersection)) {
            return intersection;
        }
        for (Collection<T> coll : otherColls) {
            if (!CollectionUtil.isEmpty(intersection = CollectionUtil.intersection(intersection, coll))) continue;
            return intersection;
        }
        return intersection;
    }

    public static <T> Collection<T> disjunction(Collection<T> coll1, Collection<T> coll2) {
        ArrayList list = new ArrayList();
        if (CollectionUtil.isNotEmpty(coll1) && CollectionUtil.isNotEmpty(coll2)) {
            Map<T, Integer> map1 = CollectionUtil.countMap(coll1);
            Map<T, Integer> map2 = CollectionUtil.countMap(coll2);
            HashSet elts = CollectionUtil.newHashSet(coll2);
            for (Object t : elts) {
                int m = Math.max(Convert.toInt(map1.get(t), 0), Convert.toInt(map2.get(t), 0)) - Math.min(Convert.toInt(map1.get(t), 0), Convert.toInt(map2.get(t), 0));
                for (int i = 0; i < m; ++i) {
                    list.add(t);
                }
            }
        }
        return list;
    }

    public static boolean containsAny(Collection<?> coll1, Collection<?> coll2) {
        if (CollectionUtil.isEmpty(coll1) || CollectionUtil.isEmpty(coll2)) {
            return false;
        }
        if (coll1.size() < coll2.size()) {
            for (Object object : coll1) {
                if (!coll2.contains(object)) continue;
                return true;
            }
        } else {
            for (Object object : coll2) {
                if (!coll1.contains(object)) continue;
                return true;
            }
        }
        return false;
    }

    public static <T> Map<T, Integer> countMap(Collection<T> collection) {
        HashMap<T, Integer> countMap = new HashMap<T, Integer>();
        for (T t : collection) {
            Integer count = (Integer)countMap.get(t);
            if (null == count) {
                countMap.put(t, 1);
                continue;
            }
            countMap.put(t, count + 1);
        }
        return countMap;
    }

    public static <T> String join(Iterable<T> iterable, CharSequence conjunction) {
        if (null == iterable) {
            return null;
        }
        return CollectionUtil.join(iterable.iterator(), conjunction);
    }

    public static <T> String join(Iterator<T> iterator, CharSequence conjunction) {
        if (null == iterator) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        while (iterator.hasNext()) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(conjunction);
            }
            T item = iterator.next();
            if (ArrayUtil.isArray(item)) {
                sb.append(ArrayUtil.join(ArrayUtil.wrap(item), conjunction));
                continue;
            }
            if (item instanceof Iterable) {
                sb.append(CollectionUtil.join((Iterable)item, conjunction));
                continue;
            }
            if (item instanceof Iterator) {
                sb.append(CollectionUtil.join((Iterator)item, conjunction));
                continue;
            }
            sb.append(item);
        }
        return sb.toString();
    }

    public static <T> List<T> popPart(Stack<T> surplusAlaDatas, int partSize) {
        if (CollectionUtil.isEmpty(surplusAlaDatas)) {
            return null;
        }
        ArrayList<T> currentAlaDatas = new ArrayList<T>();
        int size = surplusAlaDatas.size();
        if (size > partSize) {
            for (int i = 0; i < partSize; ++i) {
                currentAlaDatas.add(surplusAlaDatas.pop());
            }
        } else {
            for (int i = 0; i < size; ++i) {
                currentAlaDatas.add(surplusAlaDatas.pop());
            }
        }
        return currentAlaDatas;
    }

    public static <T> List<T> popPart(Deque<T> surplusAlaDatas, int partSize) {
        if (CollectionUtil.isEmpty(surplusAlaDatas)) {
            return null;
        }
        ArrayList<T> currentAlaDatas = new ArrayList<T>();
        int size = surplusAlaDatas.size();
        if (size > partSize) {
            for (int i = 0; i < partSize; ++i) {
                currentAlaDatas.add(surplusAlaDatas.pop());
            }
        } else {
            for (int i = 0; i < size; ++i) {
                currentAlaDatas.add(surplusAlaDatas.pop());
            }
        }
        return currentAlaDatas;
    }

    public static <K, V> HashMap<K, V> newHashMap() {
        return new HashMap();
    }

    public static <K, V> HashMap<K, V> newHashMap(int size, boolean isOrder) {
        int initialCapacity = (int)((double)size / 0.75);
        return isOrder ? new LinkedHashMap(initialCapacity) : new HashMap(initialCapacity);
    }

    public static <K, V> HashMap<K, V> newHashMap(int size) {
        return CollectionUtil.newHashMap(size, false);
    }

    @SafeVarargs
    public static <T> HashSet<T> newHashSet(T ... ts) {
        return CollectionUtil.newHashSet(false, ts);
    }

    @SafeVarargs
    public static <T> HashSet<T> newHashSet(boolean isSorted, T ... ts) {
        if (null == ts) {
            return isSorted ? new LinkedHashSet() : new HashSet();
        }
        int initialCapacity = Math.max((int)((float)ts.length / 0.75f) + 1, 16);
        HashSet set = isSorted ? new LinkedHashSet(initialCapacity) : new HashSet(initialCapacity);
        for (T t : ts) {
            set.add(t);
        }
        return set;
    }

    public static <T> HashSet<T> newHashSet(Collection<T> collection) {
        return CollectionUtil.newHashSet(false, collection);
    }

    public static <T> HashSet<T> newHashSet(boolean isSorted, Collection<T> collection) {
        return isSorted ? new LinkedHashSet<T>(collection) : new HashSet<T>(collection);
    }

    public static <T> HashSet<T> newHashSet(boolean isSorted, Iterator<T> iter) {
        HashSet set;
        if (null == iter) {
            return CollectionUtil.newHashSet(isSorted, (Object[])null);
        }
        HashSet hashSet = set = isSorted ? new LinkedHashSet() : new HashSet();
        while (iter.hasNext()) {
            set.add(iter.next());
        }
        return set;
    }

    public static <T> HashSet<T> newHashSet(boolean isSorted, Enumeration<T> enumration) {
        HashSet set;
        if (null == enumration) {
            return CollectionUtil.newHashSet(isSorted, (Object[])null);
        }
        HashSet hashSet = set = isSorted ? new LinkedHashSet() : new HashSet();
        while (enumration.hasMoreElements()) {
            set.add(enumration.nextElement());
        }
        return set;
    }

    @SafeVarargs
    public static <T> ArrayList<T> newArrayList(T ... values) {
        if (null == values) {
            return new ArrayList();
        }
        ArrayList<T> arrayList = new ArrayList<T>(values.length);
        for (T t : values) {
            arrayList.add(t);
        }
        return arrayList;
    }

    public static <T> ArrayList<T> newArrayList(Collection<T> collection) {
        if (null == collection) {
            return new ArrayList();
        }
        return new ArrayList<T>(collection);
    }

    public static <T> ArrayList<T> newArrayList(Iterator<T> iter) {
        ArrayList<T> list = new ArrayList<T>();
        if (null == iter) {
            return list;
        }
        while (iter.hasNext()) {
            list.add(iter.next());
        }
        return list;
    }

    public static <T> ArrayList<T> newArrayList(Enumeration<T> enumration) {
        ArrayList<T> list = new ArrayList<T>();
        if (null == enumration) {
            return list;
        }
        while (enumration.hasMoreElements()) {
            list.add(enumration.nextElement());
        }
        return list;
    }

    public static <T> CopyOnWriteArrayList<T> newCopyOnWriteArrayList(Collection<T> collection) {
        return null == collection ? new CopyOnWriteArrayList() : new CopyOnWriteArrayList<T>(collection);
    }

    public static <T> Collection<T> create(Class<?> collectionType) {
        Collection<Object> list = null;
        if (collectionType.isAssignableFrom(AbstractCollection.class)) {
            list = new ArrayList();
        } else if (collectionType.isAssignableFrom(HashSet.class)) {
            list = new HashSet();
        } else if (collectionType.isAssignableFrom(LinkedHashSet.class)) {
            list = new LinkedHashSet();
        } else if (collectionType.isAssignableFrom(TreeSet.class)) {
            list = new TreeSet();
        } else if (collectionType.isAssignableFrom(EnumSet.class)) {
            list = EnumSet.noneOf(ClassUtil.getTypeArgument(collectionType));
        } else if (collectionType.isAssignableFrom(ArrayList.class)) {
            list = new ArrayList();
        } else if (collectionType.isAssignableFrom(LinkedList.class)) {
            list = new LinkedList();
        } else {
            try {
                list = (Collection)ClassUtil.newInstance(collectionType);
            }
            catch (Exception e) {
                throw new UtilException(e);
            }
        }
        return list;
    }

    public static <K, V> Map<K, V> createMap(Class<?> mapType) {
        if (mapType.isAssignableFrom(AbstractMap.class)) {
            return new HashMap();
        }
        try {
            return (Map)ClassUtil.newInstance(mapType);
        }
        catch (Exception e) {
            throw new UtilException(e);
        }
    }

    public static <T> ArrayList<T> distinct(Collection<T> collection) {
        if (CollectionUtil.isEmpty(collection)) {
            return new ArrayList();
        }
        if (collection instanceof Set) {
            return new ArrayList<T>(collection);
        }
        return new ArrayList<T>(new LinkedHashSet<T>(collection));
    }

    public static <T> List<T> sub(List<T> list, int start, int end) {
        int size;
        if (list == null || list.isEmpty()) {
            return null;
        }
        if (start < 0) {
            start = 0;
        }
        if (end < 0) {
            end = 0;
        }
        if (start > end) {
            int tmp = start;
            start = end;
            end = tmp;
        }
        if (end > (size = list.size())) {
            if (start >= size) {
                return null;
            }
            end = size;
        }
        return list.subList(start, end);
    }

    public static <T> List<T> sub(Collection<T> list, int start, int end) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        return CollectionUtil.sub(new ArrayList<T>(list), start, end);
    }

    public static <T> List<List<T>> split(Collection<T> collection, int size) {
        ArrayList<List<T>> result = new ArrayList<List<T>>();
        ArrayList<T> subList = new ArrayList<T>(size);
        for (T t : collection) {
            if (subList.size() > size) {
                result.add(subList);
                subList = new ArrayList(size);
            }
            subList.add(t);
        }
        result.add(subList);
        return result;
    }

    public static <T> Collection<T> filter(Collection<T> collection, Editor<T> editor) {
        Collection<T> collection2 = ObjectUtil.clone(collection);
        collection2.clear();
        for (T t : collection) {
            T modified = editor.edit(t);
            if (null == modified) continue;
            collection2.add(t);
        }
        return collection2;
    }

    public static <K, V> Map<K, V> filter(Map<K, V> map, Editor<Map.Entry<K, V>> editor) {
        Map<K, V> map2 = ObjectUtil.clone(map);
        map2.clear();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            Map.Entry<K, V> modified = editor.edit(entry);
            if (null == modified) continue;
            map2.put(entry.getKey(), entry.getValue());
        }
        return map2;
    }

    public static <T> int count(Iterable<T> iterable, Matcher<T> matcher) {
        int count = 0;
        for (T t : iterable) {
            if (null != matcher && !matcher.match(t)) continue;
            ++count;
        }
        return count;
    }

    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static boolean isEmpty(Iterable<?> iterable) {
        return null == iterable || CollectionUtil.isEmpty(iterable.iterator());
    }

    public static boolean isEmpty(Iterator<?> Iterator2) {
        return null == Iterator2 || false == Iterator2.hasNext();
    }

    public static boolean isEmpty(Enumeration<?> enumeration) {
        return null == enumeration || false == enumeration.hasMoreElements();
    }

    public static boolean isNotEmpty(Collection<?> collection) {
        return false == CollectionUtil.isEmpty(collection);
    }

    public static boolean isNotEmpty(Map<?, ?> map) {
        return false == CollectionUtil.isEmpty(map);
    }

    public static boolean isNotEmpty(Iterable<?> iterable) {
        return null != iterable && CollectionUtil.isNotEmpty(iterable.iterator());
    }

    public static boolean isNotEmpty(Iterator<?> Iterator2) {
        return null != Iterator2 && Iterator2.hasNext();
    }

    public static boolean isNotEmpty(Enumeration<?> enumeration) {
        return null != enumeration && enumeration.hasMoreElements();
    }

    public static boolean hasNull(Iterable<?> iterable) {
        if (CollectionUtil.isNotEmpty(iterable)) {
            for (Object element : iterable) {
                if (null != element) continue;
                return true;
            }
        }
        return false;
    }

    public static Map<String, String> zip(String keys, String values, String delimiter, boolean isOrder) {
        return ArrayUtil.zip(StrUtil.split((CharSequence)keys, delimiter), StrUtil.split((CharSequence)values, delimiter), isOrder);
    }

    public static Map<String, String> zip(String keys, String values, String delimiter) {
        return CollectionUtil.zip(keys, values, delimiter, false);
    }

    public static <K, V> Map<K, V> zip(Collection<K> keys, Collection<V> values) {
        if (CollectionUtil.isEmpty(keys) || CollectionUtil.isEmpty(values)) {
            return null;
        }
        ArrayList<K> keyList = new ArrayList<K>(keys);
        ArrayList<V> valueList = new ArrayList<V>(values);
        int size = Math.min(keys.size(), values.size());
        HashMap map = new HashMap((int)((double)size / 0.75));
        for (int i = 0; i < size; ++i) {
            map.put(keyList.get(i), valueList.get(i));
        }
        return map;
    }

    public static <K, V> HashMap<K, V> toMap(Collection<Map.Entry<K, V>> entryCollection) {
        HashMap<K, V> map = new HashMap<K, V>();
        if (CollectionUtil.isNotEmpty(entryCollection)) {
            for (Map.Entry<K, V> entry : entryCollection) {
                map.put(entry.getKey(), entry.getValue());
            }
        }
        return map;
    }

    public static HashMap<Object, Object> toMap(Object[] array) {
        if (array == null) {
            return null;
        }
        HashMap<Object, Object> map = new HashMap<Object, Object>((int)((double)array.length * 1.5));
        for (int i = 0; i < array.length; ++i) {
            Object value;
            Object key;
            Iterator iter;
            Object[] entry;
            Object object = array[i];
            if (object instanceof Map.Entry) {
                entry = (Object[])object;
                map.put(entry.getKey(), entry.getValue());
                continue;
            }
            if (object instanceof Object[]) {
                entry = (Object[])object;
                if (entry.length <= 1) continue;
                map.put(entry[0], entry[1]);
                continue;
            }
            if (object instanceof Iterable) {
                iter = ((Iterable)object).iterator();
                if (!iter.hasNext()) continue;
                key = iter.next();
                if (!iter.hasNext()) continue;
                value = iter.next();
                map.put(key, value);
                continue;
            }
            if (object instanceof Iterator) {
                iter = (Iterator)object;
                if (!iter.hasNext()) continue;
                key = iter.next();
                if (!iter.hasNext()) continue;
                value = iter.next();
                map.put(key, value);
                continue;
            }
            throw new IllegalArgumentException(StrUtil.format((CharSequence)"Array element {}, '{}', is not type of Map.Entry or Array or Iterable or Iterator", i, object));
        }
        return map;
    }

    public static <T> TreeSet<T> toTreeSet(Collection<T> collection, Comparator<T> comparator) {
        TreeSet<T> treeSet = new TreeSet<T>(comparator);
        for (T t : collection) {
            treeSet.add(t);
        }
        return treeSet;
    }

    public static <E> Enumeration<E> asEnumeration(Iterator<E> iter) {
        return new IteratorEnumeration<E>(iter);
    }

    public static <E> Iterator<E> asIterator(Enumeration<E> e) {
        return new EnumerationIterator<E>(e);
    }

    public static <E> Iterable<E> asIterable(final Iterator<E> iter) {
        return new Iterable<E>(){

            @Override
            public Iterator<E> iterator() {
                return iter;
            }
        };
    }

    public static <E> Collection<E> toCollection(Iterable<E> iterable) {
        return iterable instanceof Collection ? (ArrayList<E>)iterable : CollectionUtil.newArrayList(iterable.iterator());
    }

    public static <T> Collection<T> addAll(Collection<T> collection, Object value) {
        return CollectionUtil.addAll(collection, value, ClassUtil.getTypeArgument(collection.getClass()));
    }

    public static <T> Collection<T> addAll(Collection<T> collection, Object value, Class<?> elementType) {
        block7: {
            ConverterRegistry convert;
            block10: {
                block9: {
                    block8: {
                        block6: {
                            if (null == collection || null == value) {
                                return collection;
                            }
                            if (null == elementType) {
                                elementType = Object.class;
                            }
                            convert = ConverterRegistry.getInstance();
                            if (!elementType.isInstance(value)) break block6;
                            collection.add(value);
                            break block7;
                        }
                        if (!(value instanceof Iterator)) break block8;
                        Iterator iter = (Iterator)value;
                        while (iter.hasNext()) {
                            collection.add(convert.convert(elementType, iter.next()));
                        }
                        CollectionUtil.addAll(collection, (Iterator)value);
                        break block7;
                    }
                    if (!(value instanceof Iterable)) break block9;
                    Iterator iter = ((Iterable)value).iterator();
                    while (iter.hasNext()) {
                        collection.add(convert.convert(elementType, iter.next()));
                    }
                    break block7;
                }
                if (!(value instanceof Enumeration)) break block10;
                Enumeration enumeration = (Enumeration)value;
                while (enumeration.hasMoreElements()) {
                    collection.add(convert.convert(elementType, enumeration.nextElement()));
                }
                break block7;
            }
            if (!ArrayUtil.isArray(value)) break block7;
            int length = Array.getLength(value);
            for (int i = 0; i < length; ++i) {
                Object item = Array.get(value, i);
                collection.add(convert.convert(elementType, item));
            }
        }
        return collection;
    }

    public static <T> Collection<T> addAll(Collection<T> collection, Iterator<T> iterator) {
        if (null != collection && null != iterator) {
            while (iterator.hasNext()) {
                collection.add(iterator.next());
            }
        }
        return collection;
    }

    public static <T> Collection<T> addAll(Collection<T> collection, Iterable<T> iterable) {
        return CollectionUtil.addAll(collection, iterable.iterator());
    }

    public static <T> Collection<T> addAll(Collection<T> collection, Enumeration<T> enumeration) {
        if (null != collection && null != enumeration) {
            while (enumeration.hasMoreElements()) {
                collection.add(enumeration.nextElement());
            }
        }
        return collection;
    }

    public static <T> Collection<T> addAll(Collection<T> collection, T[] values) {
        if (null != collection && null != values) {
            for (T value : values) {
                collection.add(value);
            }
        }
        return collection;
    }

    public static <T> List<T> addAllIfNotContains(List<T> list, List<T> otherList) {
        for (T t : otherList) {
            if (list.contains(t)) continue;
            list.add(t);
        }
        return list;
    }

    public static <T> T getFirst(Iterable<T> iterable) {
        if (null != iterable) {
            return CollectionUtil.getFirst(iterable.iterator());
        }
        return null;
    }

    public static <T> T getFirst(Iterator<T> iterator) {
        if (null != iterator && iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    public static Class<?> getElementType(Iterable<?> iterable) {
        if (null != iterable) {
            Iterator<?> iterator = iterable.iterator();
            return CollectionUtil.getElementType(iterator);
        }
        return null;
    }

    public static Class<?> getElementType(Iterator<?> iterator) {
        if (null != iterator) {
            while (iterator.hasNext()) {
                Object t = iterator.next();
                if (null == t) continue;
                return t.getClass();
            }
        }
        return null;
    }

    public static <K, V> ArrayList<V> valuesOfKeys(Map<K, V> map, K ... keys) {
        ArrayList<V> values = new ArrayList<V>();
        for (K k : keys) {
            values.add(map.get(k));
        }
        return values;
    }

    public static <K, V> ArrayList<V> valuesOfKeys(Map<K, V> map, Iterable<K> keys) {
        return CollectionUtil.valuesOfKeys(map, keys.iterator());
    }

    public static <K, V> ArrayList<V> valuesOfKeys(Map<K, V> map, Iterator<K> keys) {
        ArrayList<V> values = new ArrayList<V>();
        while (keys.hasNext()) {
            values.add(map.get(keys.next()));
        }
        return values;
    }

    @SafeVarargs
    public static <T> List<T> sortPageAll(int pageNo, int numPerPage, Comparator<T> comparator, Collection<T> ... colls) {
        ArrayList<T> result = new ArrayList<T>();
        for (Collection<T> coll : colls) {
            result.addAll(coll);
        }
        Collections.sort(result, comparator);
        int resultSize = result.size();
        if (resultSize <= numPerPage) {
            return result;
        }
        int[] startEnd = PageUtil.transToStartEnd(pageNo, numPerPage);
        if (startEnd[1] > resultSize) {
            return new ArrayList();
        }
        return result.subList(startEnd[0], startEnd[1]);
    }

    @SafeVarargs
    public static <T> List<T> sortPageAll2(int pageNo, int numPerPage, Comparator<T> comparator, Collection<T> ... colls) {
        BoundedPriorityQueue<T> queue = new BoundedPriorityQueue<T>(pageNo * numPerPage, comparator);
        for (Collection<T> coll : colls) {
            queue.addAll(coll);
        }
        int resultSize = queue.size();
        if (resultSize <= numPerPage) {
            return queue.toList();
        }
        int[] startEnd = PageUtil.transToStartEnd(pageNo, numPerPage);
        if (startEnd[1] > resultSize) {
            return new ArrayList();
        }
        return queue.toList().subList(startEnd[0], startEnd[1]);
    }

    public static <T> List<T> sort(Collection<T> collection, Comparator<? super T> comparator) {
        ArrayList<T> list = new ArrayList<T>(collection);
        Collections.sort(list, comparator);
        return list;
    }

    public static <T> List<T> sort(List<T> list, Comparator<? super T> c) {
        Collections.sort(list, c);
        return list;
    }

    public static <K, V> TreeMap<K, V> sort(Map<K, V> map, Comparator<? super K> comparator) {
        TreeMap<K, V> result = new TreeMap<K, V>(comparator);
        result.putAll(map);
        return result;
    }

    public static <K, V> LinkedHashMap<K, V> sortToMap(Collection<Map.Entry<K, V>> entryCollection, Comparator<Map.Entry<K, V>> comparator) {
        LinkedList<Map.Entry<K, V>> list = new LinkedList<Map.Entry<K, V>>(entryCollection);
        Collections.sort(list, comparator);
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry entry : list) {
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public static <K, V> LinkedHashMap<K, V> sortByEntry(Map<K, V> map, Comparator<Map.Entry<K, V>> comparator) {
        return CollectionUtil.sortToMap(map.entrySet(), comparator);
    }

    public static <K, V> List<Map.Entry<K, V>> sortEntryToList(Collection<Map.Entry<K, V>> collection) {
        LinkedList<Map.Entry<K, V>> list = new LinkedList<Map.Entry<K, V>>(collection);
        Collections.sort(list, new Comparator<Map.Entry<K, V>>(){

            @Override
            public int compare(Map.Entry<K, V> o1, Map.Entry<K, V> o2) {
                Object v1 = o1.getValue();
                Object v2 = o2.getValue();
                if (v1 instanceof Comparable) {
                    return ((Comparable)v1).compareTo(v2);
                }
                return v1.toString().compareTo(v2.toString());
            }
        });
        return list;
    }

    public static <T> void forEach(Iterator<T> iterator, Consumer<T> consumer) {
        int index = 0;
        while (iterator.hasNext()) {
            consumer.accept(iterator.next(), index);
            ++index;
        }
    }

    public static <T> void forEach(Enumeration<T> enumeration, Consumer<T> consumer) {
        int index = 0;
        while (enumeration.hasMoreElements()) {
            consumer.accept(enumeration.nextElement(), index);
            ++index;
        }
    }

    public static <K, V> void forEach(Map<K, V> map, KVConsumer<K, V> kvConsumer) {
        int index = 0;
        for (Map.Entry<K, V> entry : map.entrySet()) {
            kvConsumer.accept(entry.getKey(), entry.getValue(), index);
            ++index;
        }
    }

    public static interface KVConsumer<K, V> {
        public void accept(K var1, V var2, int var3);
    }

    public static interface Consumer<T> {
        public void accept(T var1, int var2);
    }
}

