/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.crypto.symmetric;

import com.xiaoleilu.hutool.crypto.Mode;
import com.xiaoleilu.hutool.crypto.Padding;
import com.xiaoleilu.hutool.crypto.SecureUtil;
import com.xiaoleilu.hutool.crypto.symmetric.SymmetricAlgorithm;
import com.xiaoleilu.hutool.crypto.symmetric.SymmetricCrypto;
import com.xiaoleilu.hutool.util.StrUtil;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;

public class AES
extends SymmetricCrypto {
    public AES() {
        super(SymmetricAlgorithm.AES);
    }

    public AES(byte[] key) {
        super(SymmetricAlgorithm.AES, key);
    }

    public AES(Mode mode, Padding padding) {
        this(mode.name(), padding.name());
    }

    public AES(Mode mode, Padding padding, byte[] key) {
        this(mode, padding, key, null);
    }

    public AES(Mode mode, Padding padding, byte[] key, byte[] iv) {
        this(mode.name(), padding.name(), key, iv);
    }

    public AES(Mode mode, Padding padding, SecretKey key) {
        this(mode, padding, key, null);
    }

    public AES(Mode mode, Padding padding, SecretKey key, IvParameterSpec iv) {
        this(mode.name(), padding.name(), key, iv);
    }

    public AES(String mode, String padding) {
        this(mode, padding, (byte[])null);
    }

    public AES(String mode, String padding, byte[] key) {
        this(mode, padding, SecureUtil.generateKey("AES", key), null);
    }

    public AES(String mode, String padding, byte[] key, byte[] iv) {
        this(mode, padding, SecureUtil.generateKey("AES", key), null == iv ? null : new IvParameterSpec(iv));
    }

    public AES(String mode, String padding, SecretKey key) {
        this(mode, padding, key, null);
    }

    public AES(String mode, String padding, SecretKey key, IvParameterSpec iv) {
        super(StrUtil.format((CharSequence)"AES/{}/{}", mode, padding), key, iv);
    }

    public AES setIv(IvParameterSpec iv) {
        super.setParams(iv);
        return this;
    }

    public AES setIv(byte[] iv) {
        this.setIv(new IvParameterSpec(iv));
        return this;
    }
}

