/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoleilu.hutool.db;

import com.xiaoleilu.hutool.collection.CollectionUtil;
import com.xiaoleilu.hutool.db.DbUtil;
import com.xiaoleilu.hutool.db.Entity;
import com.xiaoleilu.hutool.db.Page;
import com.xiaoleilu.hutool.db.PageResult;
import com.xiaoleilu.hutool.db.SqlConnRunner;
import com.xiaoleilu.hutool.db.handler.BeanListHandler;
import com.xiaoleilu.hutool.db.handler.EntityHandler;
import com.xiaoleilu.hutool.db.handler.EntityListHandler;
import com.xiaoleilu.hutool.db.handler.NumberHandler;
import com.xiaoleilu.hutool.db.handler.RsHandler;
import com.xiaoleilu.hutool.db.handler.StringHandler;
import com.xiaoleilu.hutool.db.sql.Condition;
import com.xiaoleilu.hutool.db.sql.SqlExecutor;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;

public abstract class AbstractSqlRunner {
    protected SqlConnRunner runner;

    public abstract Connection getConnection() throws SQLException;

    public abstract void closeConnection(Connection var1);

    public List<Entity> query(String sql, Object ... params) throws SQLException {
        return this.query(sql, new EntityListHandler(), params);
    }

    public <T> List<T> query(String sql, Class<T> beanClass, Object ... params) throws SQLException {
        return (List)this.query(sql, new BeanListHandler<T>(beanClass), params);
    }

    public Entity queryOne(String sql, Object ... params) throws SQLException {
        return this.query(sql, new EntityHandler(), params);
    }

    public Number queryNumber(String sql, Object ... params) throws SQLException {
        return this.query(sql, new NumberHandler(), params);
    }

    public String queryString(String sql, Object ... params) throws SQLException {
        return this.query(sql, new StringHandler(), params);
    }

    public <T> T query(String sql, RsHandler<T> rsh, Object ... params) throws SQLException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            T t = SqlExecutor.query(conn, sql, rsh, params);
            return t;
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    public int execute(String sql, Object ... params) throws SQLException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            int n = SqlExecutor.execute(conn, sql, params);
            return n;
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    public Long executeForGeneratedKey(String sql, Object ... params) throws SQLException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            Long l = SqlExecutor.executeForGeneratedKey(conn, sql, params);
            return l;
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    public int[] executeBatch(String sql, Object[] ... paramsBatch) throws SQLException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            int[] nArray = SqlExecutor.executeBatch(conn, sql, paramsBatch);
            return nArray;
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    public int insert(Entity record) throws SQLException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            int n = this.runner.insert(conn, record);
            return n;
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    public int[] insert(Collection<Entity> records) throws SQLException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            int[] nArray = this.runner.insert(conn, records);
            return nArray;
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    public List<Object> insertForGeneratedKeys(Entity record) throws SQLException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            List<Object> list = this.runner.insertForGeneratedKeys(conn, record);
            return list;
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    public Long insertForGeneratedKey(Entity record) throws SQLException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            Long l = this.runner.insertForGeneratedKey(conn, record);
            return l;
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    public int del(String tableName, String field, Object value) throws SQLException {
        return this.del(Entity.create(tableName).set(field, value));
    }

    public int del(Entity where) throws SQLException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            int n = this.runner.del(conn, where);
            return n;
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    public int update(Entity record, Entity where) throws SQLException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            int n = this.runner.update(conn, record, where);
            return n;
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    public <T> Entity get(String tableName, String field, T value) throws SQLException {
        return this.get(Entity.create(tableName).set(field, value));
    }

    public Entity get(Entity where) throws SQLException {
        return this.find(where.getFieldNames(), where, new EntityHandler());
    }

    public <T> T find(Collection<String> fields, Entity where, RsHandler<T> rsh) throws SQLException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            T t = this.runner.find(conn, fields, where, rsh);
            return t;
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    public <T> T find(Entity where, RsHandler<T> rsh, String ... fields) throws SQLException {
        return this.find(CollectionUtil.newArrayList(fields), where, rsh);
    }

    public List<Entity> find(Entity where) throws SQLException {
        return this.find(where.getFieldNames(), where, EntityListHandler.create());
    }

    public <T> List<T> find(Entity where, Class<T> beanClass) throws SQLException {
        return (List)this.find(where.getFieldNames(), where, BeanListHandler.create(beanClass));
    }

    public List<Entity> findAll(Entity where) throws SQLException {
        return this.find(where, EntityListHandler.create(), new String[0]);
    }

    public <T> List<T> findAll(Entity where, Class<T> beanClass) throws SQLException {
        return (List)this.find(where, BeanListHandler.create(beanClass), new String[0]);
    }

    public List<Entity> findAll(String tableName) throws SQLException {
        return this.findAll(Entity.create(tableName));
    }

    public List<Entity> findBy(String tableName, String field, Object value) throws SQLException {
        return this.findAll(Entity.create(tableName).set(field, value));
    }

    public List<Entity> findLike(String tableName, String field, String value, Condition.LikeType likeType) throws SQLException {
        return this.findAll(Entity.create(tableName).set(field, DbUtil.buildLikeValue(value, likeType)));
    }

    public int count(Entity where) throws SQLException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            int n = this.runner.count(conn, where);
            return n;
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    public <T> T page(Collection<String> fields, Entity where, int page, int numPerPage, RsHandler<T> rsh) throws SQLException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            T t = this.runner.page(conn, fields, where, page, numPerPage, rsh);
            return t;
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    public <T> T page(Entity where, int page, int numPerPage, RsHandler<T> rsh) throws SQLException {
        return this.page(where, new Page(page, numPerPage), rsh);
    }

    public List<Entity> pageForEntityList(Entity where, int page, int numPerPage) throws SQLException {
        return this.pageForEntityList(where, new Page(page, numPerPage));
    }

    public List<Entity> pageForEntityList(Entity where, Page page) throws SQLException {
        return this.page(where, page, EntityListHandler.create());
    }

    public <T> T page(Entity where, Page page, RsHandler<T> rsh) throws SQLException {
        return this.page(where.getFieldNames(), where, page, rsh);
    }

    public <T> T page(Collection<String> fields, Entity where, Page page, RsHandler<T> rsh) throws SQLException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            T t = this.runner.page(conn, fields, where, page, rsh);
            return t;
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    public PageResult<Entity> page(Collection<String> fields, Entity where, int page, int numPerPage) throws SQLException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            PageResult<Entity> pageResult = this.runner.page(conn, fields, where, page, numPerPage);
            return pageResult;
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    public PageResult<Entity> page(Collection<String> fields, Entity where, Page page) throws SQLException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            PageResult<Entity> pageResult = this.runner.page(conn, fields, where, page);
            return pageResult;
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    public PageResult<Entity> page(Entity where, int page, int numPerPage) throws SQLException {
        return this.page(where, new Page(page, numPerPage));
    }

    public PageResult<Entity> page(Entity where, Page page) throws SQLException {
        return this.page(where.getFieldNames(), where, page);
    }

    public SqlConnRunner getRunner() {
        return this.runner;
    }

    public void setRunner(SqlConnRunner runner) {
        this.runner = runner;
    }
}

