/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.billingclient.api;

import androidx.annotation.NonNull;
import com.xiaomi.billingclient.api.SkuDetails;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class BillingFlowParams {
    private final SkuDetails mSkuDetails;
    private final SubscriptionUpdateParams mSubscriptionUpdateParams;
    private final boolean mIsOfferPersonalized;
    private final String mObfuscatedAccountId;
    private final String mObfuscatedProfileId;
    private final String mWebHookUrl;
    private final String mOfferToken;

    private BillingFlowParams(Builder builder) {
        this.mSkuDetails = builder.skuDetails;
        this.mSubscriptionUpdateParams = builder.subscriptionUpdateParams;
        this.mIsOfferPersonalized = builder.isOfferPersonalized;
        this.mObfuscatedAccountId = builder.obfuscatedAccountId;
        this.mObfuscatedProfileId = builder.obfuscatedProfileId;
        this.mWebHookUrl = builder.webHookUrl;
        this.mOfferToken = builder.offerToken;
    }

    public static Builder newBuilder() {
        return new Builder(null);
    }

    public /* synthetic */ BillingFlowParams(Builder builder, a a2) {
        this(builder);
    }

    public SkuDetails getSkuDetails() {
        return this.mSkuDetails;
    }

    public SubscriptionUpdateParams getSubscriptionUpdateParams() {
        return this.mSubscriptionUpdateParams;
    }

    public boolean isOfferPersonalized() {
        return this.mIsOfferPersonalized;
    }

    public String getObfuscatedAccountId() {
        return this.mObfuscatedAccountId;
    }

    public String getObfuscatedProfileId() {
        return this.mObfuscatedProfileId;
    }

    public String getWebHookUrl() {
        return this.mWebHookUrl;
    }

    public String getOfferToken() {
        return this.mOfferToken;
    }

    public static class SubscriptionUpdateParams {
        private final String mOldPurchaseToken;
        private final int mSubscriptionReplacementMode;

        private SubscriptionUpdateParams(Builder builder) {
            this.mOldPurchaseToken = builder.oldPurchaseToken;
            this.mSubscriptionReplacementMode = builder.subscriptionReplacementMode;
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public /* synthetic */ SubscriptionUpdateParams(Builder builder, a a2) {
            this(builder);
        }

        public String getOldPurchaseToken() {
            return this.mOldPurchaseToken;
        }

        public int getSubscriptionReplacementMode() {
            return this.mSubscriptionReplacementMode;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface ReplacementMode {
            public static final int IMMEDIATE_WITH_TIME_PRORATION = 1;
            public static final int IMMEDIATE_AND_CHARGE_PRORATED_PRICE = 2;
            public static final int IMMEDIATE_WITHOUT_PRORATION = 3;
            public static final int IMMEDIATE_AND_CHARGE_FULL_PRICE = 5;
            public static final int DEFERRED = 6;
        }

        public static final class Builder {
            private String oldPurchaseToken;
            private int subscriptionReplacementMode;

            public Builder setOldPurchaseToken(@NonNull String string) {
                this.oldPurchaseToken = string;
                return this;
            }

            public Builder setSubscriptionReplacementMode(int n2) {
                this.subscriptionReplacementMode = n2;
                return this;
            }

            public SubscriptionUpdateParams build() {
                return new SubscriptionUpdateParams(this, null);
            }
        }
    }

    public static class Builder {
        private SkuDetails skuDetails;
        private SubscriptionUpdateParams subscriptionUpdateParams;
        private boolean isOfferPersonalized;
        private String obfuscatedAccountId;
        private String obfuscatedProfileId;
        private String webHookUrl;
        private String offerToken;

        private Builder() {
        }

        public /* synthetic */ Builder(a a2) {
            this();
        }

        public Builder setSkuDetails(SkuDetails skuDetails) {
            this.skuDetails = skuDetails;
            return this;
        }

        public Builder setOfferToken(String string) {
            this.offerToken = string;
            return this;
        }

        @NonNull
        public Builder setSubscriptionUpdateParams(@NonNull SubscriptionUpdateParams subscriptionUpdateParams) {
            this.subscriptionUpdateParams = subscriptionUpdateParams;
            return this;
        }

        @NonNull
        public Builder setIsOfferPersonalized(boolean bl) {
            this.isOfferPersonalized = bl;
            return this;
        }

        public Builder setObfuscatedAccountId(String string) {
            this.obfuscatedAccountId = string;
            return this;
        }

        public Builder setObfuscatedProfileId(String string) {
            this.obfuscatedProfileId = string;
            return this;
        }

        public Builder setWebHookUrl(String string) {
            this.webHookUrl = string;
            return this;
        }

        public BillingFlowParams build() {
            return new BillingFlowParams(this, null);
        }
    }
}

