/*
 * Decompiled with CFR 0.152.
 */
package org.jupyterkernel.console;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.script.ScriptException;
import org.json.XML;
import org.jupyterkernel.console.InteractiveConsole;
import org.jupyterkernel.console.JythonConsole;
import org.jupyterkernel.json.messages.T_kernel_info_reply;
import org.jupyterkernel.json.messages.T_language_info;

public class ClojureConsole
extends InteractiveConsole {
    public ClojureConsole() {
        super("clojure");
    }

    @Override
    public String getMIMEType() {
        if (this.ex != null) {
            return "text/html";
        }
        return "text/plain";
    }

    @Override
    protected void setErrorMessage() {
        StringWriter sw = new StringWriter();
        this.ex.getCause().printStackTrace(new PrintWriter(sw));
        String err = sw.toString();
        String[] tb = err.split("\n\n");
        String traceback = tb.length <= 2 ? XML.escape((String)tb[0]) : XML.escape((String)(tb[0] + "\n" + tb[1]));
        this.stderrWriter.write("<pre><font color=\"red\">" + traceback + "</font></pre>");
    }

    @Override
    public Object eval(String codeString) {
        Object res = null;
        this.ex = null;
        try {
            res = this.engine.eval(codeString);
        }
        catch (ScriptException e) {
            this.ex = e;
            this.setErrorMessage();
        }
        this.stopStreaming();
        return res;
    }

    @Override
    public T_kernel_info_reply getKernelInfo() {
        String version = "";
        T_kernel_info_reply kernelInfoReply = new T_kernel_info_reply();
        kernelInfoReply.implementation = "clojure";
        try {
            version = (String)this.engine.eval("(clojure-version)");
        }
        catch (ScriptException ex) {
            Logger.getLogger(JythonConsole.class.getName()).log(Level.SEVERE, null, ex);
        }
        kernelInfoReply.implementation_version = version;
        T_language_info languageInfo = new T_language_info();
        languageInfo.file_extension = ".clj";
        languageInfo.name = "clojure";
        languageInfo.mimetype = "text/x-clojure";
        languageInfo.pygments_lexer = "clojure";
        languageInfo.version = version;
        kernelInfoReply.language_info = languageInfo;
        return kernelInfoReply;
    }
}

