/*
 * Decompiled with CFR 0.152.
 */
package org.jupyterkernel.console;

import java.io.BufferedReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.jupyterkernel.console.ConsoleInputReader;
import org.jupyterkernel.console.IInteractiveConsole;
import org.jupyterkernel.console.JupyterStreamWriter;
import org.jupyterkernel.json.messages.T_kernel_info_reply;

public class InteractiveConsole
implements IInteractiveConsole {
    ScriptEngine engine;
    ScriptException ex;
    StringWriter stdoutWriter = new StringWriter();
    StringWriter stderrWriter = new StringWriter();
    int cellnum = 0;
    int completionCursorPosition = -1;

    public InteractiveConsole() {
    }

    public InteractiveConsole(ScriptEngine engine) {
        this.engine = engine;
        this.engine.getContext().setWriter(this.stdoutWriter);
        this.engine.getContext().setErrorWriter(this.stderrWriter);
    }

    public InteractiveConsole(String kernel) {
        ScriptEngineManager manager = new ScriptEngineManager();
        this.engine = manager.getEngineByName(kernel);
        if (this.engine == null) {
            System.out.println("Classpath is " + System.getProperty("java.class.path"));
            throw new RuntimeException("ScriptEngine '" + kernel + "' not found. Please check your classpath.");
        }
        this.engine.getContext().setWriter(this.stdoutWriter);
        this.engine.getContext().setErrorWriter(this.stderrWriter);
    }

    @Override
    public void setStdinReader(ConsoleInputReader reader) {
        this.engine.getContext().setReader(new BufferedReader(reader));
    }

    @Override
    public void setStreamWriter(JupyterStreamWriter streamWriter) {
        this.engine.getContext().setWriter(streamWriter);
    }

    @Override
    public void stopStreaming() {
        JupyterStreamWriter streamWriter = (JupyterStreamWriter)this.engine.getContext().getWriter();
        if (streamWriter != null) {
            streamWriter.stopStreaming();
        }
    }

    @Override
    public String getMIMEType() {
        return "text/plain";
    }

    @Override
    public void setCellNumber(int cell) {
        this.cellnum = cell;
    }

    @Override
    public int getCompletionCursorPosition() {
        return this.completionCursorPosition;
    }

    protected void setErrorMessage() {
        this.ex.printStackTrace(new PrintWriter(this.stderrWriter));
    }

    @Override
    public String[] getTraceback() {
        return null;
    }

    @Override
    public Object eval(String codeString) {
        this.ex = null;
        try {
            CompiledScript compiledScript = ((Compilable)((Object)this.engine)).compile(codeString);
            return compiledScript.eval();
        }
        catch (ScriptException e) {
            this.ex = e;
            this.setErrorMessage();
            return null;
        }
    }

    @Override
    public String readAndClearStdout() {
        String S = this.stdoutWriter.toString();
        this.stdoutWriter.flush();
        StringBuffer sb = this.stdoutWriter.getBuffer();
        sb.delete(0, sb.length());
        return S;
    }

    @Override
    public String readAndClearStderr() {
        String S = this.stderrWriter.toString();
        this.stderrWriter.flush();
        StringBuffer sb = this.stderrWriter.getBuffer();
        sb.delete(0, sb.length());
        return S;
    }

    @Override
    public String[] completion(String source, int cursor_position) {
        return new String[0];
    }

    @Override
    public T_kernel_info_reply getKernelInfo() {
        return new T_kernel_info_reply();
    }
}

