/*
 * Decompiled with CFR 0.152.
 */
package org.jupyterkernel.console;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.script.Compilable;
import javax.script.ScriptException;
import org.json.XML;
import org.jupyterkernel.console.InteractiveConsole;
import org.jupyterkernel.json.messages.T_kernel_info_reply;
import org.jupyterkernel.json.messages.T_language_info;

public class JythonConsole
extends InteractiveConsole {
    private final String compoundStmt = "(def|class|with|for|if|while|@|try|finally|except|else)(\n|.)*";

    public JythonConsole() {
        super("python");
        this.setDisplayhook();
    }

    @Override
    protected void setErrorMessage() {
        StringWriter sw = new StringWriter();
        this.ex.getCause().printStackTrace(new PrintWriter(sw));
        String err = sw.toString();
        String[] tb = err.split("\n\n");
        String traceback = tb.length <= 2 ? XML.escape((String)tb[0]) : XML.escape((String)(tb[0] + "\n" + tb[1]));
        this.stderrWriter.write("<pre><font color=\"red\">" + traceback + "</font></pre>");
    }

    private void setDisplayhook() {
        InputStream in = this.getClass().getResourceAsStream("resources/start.py");
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                sb.append(line);
                sb.append("\n");
            }
        }
        catch (IOException ex) {
            Logger.getLogger(JythonConsole.class.getName()).log(Level.SEVERE, null, ex);
        }
        String sourceCode = sb.toString();
        try {
            this.engine.eval(sourceCode);
        }
        catch (ScriptException ex) {
            Logger.getLogger(JythonConsole.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private String readPrintExpr() {
        try {
            return (String)this.engine.eval("sys.displayhook.read()");
        }
        catch (ScriptException ex) {
            Logger.getLogger(JythonConsole.class.getName()).log(Level.SEVERE, null, ex);
            return "";
        }
    }

    @Override
    public String getMIMEType() {
        if (this.ex != null) {
            return "text/html";
        }
        try {
            return (String)this.engine.eval("sys.displayhook.mimetype");
        }
        catch (ScriptException ex) {
            Logger.getLogger(JythonConsole.class.getName()).log(Level.SEVERE, null, ex);
            return "text/plain";
        }
    }

    @Override
    public Object eval(String codeString) {
        this.ex = null;
        try {
            block8: {
                String lastBlock;
                String firstBlock;
                if (codeString.indexOf(10) == -1) {
                    this.engine.eval(String.format("exec(compile('''%s''', '<string>', 'single'), locals())", codeString));
                    this.stopStreaming();
                    return this.readPrintExpr();
                }
                String c = String.format("__code = compile('''%s''', '<string>', 'exec')", codeString);
                this.engine.eval(c);
                int n = codeString.lastIndexOf(10);
                while (true) {
                    firstBlock = n == -1 ? "" : codeString.substring(0, n);
                    lastBlock = codeString.substring(n + 1);
                    if (lastBlock.isEmpty() || lastBlock.matches("^(#|\\s)(\n|.)*")) {
                        n = codeString.lastIndexOf(10, n - 1);
                        continue;
                    }
                    if (lastBlock.matches("(def|class|with|for|if|while|@|try|finally|except|else)(\n|.)*")) break block8;
                    try {
                        if (firstBlock.isEmpty()) break;
                        ((Compilable)((Object)this.engine)).compile(firstBlock);
                        ((Compilable)((Object)this.engine)).compile(lastBlock);
                    }
                    catch (ScriptException e1) {
                        n = codeString.lastIndexOf(10, n - 1);
                        continue;
                    }
                    break;
                }
                if (!firstBlock.isEmpty()) {
                    this.engine.eval(String.format("exec(compile('''%s''', '<string>', 'exec'), locals())", firstBlock));
                }
                String code = "try:\n    __code = compile('''%s''', '<string>', 'single')\nexcept SyntaxError:\n    __code = compile('''%s''', '<string>', 'exec')\nexec(__code, locals())\ndel(__code)";
                code = String.format(code, lastBlock, lastBlock);
                this.engine.eval(code);
                this.stopStreaming();
                return this.readPrintExpr();
            }
            String code = "exec(__code, locals())\ndel(__code)";
            this.engine.eval(code);
            this.stopStreaming();
            return this.readPrintExpr();
        }
        catch (ScriptException e2) {
            this.stopStreaming();
            this.ex = e2;
            this.setErrorMessage();
            return null;
        }
    }

    @Override
    public String[] completion(String source, int cursor_position) {
        Pattern p;
        Matcher m;
        int n;
        for (int n1 = cursor_position; (n = source.lastIndexOf(10, n1)) >= 0 && n1 == n; --n1) {
        }
        this.completionCursorPosition = -1;
        if ((source = source.substring(Math.max(0, n), cursor_position)).endsWith(".")) {
            source = source.substring(0, source.length() - 1);
            --cursor_position;
        }
        if ((m = (p = Pattern.compile("\\w+(?:\\.\\w+)*$")).matcher(source)).find()) {
            String dotted_name = m.group();
            this.completionCursorPosition = cursor_position - dotted_name.length();
            try {
                List res = (List)this.engine.eval(String.format("['%s.'+s for s in dir(%s)]", dotted_name, dotted_name));
                String[] completionList = new String[res.size()];
                res.toArray(completionList);
                return completionList;
            }
            catch (ScriptException scriptException) {
                // empty catch block
            }
        }
        return new String[0];
    }

    @Override
    public T_kernel_info_reply getKernelInfo() {
        String version = "";
        T_kernel_info_reply kernelInfoReply = new T_kernel_info_reply();
        kernelInfoReply.implementation = "python";
        try {
            this.engine.eval("import sys");
            version = (String)this.engine.eval("'.'.join(map(str, sys.version_info[:3]))");
        }
        catch (ScriptException ex) {
            Logger.getLogger(JythonConsole.class.getName()).log(Level.SEVERE, null, ex);
        }
        kernelInfoReply.implementation_version = version;
        T_language_info languageInfo = new T_language_info();
        languageInfo.file_extension = ".py";
        languageInfo.name = "python";
        languageInfo.mimetype = "text/x-python";
        languageInfo.name = "python";
        languageInfo.pygments_lexer = version.startsWith("2") ? "python" : "py3";
        languageInfo.version = version;
        kernelInfoReply.language_info = languageInfo;
        return kernelInfoReply;
    }
}

