/*
 * Decompiled with CFR 0.152.
 */
package org.jupyterkernel.json.messages;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.jupyterkernel.json.messages.T_message;
import org.jupyterkernel.util.JSONField;

public class T_JSON {
    public static String message_protocol_version = null;
    private static double protocol_version = 0.0;

    public static void setProtocolVersion(String protocolVersion) {
        message_protocol_version = protocolVersion;
        protocol_version = Double.parseDouble(protocolVersion);
    }

    public static T_JSON fromJSON(String classname, JSONObject jsonObj) {
        Field[] fields;
        T_JSON instance;
        try {
            Class<?> cls = Class.forName("org.jupyterkernel.json.messages." + classname);
            try {
                instance = (T_JSON)cls.newInstance();
                if (jsonObj.length() == 0) {
                    return instance;
                }
            }
            catch (IllegalAccessException | InstantiationException ex) {
                Logger.getLogger(T_JSON.class.getName()).log(Level.SEVERE, null, ex);
                return null;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(T_JSON.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
        for (Field field : fields = instance.getClass().getFields()) {
            Object value;
            JSONField jsonField = field.getAnnotation(JSONField.class);
            if (jsonField == null) continue;
            String name = field.getName();
            try {
                value = jsonObj.get(name);
            }
            catch (JSONException e) {
                continue;
            }
            if (jsonField.type().equals("T_JSON")) {
                if (name.equals("content")) {
                    name = (String)jsonObj.getJSONObject("header").get("msg_type");
                }
                value = T_JSON.fromJSON("T_" + name, (JSONObject)value);
            }
            try {
                field.set(instance, value);
            }
            catch (IllegalAccessException | IllegalArgumentException ex) {
                Logger.getLogger(T_JSON.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return instance;
    }

    private boolean checkVersion(String versionString) {
        int n = versionString.length() - 1;
        char qual = versionString.charAt(n);
        double version = Double.parseDouble(versionString.substring(0, n));
        switch (qual) {
            case '+': {
                return protocol_version >= version;
            }
            case '-': {
                return protocol_version < version;
            }
        }
        return true;
    }

    public JSONObject toJSON() {
        Field[] fields;
        JSONObject jsonObj = new JSONObject();
        block24: for (Field field : fields = this.getClass().getFields()) {
            Object value;
            JSONField jsonField = field.getAnnotation(JSONField.class);
            if (jsonField == null) continue;
            String name = field.getName();
            String fieldType = jsonField.type();
            String version = jsonField.version();
            if (!this.checkVersion(version)) continue;
            try {
                value = field.get(this);
            }
            catch (IllegalAccessException | IllegalArgumentException ex) {
                Logger.getLogger(T_message.class.getName()).log(Level.SEVERE, null, ex);
                break;
            }
            switch (fieldType) {
                case "Simple": {
                    if (value == null) {
                        Class<?> cls = field.getType();
                        switch (cls.getName()) {
                            case "JSONObject": {
                                value = new JSONObject();
                                break;
                            }
                            case "JSONArray": {
                                value = new JSONArray();
                                break;
                            }
                            case "String": {
                                value = "";
                                break;
                            }
                            case "Integer": {
                                value = 0;
                            }
                        }
                    }
                    jsonObj.put(name, value);
                    continue block24;
                }
                case "T_JSON": {
                    jsonObj.put(name, (Object)((T_JSON)value).toJSON());
                    continue block24;
                }
                case "Choice": {
                    if (value == null) continue block24;
                    jsonObj.put(name, value);
                }
            }
        }
        return jsonObj;
    }

    private static Object cloneObject(Object obj) {
        try {
            Object clone = obj.getClass().newInstance();
            for (Field field : obj.getClass().getDeclaredFields()) {
                field.setAccessible(true);
                if (field.get(obj) == null || Modifier.isFinal(field.getModifiers())) continue;
                if (field.getType().isPrimitive() || field.getType().equals(String.class) || field.getType().getSuperclass().equals(Number.class) || field.getType().equals(Boolean.class)) {
                    field.set(clone, field.get(obj));
                    continue;
                }
                Object childObj = field.get(obj);
                if (childObj == obj) {
                    field.set(clone, clone);
                    continue;
                }
                field.set(clone, T_JSON.cloneObject(field.get(obj)));
            }
            return clone;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException e) {
            return null;
        }
    }

    public T_JSON clone() {
        return (T_JSON)T_JSON.cloneObject(this);
    }
}

