/*
 * Decompiled with CFR 0.152.
 */
package org.jupyterkernel.kernel;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.json.JSONArray;
import org.json.JSONObject;
import org.jupyterkernel.console.ConsoleFactory;
import org.jupyterkernel.console.ConsoleInputReader;
import org.jupyterkernel.console.IInteractiveConsole;
import org.jupyterkernel.console.JupyterStreamWriter;
import org.jupyterkernel.json.messages.T_comm_close;
import org.jupyterkernel.json.messages.T_comm_info_reply;
import org.jupyterkernel.json.messages.T_comm_info_request;
import org.jupyterkernel.json.messages.T_comm_open;
import org.jupyterkernel.json.messages.T_complete_reply;
import org.jupyterkernel.json.messages.T_complete_request;
import org.jupyterkernel.json.messages.T_connect_reply;
import org.jupyterkernel.json.messages.T_execute_reply;
import org.jupyterkernel.json.messages.T_execute_reply_err;
import org.jupyterkernel.json.messages.T_execute_reply_ok;
import org.jupyterkernel.json.messages.T_execute_request;
import org.jupyterkernel.json.messages.T_execute_result;
import org.jupyterkernel.json.messages.T_header;
import org.jupyterkernel.json.messages.T_history_reply;
import org.jupyterkernel.json.messages.T_input_request;
import org.jupyterkernel.json.messages.T_inspect_reply;
import org.jupyterkernel.json.messages.T_message;
import org.jupyterkernel.json.messages.T_shutdown_request;
import org.jupyterkernel.json.messages.T_stream;
import org.jupyterkernel.kernel.MessageObject;

public class Kernel
extends Thread {
    ScriptEngineManager manager;
    ScriptEngine engine;
    IInteractiveConsole console;
    String kernel;
    JSONObject connectionData;
    int execution_count = 0;
    int execution_status = 0;
    ConsoleInputReader stdinReader = null;
    boolean shutdown_requested = false;
    boolean restart_requested = false;
    MessageObject stdinTemplate;
    MessageObject iopubTemplate;
    ExecuteRequestHandler execute_request_handler = new ExecuteRequestHandler();

    public Kernel(String name, IInteractiveConsole console) {
        this.kernel = name;
        this.console = console;
    }

    public Kernel(String name) {
        this.kernel = name;
        this.console = ConsoleFactory.createConsole(name);
    }

    public String getKernel() {
        return this.kernel;
    }

    public boolean isShutdownRequested() {
        return this.shutdown_requested;
    }

    public boolean isRestartRequested() {
        return this.shutdown_requested;
    }

    public void setStdinTemplate(MessageObject messageObject) {
        this.stdinTemplate = messageObject;
    }

    public void setIOPubTemplate(MessageObject messageObject) {
        this.iopubTemplate = messageObject;
    }

    public void setConnectionData(JSONObject connectionData) {
        this.connectionData = connectionData;
    }

    public void dispatch(MessageObject message) {
        MessageObject[] responseMessages = new MessageObject[]{};
        message.read();
        T_header header = message.msg.header;
        String msgType = header.msg_type;
        if (msgType.equals("execute_request")) {
            if (this.execute_request_handler.isAlive()) {
                this.execute_request_handler.addMessage(message);
            } else {
                this.execute_request_handler = new ExecuteRequestHandler();
                this.execute_request_handler.addMessage(message);
                this.execute_request_handler.start();
            }
        } else {
            T_header parentHeader = (T_header)header.clone();
            Method[] methods = this.getClass().getMethods();
            for (Method m : methods) {
                if (!m.getName().equals(msgType)) continue;
                try {
                    responseMessages = (MessageObject[])m.invoke((Object)this, message);
                    break;
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    e.printStackTrace(System.err);
                }
            }
            if (responseMessages.length == 0) {
                throw new RuntimeException("Message handler not implemented for message type '" + msgType + "'");
            }
            for (MessageObject response : responseMessages) {
                response.msg.parent_header = parentHeader;
                response.send();
            }
        }
    }

    public MessageObject[] comm_open(MessageObject message) {
        T_comm_open commOpen = (T_comm_open)message.msg.content;
        T_comm_close commClose = new T_comm_close();
        commClose.comm_id = commOpen.comm_id;
        message.msg.content = commClose;
        message.msg.header.msg_type = "comm_close";
        return new MessageObject[]{message};
    }

    public MessageObject[] comm_info_request(MessageObject message) {
        T_comm_info_request commInfoRequest = (T_comm_info_request)message.msg.content;
        T_comm_info_reply commInfoReply = new T_comm_info_reply();
        return new MessageObject[]{message};
    }

    public MessageObject[] kernel_info_request(MessageObject message) {
        if (this.execute_request_handler.isAlive()) {
            this.execute_request_handler.interrupt();
        }
        message.msg.content = this.console.getKernelInfo();
        message.msg.header.msg_type = "kernel_info_reply";
        return new MessageObject[]{message};
    }

    private void setStdin(MessageObject message) {
        if (this.stdinReader == null) {
            T_input_request stdin = new T_input_request();
            MessageObject stdinMsg = new MessageObject(this.stdinTemplate);
            stdinMsg.msg = new T_message();
            stdinMsg.msg.header = (T_header)message.msg.header.clone();
            stdinMsg.msg.header.msg_type = "input_request";
            stdinMsg.msg.parent_header = message.msg.header;
            stdinMsg.msg.content = stdin;
            this.console.setStdinReader(new ConsoleInputReader(stdinMsg));
        }
    }

    private void setStreamWriter(MessageObject message) {
        T_stream stdout = new T_stream();
        MessageObject stdoutMsg = new MessageObject(this.iopubTemplate);
        stdoutMsg.msg = new T_message();
        stdoutMsg.msg.header = (T_header)message.msg.header.clone();
        stdoutMsg.msg.header.msg_type = "stream";
        stdoutMsg.msg.parent_header = (T_header)message.msg.header.clone();
        stdoutMsg.msg.content = stdout;
        this.console.setStreamWriter(new JupyterStreamWriter(stdoutMsg));
    }

    public MessageObject[] execute_request(MessageObject message) {
        T_execute_request request = (T_execute_request)message.msg.content;
        if (request.store_history.booleanValue()) {
            ++this.execution_count;
            this.console.setCellNumber(this.execution_count);
        }
        String code = request.code;
        this.setStreamWriter(message);
        this.setStdin(message);
        Object obj = this.console.eval(code);
        String res = this.console.readAndClearStdout();
        String err = this.console.readAndClearStderr();
        if (obj != null) {
            res = obj.toString();
        }
        T_execute_reply reply = new T_execute_reply();
        reply.execution_count = this.execution_count;
        message.msg.content = reply;
        message.msg.header.msg_type = "execute_reply";
        if (res.length() == 0 && err.length() == 0) {
            reply.status = "ok";
            reply.setAnswer(new T_execute_reply_ok());
            return new MessageObject[]{message};
        }
        T_execute_result result = new T_execute_result();
        result.execution_count = this.execution_count;
        String mimetype = this.console.getMIMEType();
        if (!err.isEmpty()) {
            reply.status = "error";
            reply.setAnswer(new T_execute_reply_err());
            result.data.put(mimetype, (Object)err);
        } else {
            reply.status = "ok";
            reply.setAnswer(new T_execute_reply_ok());
            result.data.put(mimetype, (Object)res);
        }
        MessageObject iopubMsg = new MessageObject(this.iopubTemplate);
        iopubMsg.msg = new T_message();
        iopubMsg.msg.header = (T_header)message.msg.header.clone();
        iopubMsg.msg.header.msg_type = "execute_result";
        iopubMsg.msg.content = result;
        return new MessageObject[]{message, iopubMsg};
    }

    public MessageObject[] shutdown_request(MessageObject message) {
        T_shutdown_request request = (T_shutdown_request)message.msg.content;
        this.shutdown_requested = true;
        this.restart_requested = request.restart;
        message.msg.header.msg_type = "shutdown_reply";
        return new MessageObject[]{message};
    }

    public MessageObject[] complete_request(MessageObject message) {
        T_complete_request request = (T_complete_request)message.msg.content;
        String[] matches = this.console.completion(request.code, request.cursor_pos);
        T_complete_reply reply = new T_complete_reply();
        reply.matches = new JSONArray((Object)matches);
        reply.cursor_start = this.console.getCompletionCursorPosition();
        reply.cursor_end = request.cursor_pos;
        message.msg.content = reply;
        message.msg.header.msg_type = "complete_reply";
        return new MessageObject[]{message};
    }

    @Deprecated
    public MessageObject[] connect_request(MessageObject message) {
        message.msg.header.msg_type = "connect_reply";
        T_connect_reply reply = new T_connect_reply();
        reply.hb_port = this.connectionData.getInt("hb_port");
        reply.iopub_port = this.connectionData.getInt("iopub_port");
        reply.shell_port = this.connectionData.getInt("shell_port");
        reply.stdin_port = this.connectionData.getInt("stdin_port");
        message.msg.content = reply;
        return new MessageObject[]{message};
    }

    public MessageObject[] history_request(MessageObject message) {
        message.msg.header.msg_type = "history_reply";
        message.msg.content = new T_history_reply();
        return new MessageObject[]{message};
    }

    public MessageObject[] inspect_request(MessageObject message) {
        message.msg.header.msg_type = "inspect_reply";
        message.msg.content = new T_inspect_reply();
        return new MessageObject[]{message};
    }

    public MessageObject[] input_reply(MessageObject message) {
        return new MessageObject[0];
    }

    private class ExecuteRequestHandler
    extends Thread {
        final ArrayDeque<MessageObject> requestMessages = new ArrayDeque();

        private ExecuteRequestHandler() {
        }

        public synchronized void addMessage(MessageObject message) {
            this.requestMessages.addLast(message);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.requestMessages.isEmpty()) {
                ArrayDeque<MessageObject> arrayDeque = this.requestMessages;
                synchronized (arrayDeque) {
                    MessageObject[] responseMessages;
                    MessageObject message = this.requestMessages.pollFirst();
                    T_header parentHeader = (T_header)message.msg.header.clone();
                    for (MessageObject response : responseMessages = Kernel.this.execute_request(message)) {
                        response.msg.parent_header = parentHeader;
                        response.send();
                        response = null;
                    }
                }
            }
        }
    }

    private class ExecutionStatus {
        public static final int IDLE = 0;
        public static final int BUSY = 1;
        public static final int STARTING = 2;

        private ExecutionStatus() {
        }
    }
}

