/*
 * Decompiled with CFR 0.152.
 */
package org.jupyterkernel.kernel;

import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.json.JSONObject;
import org.jupyterkernel.json.messages.T_JSON;
import org.jupyterkernel.json.messages.T_header;
import org.jupyterkernel.json.messages.T_message;
import org.jupyterkernel.util.HexBinaryConverter;
import org.jupyterkernel.util.UUID;
import org.zeromq.ZFrame;
import org.zeromq.ZMQ;
import org.zeromq.ZMsg;

public class MessageObject {
    final String[] supportedProtocolVersions = new String[]{"5.0", "5.1", "5.2", "5.3"};
    final String delimiter = "<IDS|MSG>";
    final byte[] bDelimiter = "<IDS|MSG>".getBytes();
    public T_message msg;
    public ZMQ.Socket socket;
    byte[] uuid;
    byte[] key;
    ZMsg zmsg;

    public MessageObject(ZMsg zmsg, ZMQ.Socket socket, byte[] key) {
        this.socket = socket;
        this.key = key;
        this.zmsg = zmsg;
        this.msg = new T_message();
    }

    public MessageObject(MessageObject other) {
        this.socket = other.socket;
        this.key = other.key;
        this.zmsg = other.zmsg;
        this.msg = (T_message)other.msg.clone();
    }

    private void checkAllowedProtocolVersion(String protocol) {
        for (String version : this.supportedProtocolVersions) {
            if (!version.equals(protocol)) continue;
            return;
        }
        throw new RuntimeException("[jupyter-kernel] Protocol version " + protocol + "not supported by this kernel");
    }

    private byte[] computeSignature(byte[] header, byte[] parent, byte[] meta, byte[] content) {
        byte[][] data = new byte[][]{header, parent, meta, content};
        try {
            SecretKeySpec keySpec = new SecretKeySpec(this.key, "HmacSHA256");
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(keySpec);
            for (int i = 0; i < 4; ++i) {
                mac.update(data[i]);
            }
            return mac.doFinal();
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            System.out.println(e.getMessage());
            return null;
        }
    }

    private void mildlySecureMACCompare(byte[] mac1, byte[] mac2) {
        boolean hmacValid = true;
        if (mac1.length != mac2.length) {
            hmacValid = false;
        } else {
            for (int i = 0; i < mac1.length; ++i) {
                if (mac1[i] == mac2[i]) continue;
                hmacValid = false;
            }
        }
        if (!hmacValid) {
            throw new RuntimeException("[jupyter-kernel.jar] HMAC verification failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read() {
        try {
            Object[] zframes = new ZFrame[this.zmsg.size()];
            this.zmsg.toArray(zframes);
            if (this.zmsg.size() < 7) {
                throw new RuntimeException("[jupyter-kernel.jar] Message incomplete. Didn't receive required message parts");
            }
            this.uuid = zframes[0].getData();
            String delim = new String(zframes[1].getData(), StandardCharsets.UTF_8);
            if (!delim.equals("<IDS|MSG>")) {
                throw new RuntimeException("[jupyter-kernel.jar] Incorrectly formatted message. Delimiter <IDS|MSG> not found");
            }
            byte[] header = zframes[3].getData();
            byte[] parent = zframes[4].getData();
            byte[] meta = zframes[5].getData();
            byte[] content = zframes[6].getData();
            byte[] digest = this.computeSignature(header, parent, meta, content);
            byte[] hmac = zframes[2].getData();
            hmac = HexBinaryConverter.parseHexBinary(new String(hmac));
            this.mildlySecureMACCompare(digest, hmac);
            JSONObject jsonHeader = new JSONObject(new String(header, StandardCharsets.UTF_8));
            if (null == T_JSON.message_protocol_version) {
                String protocolVersion = (String)jsonHeader.get("version");
                this.checkAllowedProtocolVersion(protocolVersion);
                T_JSON.setProtocolVersion(protocolVersion);
            }
            this.msg.header = (T_header)T_JSON.fromJSON("T_header", jsonHeader);
            this.msg.parent_header = (T_header)T_JSON.fromJSON("T_header", new JSONObject(new String(parent, StandardCharsets.UTF_8)));
            this.msg.metadata = new JSONObject(new String(meta, StandardCharsets.UTF_8));
            this.msg.content = T_JSON.fromJSON("T_" + this.msg.header.msg_type, new JSONObject(new String(content, StandardCharsets.UTF_8)));
        }
        finally {
            this.zmsg.destroy();
        }
    }

    public void send() {
        this.msg.header.msg_id = UUID.newID();
        JSONObject jsonMsg = this.msg.toJSON();
        ZMsg newZmsg = new ZMsg();
        newZmsg.add(this.uuid);
        newZmsg.add(this.bDelimiter);
        byte[] header = jsonMsg.getJSONObject("header").toString().getBytes();
        byte[] parent = jsonMsg.getJSONObject("parent_header").toString().getBytes();
        byte[] meta = jsonMsg.getJSONObject("metadata").toString().getBytes();
        byte[] content = jsonMsg.getJSONObject("content").toString().getBytes();
        byte[] digest = this.computeSignature(header, parent, meta, content);
        digest = HexBinaryConverter.toHexBinary(digest).toLowerCase().getBytes();
        newZmsg.add(digest);
        newZmsg.add(header);
        newZmsg.add(parent);
        newZmsg.add(meta);
        newZmsg.add(content);
        newZmsg.send(this.socket);
    }

    class MessageParts {
        public static final int UUID = 0;
        public static final int DELIM = 1;
        public static final int HMAC = 2;
        public static final int HEADER = 3;
        public static final int PARENT = 4;
        public static final int METADATA = 5;
        public static final int CONTENT = 6;
        public static final int BLOB = 7;

        MessageParts() {
        }
    }
}

