/*
 * Decompiled with CFR 0.152.
 */
package org.jupyterkernel.kernel;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.json.JSONObject;
import org.jupyterkernel.kernel.Kernel;
import org.jupyterkernel.kernel.MessageObject;
import org.zeromq.ZContext;
import org.zeromq.ZMQ;
import org.zeromq.ZMQException;
import org.zeromq.ZMsg;

public class Session
extends Thread {
    public static boolean _DEBUG_ = false;
    ZMQ.Socket Control;
    ZMQ.Socket Heartbeat;
    ZMQ.Socket IOPub;
    ZMQ.Socket Shell;
    ZMQ.Socket Stdin;
    ZContext ctx;
    ZMQ.Poller sockets;
    byte[] key = null;
    JSONObject connectionData;
    Kernel kernel;
    boolean restart_kernel_requested = false;

    void closeSockets() {
        try {
            if (this.Shell != null) {
                this.Shell.close();
            }
            if (this.Control != null) {
                this.Control.close();
            }
            if (this.IOPub != null) {
                this.IOPub.close();
            }
            if (this.Stdin != null) {
                this.Stdin.close();
            }
            if (this.Heartbeat != null) {
                this.Heartbeat.close();
            }
            this.ctx.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private byte[] getKey() throws InvalidKeyException, UnsupportedEncodingException {
        if (this.key == null) {
            String sKey = (String)this.connectionData.get("key");
            this.key = sKey.getBytes();
            return this.key;
        }
        return this.key;
    }

    boolean createSockets() {
        this.ctx = new ZContext();
        String ip = (String)this.connectionData.get("ip");
        String transport = (String)this.connectionData.get("transport");
        try {
            this.Heartbeat = this.ctx.createSocket(4);
            this.Heartbeat.bind(String.format("%s://%s:%s", transport, ip, this.connectionData.get("hb_port")));
            String shellAddress = String.format("%s://%s:%s", transport, ip, this.connectionData.get("shell_port"));
            this.Shell = this.ctx.createSocket(6);
            this.Shell.bind(shellAddress);
            this.Control = this.ctx.createSocket(6);
            this.Control.bind(String.format("%s://%s:%s", transport, ip, this.connectionData.get("control_port")));
            this.IOPub = this.ctx.createSocket(1);
            this.IOPub.bind(String.format("%s://%s:%s", transport, ip, this.connectionData.get("iopub_port")));
            this.Stdin = this.ctx.createSocket(6);
            this.Stdin.connect(String.format("%s://%s:%s", transport, ip, this.connectionData.get("stdin_port")));
        }
        catch (ZMQException e) {
            this.closeSockets();
            Logger.getLogger(Session.class.getName()).log(Level.SEVERE, null, e);
        }
        this.sockets = new ZMQ.Poller(4);
        this.sockets.register(this.Control, 1);
        this.sockets.register(this.Heartbeat, 1);
        this.sockets.register(this.Shell, 1);
        this.sockets.register(this.Stdin, 1);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONObject readConnectionFile(String connectionFilePath) throws FileNotFoundException, IOException {
        if (_DEBUG_) {
            System.out.println("ConnectionFilePath: " + connectionFilePath);
        }
        File connectionFile = new File(connectionFilePath);
        FileInputStream fis = new FileInputStream(connectionFile);
        byte[] content = new byte[(int)connectionFile.length()];
        try {
            fis.read(content);
        }
        finally {
            fis.close();
        }
        return new JSONObject(new String(content, "UTF-8"));
    }

    public void setKernel(String kernelName) {
        this.kernel = new Kernel(kernelName);
    }

    public void setConnectionData(JSONObject connectionData) throws InvalidKeyException, UnsupportedEncodingException {
        this.connectionData = connectionData;
        this.getKey();
    }

    @Override
    public void run() {
        if (!this.createSockets()) {
            return;
        }
        try {
            this.kernel.setStdinTemplate(new MessageObject(null, this.Stdin, this.key));
            this.kernel.setIOPubTemplate(new MessageObject(null, this.IOPub, this.key));
            this.kernel.setConnectionData(this.connectionData);
            System.out.println(String.format("[jupyter-kernel.jar] %s kernel started.", this.kernel.getKernel()));
            while (!this.isInterrupted()) {
                MessageObject msg;
                this.sockets.poll();
                if (this.sockets.pollin(0)) {
                    msg = new MessageObject(ZMsg.recvMsg((ZMQ.Socket)this.Control), this.Control, this.key);
                    this.kernel.dispatch(msg);
                }
                if (this.sockets.pollin(1)) {
                    byte[] message = this.Heartbeat.recv(0);
                    this.Heartbeat.send(message);
                }
                if (this.sockets.pollin(2)) {
                    msg = new MessageObject(ZMsg.recvMsg((ZMQ.Socket)this.Shell), this.Shell, this.key);
                    this.kernel.dispatch(msg);
                }
                if (this.sockets.pollin(3)) {
                    msg = new MessageObject(ZMsg.recvMsg((ZMQ.Socket)this.Stdin), this.Stdin, this.key);
                    this.kernel.dispatch(msg);
                }
                if (!this.kernel.isShutdownRequested()) continue;
                this.restart_kernel_requested = this.kernel.isRestartRequested();
                break;
            }
        }
        finally {
            this.closeSockets();
        }
    }

    public static void runKernel(Session session, String[] args) throws FileNotFoundException, InvalidKeyException, UnsupportedEncodingException, IOException {
        if (args.length > 0) {
            String kernelName;
            String connectionFilePath;
            Options options = new Options();
            options.addOption("f", true, "connection file path");
            options.addOption("k", true, "kernel name");
            PosixParser parser = new PosixParser();
            try {
                CommandLine cmd = parser.parse(options, args);
                connectionFilePath = cmd.getOptionValue("f");
                kernelName = cmd.getOptionValue("k");
            }
            catch (ParseException e) {
                e.printStackTrace(System.out);
                return;
            }
            JSONObject connectionData = Session.readConnectionFile(connectionFilePath);
            if (_DEBUG_) {
                System.out.println("Connection File\n------------------------------------");
                System.out.println(connectionData.toString(4));
            }
            session.setKernel(kernelName);
            session.setConnectionData(connectionData);
            try {
                session.start();
                session.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public static void runKernelDebug(Session session) throws FileNotFoundException, InvalidKeyException, UnsupportedEncodingException, IOException {
        _DEBUG_ = true;
        ZContext ctx = new ZContext();
        ZMQ.Socket channel = ctx.createSocket(4);
        channel.bind("tcp://127.0.0.1:2222");
        byte[] msg = channel.recv();
        String sArgs = new String(msg, StandardCharsets.UTF_8);
        String[] newArgs = sArgs.split(" ");
        channel.send("ok");
        Session.runKernel(session, newArgs);
    }

    public static void main(String[] args) throws FileNotFoundException, InvalidKeyException, UnsupportedEncodingException, IOException {
        Session session = new Session();
        if (args == null || args.length == 0) {
            Session.runKernelDebug(session);
        } else {
            if (_DEBUG_) {
                System.out.println("BEGIN ARGS");
                for (String arg : args) {
                    System.out.println("   " + arg);
                }
                System.out.println("END ARGS");
            }
            Session.runKernel(session, args);
        }
    }

    private class SocketType {
        public static final int CONTROL = 0;
        public static final int DELIM = 1;
        public static final int HMAC = 2;
        public static final int HEADER = 3;
        public static final int PARENT = 4;
        public static final int METADATA = 5;
        public static final int CONTENT = 6;
        public static final int BLOB = 7;

        private SocketType() {
        }
    }
}

