/*
 * Decompiled with CFR 0.152.
 */
package org.jupyterkernel.util;

public class HexBinaryConverter {
    private static int hexToBin(char ch) {
        if ('0' <= ch && ch <= '9') {
            return ch - 48;
        }
        if ('A' <= ch && ch <= 'F') {
            return ch - 65 + 10;
        }
        if ('a' <= ch && ch <= 'f') {
            return ch - 97 + 10;
        }
        return -1;
    }

    public static byte[] parseHexBinary(String s) {
        int len = s.length();
        if (len % 2 != 0) {
            return null;
        }
        byte[] out = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            int h = HexBinaryConverter.hexToBin(s.charAt(i));
            int l = HexBinaryConverter.hexToBin(s.charAt(i + 1));
            if (h == -1 || l == -1) {
                return null;
            }
            out[i / 2] = (byte)(h * 16 + l);
        }
        return out;
    }

    public static String toHexBinary(byte[] data) {
        StringBuilder r = new StringBuilder(data.length * 2);
        for (int i = 0; i < data.length; ++i) {
            r.append(HexBinaryConverter.encode(data[i] >> 4));
            r.append(HexBinaryConverter.encode(data[i] & 0xF));
        }
        return r.toString();
    }

    public static char encode(int ch) {
        if ((ch &= 0xF) < 10) {
            return (char)(48 + ch);
        }
        return (char)(65 + (ch - 10));
    }
}

