/*
 * Decompiled with CFR 0.152.
 */
package com.ximpleware;

import com.ximpleware.Expr;
import com.ximpleware.FastIntBuffer;
import com.ximpleware.NavException;
import com.ximpleware.PilotException;
import com.ximpleware.VTDNav;
import com.ximpleware.XPathEvalException;
import com.ximpleware.XPathParseException;
import com.ximpleware.xpath.parser;
import java.io.StringReader;
import java.util.Hashtable;

public class AutoPilot {
    protected int depth;
    protected int iter_type;
    protected VTDNav vn;
    protected int index;
    protected int endIndex;
    protected boolean ft;
    protected boolean special;
    protected String name;
    protected String name2;
    protected String localName;
    protected String URL;
    protected int size;
    protected Expr xpe;
    protected int[] contextCopy;
    protected int stackSize;
    private FastIntBuffer fib;
    protected Hashtable nsHash;
    protected boolean enableCaching;
    public static final int UNDEFINED = 0;
    public static final int SIMPLE = 1;
    public static final int SIMPLE_NS = 2;
    public static final int DESCENDANT = 3;
    public static final int DESCENDANT_NS = 4;
    public static final int FOLLOWING = 5;
    public static final int FOLLOWING_NS = 6;
    public static final int PRECEDING = 7;
    public static final int PRECEDING_NS = 8;
    public static final int ATTR = 9;
    public static final int ATTR_NS = 10;
    public static final int NAME_SPACE = 11;
    public static final int SIMPLE_NODE = 12;
    public static final int DESCENDANT_NODE = 13;
    public static final int FOLLOWING_NODE = 14;
    public static final int PRECEDING_NODE = 15;
    private static Hashtable symbolHash;

    protected String getName() {
        return this.name;
    }

    public AutoPilot(VTDNav v) {
        if (v == null) {
            throw new IllegalArgumentException(" instance of VTDNav can't be null ");
        }
        this.name = null;
        this.vn = v;
        this.iter_type = 0;
        this.ft = true;
        this.size = 0;
        this.special = false;
        this.xpe = null;
        symbolHash = new Hashtable();
        this.fib = null;
        this.enableCaching = true;
    }

    public AutoPilot() {
        this.name = null;
        this.iter_type = 0;
        this.ft = true;
        this.size = 0;
        this.special = false;
        this.xpe = null;
        symbolHash = new Hashtable();
        this.fib = null;
        this.enableCaching = true;
    }

    public final void declareXPathNameSpace(String prefix, String URL2) {
        if (this.nsHash == null) {
            this.nsHash = new Hashtable();
        }
        this.nsHash.put(prefix, URL2);
    }

    public void bind(VTDNav vnv) {
        this.name = null;
        if (vnv == null) {
            throw new IllegalArgumentException(" instance of VTDNav can't be null ");
        }
        this.vn = vnv;
        this.iter_type = 0;
        this.ft = true;
        this.size = 0;
        this.special = false;
    }

    public void declareVariableExpr(String varName, String varExpr) throws XPathParseException {
        try {
            parser p = new parser(new StringReader(varExpr));
            p.nsHash = this.nsHash;
            p.symbolHash = symbolHash;
            this.xpe = (Expr)p.parse().value;
            symbolHash.put(varName, this.xpe);
            this.ft = true;
        }
        catch (XPathParseException e) {
            System.out.println("Syntax error after or around the end of  ==>" + varExpr.substring(0, e.getOffset()));
            throw e;
        }
        catch (Exception e) {
            throw new XPathParseException("Error occurred");
        }
    }

    public final void clearVariableExprs() {
        symbolHash.clear();
    }

    public final void clearXPathNameSpaces() {
        this.nsHash.clear();
    }

    public boolean iterate2() throws PilotException, NavException {
        switch (this.iter_type) {
            case 12: {
                if (this.ft && this.vn.atTerminal) {
                    return false;
                }
                if (this.ft) {
                    this.ft = false;
                    return true;
                }
                return this.vn.iterateNode(this.depth);
            }
            case 13: {
                if (this.ft && this.vn.atTerminal) {
                    return false;
                }
                this.ft = false;
                return this.vn.iterateNode(this.depth);
            }
            case 14: {
                if (this.ft) {
                    boolean b = false;
                    do {
                        if (!(b = this.vn.toNode(4))) continue;
                        this.ft = false;
                        return true;
                    } while (b = this.vn.toNode(1));
                    return false;
                }
                return this.vn.iterate_following_node();
            }
            case 15: {
                if (this.ft) {
                    this.ft = false;
                    this.vn.toNode(0);
                    this.vn.toNode(1);
                }
                return this.vn.iterate_preceding_node(this.contextCopy, this.endIndex);
            }
        }
        throw new PilotException(" iteration action type undefined");
    }

    public boolean iterate() throws PilotException, NavException {
        switch (this.iter_type) {
            case 1: {
                if (this.vn.atTerminal) {
                    return false;
                }
                if (!this.ft) {
                    return this.vn.iterate(this.depth, this.name, this.special);
                }
                this.ft = false;
                if (this.special || this.vn.matchElement(this.name)) {
                    return true;
                }
                return this.vn.iterate(this.depth, this.name, this.special);
            }
            case 2: {
                if (this.vn.atTerminal) {
                    return false;
                }
                if (!this.ft) {
                    return this.vn.iterateNS(this.depth, this.URL, this.localName);
                }
                this.ft = false;
                if (this.vn.matchElementNS(this.URL, this.localName)) {
                    return true;
                }
                return this.vn.iterateNS(this.depth, this.URL, this.localName);
            }
            case 3: {
                if (this.vn.atTerminal) {
                    return false;
                }
                return this.vn.iterate(this.depth, this.name, this.special);
            }
            case 4: {
                if (this.vn.atTerminal) {
                    return false;
                }
                return this.vn.iterateNS(this.depth, this.URL, this.localName);
            }
            case 5: {
                if (this.vn.atTerminal) {
                    return false;
                }
                if (!this.ft) {
                    return this.vn.iterate_following(this.name, this.special);
                }
                this.ft = false;
                do {
                    if (!this.vn.toElement(4)) continue;
                    if (this.special || this.vn.matchElement(this.name)) {
                        return true;
                    }
                    return this.vn.iterate_following(this.name, this.special);
                } while (this.vn.toElement(1));
                return false;
            }
            case 6: {
                if (this.vn.atTerminal) {
                    return false;
                }
                if (!this.ft) {
                    return this.vn.iterate_followingNS(this.URL, this.localName);
                }
                this.ft = false;
                do {
                    if (!this.vn.toElement(4)) continue;
                    if (this.vn.matchElementNS(this.URL, this.localName)) {
                        return true;
                    }
                    return this.vn.iterate_followingNS(this.URL, this.localName);
                } while (this.vn.toElement(1));
                return false;
            }
            case 7: {
                if (this.vn.atTerminal) {
                    return false;
                }
                if (this.ft) {
                    this.ft = false;
                    this.vn.toElement(0);
                }
                return this.vn.iterate_preceding(this.name, this.contextCopy, this.endIndex);
            }
            case 8: {
                if (this.vn.atTerminal) {
                    return false;
                }
                if (this.ft) {
                    this.ft = false;
                    this.vn.toElement(0);
                }
                return this.vn.iterate_precedingNS(this.URL, this.localName, this.contextCopy, this.endIndex);
            }
        }
        throw new PilotException(" iteration action type undefined");
    }

    protected int iterateNameSpace() throws PilotException, NavException {
        if (!this.vn.ns) {
            return -1;
        }
        if (this.ft) {
            this.ft = false;
            this.index = this.vn.getCurrentIndex2() + 1;
        } else {
            this.index += 2;
        }
        while (this.index < this.size) {
            int type = this.vn.getTokenType(this.index);
            if (type == 2 || type == 3) {
                if (type == 3 && (this.name.equals("*") || this.vn.matchRawTokenString(this.index, this.name2)) && this.checkNsUniqueness(this.index)) {
                    this.vn.LN = this.index;
                    this.vn.atTerminal = true;
                    return this.index;
                }
                this.index += 2;
                continue;
            }
            this.vn.atTerminal = false;
            if (!this.vn.toElement(1)) {
                return -1;
            }
            this.index = this.vn.getCurrentIndex2() + 1;
        }
        return -1;
    }

    protected boolean checkNsUniqueness(int i) throws NavException {
        for (int j = 0; j < this.fib.size(); ++j) {
            if (this.vn.compareTokens(this.fib.intAt(j), this.vn, i) != 0) continue;
            return false;
        }
        this.fib.append(i);
        return true;
    }

    protected int iterateAttr2() throws PilotException, NavException {
        switch (this.iter_type) {
            case 9: {
                if (this.name.compareTo("*") == 0) {
                    if (this.ft) {
                        this.ft = false;
                        this.index = this.vn.getCurrentIndex2() + 1;
                    } else {
                        this.index += 2;
                    }
                    if (!this.vn.ns) {
                        if (this.index < this.size) {
                            int type = this.vn.getTokenType(this.index);
                            if (type == 2 || type == 3) {
                                this.vn.LN = this.index;
                                return this.index;
                            }
                            return -1;
                        }
                        return -1;
                    }
                    while (this.index < this.size) {
                        int type = this.vn.getTokenType(this.index);
                        if (type == 2 || type == 3) {
                            if (type == 2) {
                                this.vn.LN = this.index;
                                return this.index;
                            }
                            this.index += 2;
                            continue;
                        }
                        return -1;
                    }
                    return -1;
                }
                if (!this.ft) {
                    return -1;
                }
                this.ft = false;
                int i = this.vn.getAttrVal(this.name);
                if (i != -1) {
                    this.vn.LN = i - 1;
                    return i - 1;
                }
                return -1;
            }
            case 10: {
                if (!this.ft) {
                    return -1;
                }
                this.ft = false;
                int i = this.vn.getAttrValNS(this.URL, this.localName);
                if (i != -1) {
                    this.vn.LN = i - 1;
                    return i - 1;
                }
                return -1;
            }
        }
        throw new PilotException("invalid iteration type");
    }

    public int iterateAttr() throws PilotException, NavException {
        switch (this.iter_type) {
            case 9: {
                if (this.name.compareTo("*") == 0) {
                    if (this.ft) {
                        this.ft = false;
                        this.index = this.vn.getCurrentIndex2() + 1;
                    } else {
                        this.index += 2;
                    }
                    if (!this.vn.ns) {
                        if (this.index < this.size) {
                            int type = this.vn.getTokenType(this.index);
                            if (type == 2 || type == 3) {
                                return this.index;
                            }
                            return -1;
                        }
                        return -1;
                    }
                    while (this.index < this.size) {
                        int type = this.vn.getTokenType(this.index);
                        if (type == 2 || type == 3) {
                            if (type == 2) {
                                return this.index;
                            }
                            this.index += 2;
                            continue;
                        }
                        return -1;
                    }
                    return -1;
                }
                if (!this.ft) {
                    return -1;
                }
                this.ft = false;
                int i = this.vn.getAttrVal(this.name);
                if (i != -1) {
                    return i - 1;
                }
                return -1;
            }
            case 10: {
                if (!this.ft) {
                    return -1;
                }
                this.ft = false;
                int i = this.vn.getAttrValNS(this.URL, this.localName);
                if (i != -1) {
                    return i - 1;
                }
                return -1;
            }
        }
        throw new PilotException("invalid iteration type");
    }

    protected final void selectNode() {
        this.ft = true;
        this.depth = this.vn.getCurrentDepth();
        this.iter_type = 12;
    }

    protected final void selectPrecedingNode() {
        this.ft = true;
        this.depth = this.vn.getCurrentDepth();
        this.contextCopy = (int[])this.vn.context.clone();
        if (this.contextCopy[0] != -1) {
            for (int i = this.contextCopy[0] + 1; i < this.contextCopy.length; ++i) {
                this.contextCopy[i] = 0;
            }
        }
        this.iter_type = 15;
        this.endIndex = this.vn.getCurrentIndex();
    }

    protected final void selectFollowingNode() {
        this.ft = true;
        this.depth = this.vn.getCurrentDepth();
        this.iter_type = 14;
    }

    protected final void selectDescendantNode() {
        this.ft = true;
        this.depth = this.vn.getCurrentDepth();
        this.iter_type = 13;
    }

    public void selectElement(String en) {
        if (en == null) {
            throw new IllegalArgumentException("element name can't be null");
        }
        this.iter_type = 1;
        this.depth = this.vn.getCurrentDepth();
        this.name = en;
        this.ft = true;
    }

    public void selectElementNS(String ns_URL, String ln) {
        if (ln == null) {
            throw new IllegalArgumentException("local name can't be null");
        }
        this.iter_type = 2;
        this.depth = this.vn.getCurrentDepth();
        this.localName = ln;
        this.URL = ns_URL;
        this.ft = true;
    }

    protected void selectElement_D(String en) {
        if (en == null) {
            throw new IllegalArgumentException("element name can't be null");
        }
        this.iter_type = 3;
        this.depth = this.vn.getCurrentDepth();
        this.name = en;
        this.ft = true;
    }

    protected void selectElementNS_D(String ns_URL, String ln) {
        if (ln == null) {
            throw new IllegalArgumentException("local name can't be null");
        }
        this.iter_type = 4;
        this.depth = this.vn.getCurrentDepth();
        this.localName = ln;
        this.URL = ns_URL;
        this.ft = true;
    }

    protected void selectElement_F(String en) {
        if (en == null) {
            throw new IllegalArgumentException("element name can't be null");
        }
        this.iter_type = 5;
        this.ft = true;
        this.name = en;
    }

    protected void selectElementNS_F(String ns_URL, String ln) {
        if (ln == null) {
            throw new IllegalArgumentException("local name can't be null");
        }
        this.iter_type = 6;
        this.ft = true;
        this.localName = ln;
        this.URL = ns_URL;
    }

    protected void selectElement_P(String en) {
        if (en == null) {
            throw new IllegalArgumentException("element name can't be null");
        }
        this.depth = this.vn.getCurrentDepth();
        this.iter_type = 7;
        this.ft = true;
        this.name = en;
        this.contextCopy = (int[])this.vn.context.clone();
        this.endIndex = this.vn.getCurrentIndex2();
        for (int i = this.vn.context[0] + 1; i < this.vn.context.length; ++i) {
            this.contextCopy[i] = -1;
        }
        this.contextCopy[0] = this.vn.rootIndex;
    }

    protected void selectElementNS_P(String ns_URL, String ln) {
        if (ln == null) {
            throw new IllegalArgumentException("local name can't be null");
        }
        this.depth = this.vn.getCurrentDepth();
        this.iter_type = 8;
        this.ft = true;
        this.localName = ln;
        this.URL = ns_URL;
        this.contextCopy = (int[])this.vn.context.clone();
        this.endIndex = this.vn.getCurrentIndex2();
        for (int i = this.vn.context[0] + 1; i < this.vn.context.length; ++i) {
            this.vn.context[i] = -1;
        }
        this.contextCopy[0] = this.vn.rootIndex;
    }

    protected void selectNameSpace(String en) {
        if (en == null) {
            throw new IllegalArgumentException("namespace name can't be null");
        }
        this.iter_type = 11;
        this.ft = true;
        this.size = this.vn.getTokenCount();
        this.name = en;
        if (!en.equals("*")) {
            this.name2 = "xmlns:" + en;
        }
        if (this.fib == null) {
            this.fib = new FastIntBuffer(4);
        } else {
            this.fib.clear();
        }
    }

    public void selectAttr(String en) {
        if (en == null) {
            throw new IllegalArgumentException("attribute name can't be null");
        }
        this.iter_type = 9;
        this.ft = true;
        this.size = this.vn.getTokenCount();
        this.name = en;
    }

    public final void selectAttrNS(String ns_URL, String ln) {
        if (ln == null) {
            throw new IllegalArgumentException("local name of an attribute can't be null");
        }
        this.iter_type = 10;
        this.ft = true;
        this.localName = ln;
        this.URL = ns_URL;
    }

    public void selectXPath(String s) throws XPathParseException {
        try {
            parser p = new parser(new StringReader(s));
            p.nsHash = this.nsHash;
            p.symbolHash = symbolHash;
            this.xpe = (Expr)p.parse().value;
            this.ft = true;
            if (this.enableCaching) {
                this.xpe.markCacheable();
            }
        }
        catch (XPathParseException e) {
            System.out.println("Syntax error after or around the end of ==>" + s.substring(0, e.getOffset()));
            throw e;
        }
        catch (Exception e) {
            throw new XPathParseException("Error occurred");
        }
    }

    public final void resetXPath() {
        if (this.xpe != null && this.vn != null) {
            this.xpe.reset(this.vn);
            this.ft = true;
            this.vn.contextStack2.size = this.stackSize;
            if (this.enableCaching) {
                this.xpe.clearCache();
            }
        }
    }

    public final double evalXPathToNumber() {
        return this.xpe.evalNumber(this.vn);
    }

    public final String evalXPathToString() {
        return this.xpe.evalString(this.vn);
    }

    public final boolean evalXPathToBoolean() {
        return this.xpe.evalBoolean(this.vn);
    }

    public int evalXPath() throws XPathEvalException, NavException {
        if (this.xpe != null) {
            if (this.ft) {
                if (this.vn != null) {
                    this.stackSize = this.vn.contextStack2.size;
                }
                this.ft = false;
                this.xpe.adjust(this.vn.getTokenCount());
            }
            return this.xpe.evalNodeSet(this.vn);
        }
        throw new PilotException(" Null XPath expression ");
    }

    protected final void setSpecial(boolean b) {
        this.special = b;
    }

    public final String getExprString() {
        return this.xpe.toString();
    }

    public final void enableCaching(boolean state) {
        this.enableCaching = state;
    }
}

