/*
 * Decompiled with CFR 0.152.
 */
package com.ximpleware;

import com.ximpleware.ElementFragmentNs;
import com.ximpleware.FastLongBuffer;
import com.ximpleware.FastObjectBuffer;
import com.ximpleware.ModifyException;
import com.ximpleware.NavException;
import com.ximpleware.ParseException;
import com.ximpleware.TranscodeException;
import com.ximpleware.VTDGen;
import com.ximpleware.VTDNav;
import com.ximpleware.XMLByteOutputStream;
import com.ximpleware.intHash;
import com.ximpleware.transcode.Transcoder;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class XMLModifier {
    protected VTDNav md;
    private static final long MASK_DELETE = 0L;
    private static final long MASK_INSERT_SEGMENT_BYTE = 0x2000000000000000L;
    private static final long MASK_INSERT_BYTE = 0x4000000000000000L;
    private static final long MASK_INSERT_SEGMENT_BYTE_ENCLOSED = 0x6000000000000000L;
    private static final long MASK_INSERT_BYTE_ENCLOSED = Long.MIN_VALUE;
    private static final long MASK_INSERT_FRAGMENT_NS = -6917529027641081856L;
    private static final long MASK_INSERT_FRAGMENT_NS_ENCLOSED = -2305843009213693952L;
    private static final long MASK_NULL = -4611686018427387904L;
    private static final byte[] ba1 = new byte[]{62, 0};
    private static final byte[] ba2 = new byte[]{60, 0};
    private static final byte[] ba3 = new byte[]{0, 62};
    private static final byte[] ba4 = new byte[]{0, 60};
    protected FastObjectBuffer fob;
    protected FastLongBuffer flb;
    protected intHash deleteHash;
    protected intHash insertHash;
    protected String charSet;
    int encoding;

    public XMLModifier(VTDNav masterDocument) throws ModifyException {
        this.bind(masterDocument);
    }

    public XMLModifier() {
        this.md = null;
    }

    public void bind(VTDNav masterDocument) throws ModifyException {
        if (masterDocument == null) {
            throw new IllegalArgumentException("MasterDocument can't be null");
        }
        this.md = masterDocument;
        this.flb = new FastLongBuffer();
        this.fob = new FastObjectBuffer();
        int i = intHash.determineHashWidth(this.md.vtdSize);
        this.insertHash = new intHash(i);
        this.deleteHash = new intHash(i);
        this.encoding = this.md.getEncoding();
        switch (this.encoding) {
            case 0: {
                this.charSet = "ASCII";
                break;
            }
            case 1: {
                this.charSet = "ISO8859_1";
                break;
            }
            case 2: {
                this.charSet = "UTF8";
                break;
            }
            case 63: {
                this.charSet = "UnicodeBigUnmarked";
                break;
            }
            case 64: {
                this.charSet = "UnicodeLittleUnmarked";
                break;
            }
            case 3: {
                this.charSet = "ISO8859_2";
                break;
            }
            case 4: {
                this.charSet = "ISO8859_3";
                break;
            }
            case 5: {
                this.charSet = "ISO8859_4";
                break;
            }
            case 6: {
                this.charSet = "ISO8859_5";
                break;
            }
            case 7: {
                this.charSet = "ISO8859_6";
                break;
            }
            case 8: {
                this.charSet = "ISO8859_7";
                break;
            }
            case 9: {
                this.charSet = "ISO8859_8";
                break;
            }
            case 10: {
                this.charSet = "ISO8859_9";
                break;
            }
            case 11: {
                this.charSet = "ISO8859_10";
                break;
            }
            case 12: {
                this.charSet = "x-iso-8859-11";
                break;
            }
            case 13: {
                this.charSet = "ISO8859_12";
                break;
            }
            case 14: {
                this.charSet = "ISO8859_13";
                break;
            }
            case 15: {
                this.charSet = "ISO8859_14";
                break;
            }
            case 16: {
                this.charSet = "ISO8859_15";
                break;
            }
            case 18: {
                this.charSet = "Cp1250";
                break;
            }
            case 19: {
                this.charSet = "Cp1251";
                break;
            }
            case 20: {
                this.charSet = "Cp1252";
                break;
            }
            case 21: {
                this.charSet = "Cp1253";
                break;
            }
            case 22: {
                this.charSet = "Cp1254";
                break;
            }
            case 23: {
                this.charSet = "Cp1255";
                break;
            }
            case 24: {
                this.charSet = "Cp1256";
                break;
            }
            case 25: {
                this.charSet = "Cp1257";
                break;
            }
            case 26: {
                this.charSet = "Cp1258";
                break;
            }
            default: {
                throw new ModifyException("Master document encoding not yet supported by XML modifier");
            }
        }
    }

    public void remove() throws NavException, ModifyException {
        int i = this.md.getCurrentIndex();
        int type = this.md.getTokenType(i);
        if (type == 0) {
            long l = this.md.getElementFragment();
            this.removeContent((int)l, (int)(l >> 32));
        } else if (type == 2 || type == 3) {
            this.removeAttribute(i);
        } else {
            this.removeToken(i);
        }
    }

    public void remove(long l) throws NavException, ModifyException {
        this.removeContent((int)l, (int)(l >> 32));
    }

    public void removeToken(int i) throws ModifyException {
        int type = this.md.getTokenType(i);
        int os = this.md.getTokenOffset(i);
        int len = type == 0 || type == 2 || type == 3 ? this.md.getTokenLength(i) & 0xFFFF : this.md.getTokenLength(i);
        switch (type) {
            case 11: {
                if (this.encoding < 63) {
                    this.removeContent(os - 9, len + 12);
                } else {
                    this.removeContent(os - 9 << 1, len + 12 << 1);
                }
                return;
            }
            case 6: {
                if (this.encoding < 63) {
                    this.removeContent(os - 4, len + 7);
                } else {
                    this.removeContent(os - 4 << 1, len + 7 << 1);
                }
                return;
            }
        }
        if (this.encoding < 63) {
            this.removeContent(os, len);
        } else {
            this.removeContent(os << 1, len << 1);
        }
    }

    public void removeAttribute(int attrNameIndex) throws ModifyException {
        int type = this.md.getTokenType(attrNameIndex);
        if (type != 2 && type != 3) {
            throw new ModifyException("token type should be attribute name");
        }
        int os1 = this.md.getTokenOffset(attrNameIndex);
        int os2 = this.md.getTokenOffset(attrNameIndex + 1);
        int len2 = this.md.getTokenLength(attrNameIndex + 1);
        if (this.encoding < 63) {
            this.removeContent(os1, os2 + len2 - os1 + 1);
        } else {
            this.removeContent(os1 << 1, os2 + len2 - os1 + 1 << 1);
        }
    }

    public void removeContent(int offset, int len) throws ModifyException {
        if (offset < this.md.docOffset || len > this.md.docLen || offset + len > this.md.docOffset + this.md.docLen) {
            throw new ModifyException("Invalid offset or length for removeContent");
        }
        if (!this.deleteHash.isUnique(offset)) {
            throw new ModifyException("There can be only one deletion per offset value");
        }
        while (len > 0x1FFFFFFF) {
            this.flb.append(0x1FFFFFFF00000000L | (long)offset | 0L);
            this.fob.append((Object)null);
            len -= 0x1FFFFFFF;
            offset += 0x1FFFFFFF;
        }
        this.flb.append((long)len << 32 | (long)offset | 0L);
        this.fob.append((Object)null);
    }

    private void insertBytesEnclosedAt(int offset, byte[] content) throws ModifyException {
        if (!this.insertHash.isUnique(offset)) {
            throw new ModifyException("There can be only one insert per offset");
        }
        this.flb.append((long)offset | Long.MIN_VALUE);
        this.fob.append((Object)content);
    }

    public void insertBytesAt(int offset, byte[] content) throws ModifyException {
        if (!this.insertHash.isUnique(offset)) {
            throw new ModifyException("There can be only one insert per offset");
        }
        this.flb.append((long)offset | 0x4000000000000000L);
        this.fob.append((Object)content);
    }

    private void insertElementFragmentNsAt(int offset, ElementFragmentNs ef) throws ModifyException {
        if (!this.insertHash.isUnique(offset)) {
            throw new ModifyException("There can be only one insert per offset");
        }
        this.flb.append((long)offset | 0xA000000000000000L);
        this.fob.append(ef);
    }

    private void insertElementFragmentNsEnclosedAt(int offset, ElementFragmentNs ef) throws ModifyException {
        if (!this.insertHash.isUnique(offset)) {
            throw new ModifyException("There can be only one insert per offset");
        }
        this.flb.append((long)offset | 0xE000000000000000L);
        this.fob.append(ef);
    }

    public void insertBytesAt(int offset, byte[] content, int contentOffset, int contentLen) throws ModifyException {
        if (!this.insertHash.isUnique(offset)) {
            throw new ModifyException("There can be only one insert per offset");
        }
        if (contentOffset < 0 || contentLen < 0 || contentOffset + contentLen > content.length) {
            throw new ModifyException("Invalid contentOffset and/or contentLen");
        }
        this.flb.append((long)offset | 0x2000000000000000L);
        ByteSegment bs = new ByteSegment();
        bs.ba = content;
        bs.len = contentLen;
        bs.offset = contentOffset;
        this.fob.append(bs);
    }

    private void insertBytesEnclosedAt(int offset, byte[] content, int contentOffset, int contentLen) throws ModifyException {
        if (!this.insertHash.isUnique(offset)) {
            throw new ModifyException("There can be only one insert per offset");
        }
        if (contentOffset < 0 || contentLen < 0 || contentOffset + contentLen > content.length) {
            throw new ModifyException("Invalid contentOffset and/or contentLen");
        }
        this.flb.append((long)offset | 0x6000000000000000L);
        ByteSegment bs = new ByteSegment();
        bs.ba = content;
        bs.len = contentLen;
        bs.offset = contentOffset;
        this.fob.append(bs);
    }

    private void insertBytesAt(int offset, byte[] content, long l) throws ModifyException {
        if (!this.insertHash.isUnique(offset)) {
            throw new ModifyException("There can be only one insert per offset");
        }
        int contentOffset = (int)l;
        int contentLen = (int)(l >> 32);
        if (contentOffset < 0 || contentLen < 0 || contentOffset + contentLen > content.length) {
            throw new ModifyException("Invalid contentOffset and/or contentLen");
        }
        this.flb.append((long)offset | 0x2000000000000000L);
        ByteSegment bs = new ByteSegment();
        bs.ba = content;
        bs.len = contentLen;
        bs.offset = contentOffset;
        this.fob.append(bs);
    }

    private void insertBytesEnclosedAt(int offset, byte[] content, long l) throws ModifyException {
        if (!this.insertHash.isUnique(offset)) {
            throw new ModifyException("There can be only one insert per offset");
        }
        int contentOffset = (int)l;
        int contentLen = (int)(l >> 32);
        if (contentOffset < 0 || contentLen < 0 || contentOffset + contentLen > content.length) {
            throw new ModifyException("Invalid contentOffset and/or contentLen");
        }
        this.flb.append((long)offset | 0x6000000000000000L);
        ByteSegment bs = new ByteSegment();
        bs.ba = content;
        bs.len = contentLen;
        bs.offset = contentOffset;
        this.fob.append(bs);
    }

    public void updateToken(int index, byte[] newContentBytes) throws ModifyException, UnsupportedEncodingException {
        if (newContentBytes == null) {
            throw new IllegalArgumentException("newContentBytes can't be null");
        }
        int offset = this.md.getTokenOffset(index);
        int type = this.md.getTokenType(index);
        switch (type) {
            case 11: {
                if (this.encoding < 63) {
                    this.insertBytesAt(offset - 9, newContentBytes);
                    break;
                }
                this.insertBytesAt(offset - 9 >> 1, newContentBytes);
                break;
            }
            case 6: {
                if (this.encoding < 63) {
                    this.insertBytesAt(offset - 4, newContentBytes);
                    break;
                }
                this.insertBytesAt(offset - 4 >> 1, newContentBytes);
                break;
            }
            default: {
                if (this.encoding < 63) {
                    this.insertBytesAt(offset, newContentBytes);
                    break;
                }
                this.insertBytesAt(offset << 1, newContentBytes);
            }
        }
        this.removeToken(index);
    }

    public void updateToken(int index, byte[] newContentBytes, int src_encoding) throws ModifyException, UnsupportedEncodingException, TranscodeException {
        if (src_encoding == this.encoding) {
            this.updateToken(index, newContentBytes);
            return;
        }
        if (newContentBytes == null) {
            throw new IllegalArgumentException("newContentBytes can't be null");
        }
        int offset = this.md.getTokenOffset(index);
        int type = this.md.getTokenType(index);
        byte[] bo = Transcoder.transcode(newContentBytes, 0, newContentBytes.length, src_encoding, this.encoding);
        switch (type) {
            case 11: {
                if (this.encoding < 63) {
                    this.insertBytesAt(offset - 9, bo);
                    break;
                }
                this.insertBytesAt(offset - 9 >> 1, bo);
                break;
            }
            case 6: {
                if (this.encoding < 63) {
                    this.insertBytesAt(offset - 4, bo);
                    break;
                }
                this.insertBytesAt(offset - 4 >> 1, bo);
                break;
            }
            default: {
                if (this.encoding < 63) {
                    this.insertBytesAt(offset, bo);
                    break;
                }
                this.insertBytesAt(offset << 1, bo);
            }
        }
        this.removeToken(index);
    }

    public void updateToken(int index, byte[] newContentBytes, int contentOffset, int contentLen) throws ModifyException, UnsupportedEncodingException {
        if (newContentBytes == null) {
            throw new IllegalArgumentException("newContentBytes can't be null");
        }
        int offset = this.md.getTokenOffset(index);
        int type = this.md.getTokenType(index);
        switch (type) {
            case 11: {
                if (this.encoding < 63) {
                    this.insertBytesAt(offset - 9, newContentBytes, contentOffset, contentLen);
                    break;
                }
                this.insertBytesAt(offset - 9 << 1, newContentBytes, contentOffset, contentLen);
                break;
            }
            case 6: {
                if (this.encoding < 63) {
                    this.insertBytesAt(offset - 4, newContentBytes, contentOffset, contentLen);
                    break;
                }
                this.insertBytesAt(offset - 4 << 1, newContentBytes, contentOffset, contentLen);
                break;
            }
            default: {
                if (this.encoding < 63) {
                    this.insertBytesAt(offset, newContentBytes, contentOffset, contentLen);
                    break;
                }
                this.insertBytesAt(offset << 1, newContentBytes, contentOffset, contentLen);
            }
        }
        this.removeToken(index);
    }

    public void updateToken(int index, byte[] newContentBytes, int contentOffset, int contentLen, int src_encoding) throws ModifyException, UnsupportedEncodingException, TranscodeException {
        if (src_encoding == this.encoding) {
            this.updateToken(index, newContentBytes, contentOffset, contentLen);
            return;
        }
        if (newContentBytes == null) {
            throw new IllegalArgumentException("newContentBytes can't be null");
        }
        int offset = this.md.getTokenOffset(index);
        int type = this.md.getTokenType(index);
        byte[] bo = Transcoder.transcode(newContentBytes, contentOffset, contentLen, src_encoding, this.encoding);
        switch (type) {
            case 11: {
                if (this.encoding < 63) {
                    this.insertBytesAt(offset - 9, bo);
                    break;
                }
                this.insertBytesAt(offset - 9 << 1, bo);
                break;
            }
            case 6: {
                if (this.encoding < 63) {
                    this.insertBytesAt(offset - 4, bo);
                    break;
                }
                this.insertBytesAt(offset - 4 << 1, bo);
                break;
            }
            default: {
                if (this.encoding < 63) {
                    this.insertBytesAt(offset, bo);
                    break;
                }
                this.insertBytesAt(offset << 1, bo);
            }
        }
        this.removeToken(index);
    }

    public void updateToken(int index, VTDNav vn, int contentOffset, int contentLen) throws ModifyException, UnsupportedEncodingException, TranscodeException {
        this.updateToken(index, vn.XMLDoc.getBytes(), contentOffset, contentLen, vn.encoding);
    }

    public void updateToken(int index, String newContent) throws ModifyException, UnsupportedEncodingException {
        if (newContent == null) {
            throw new IllegalArgumentException("String newContent can't be null");
        }
        int offset = this.md.getTokenOffset(index);
        int type = this.md.getTokenType(index);
        switch (type) {
            case 11: {
                if (this.encoding < 63) {
                    this.insertBytesAt(offset - 9, newContent.getBytes(this.charSet));
                    break;
                }
                this.insertBytesAt(offset - 9 << 1, newContent.getBytes(this.charSet));
                break;
            }
            case 6: {
                if (this.encoding < 63) {
                    this.insertBytesAt(offset - 4, newContent.getBytes(this.charSet));
                    break;
                }
                this.insertBytesAt(offset - 4 << 1, newContent.getBytes(this.charSet));
                break;
            }
            default: {
                if (this.encoding < 63) {
                    this.insertBytesAt(offset, newContent.getBytes(this.charSet));
                    break;
                }
                this.insertBytesAt(offset << 1, newContent.getBytes(this.charSet));
            }
        }
        this.removeToken(index);
    }

    protected void sort() {
        if (this.flb.size > 0) {
            this.quickSort(0, this.flb.size - 1);
        }
    }

    protected void check() throws ModifyException {
        int size = this.flb.size;
        for (int i = 0; i < size; ++i) {
            int temp;
            int os1 = this.flb.lower32At(i);
            int os2 = this.flb.lower32At(i) + (this.flb.upper32At(i) & 0x1FFFFFFF) - 1;
            if (i + 1 >= size || (temp = this.flb.lower32At(i + 1)) == os1 || temp > os2) continue;
            throw new ModifyException("Invalid insertion/deletion condition detected between offset " + os1 + " and offset " + os2);
        }
    }

    protected void check2() throws ModifyException {
        int z;
        int size = this.flb.size;
        block0: for (int i = 0; i < size; i += z) {
            int os1 = this.flb.lower32At(i);
            int os2 = this.flb.lower32At(i) + (this.flb.upper32At(i) & 0x1FFFFFFF) - 1;
            z = 1;
            while (i + z < size) {
                int temp = this.flb.lower32At(i + z);
                if (temp == os1) {
                    if ((this.flb.upper32At(i + z) & 0x1FFFFFFF) != 0) {
                        os2 = this.flb.lower32At(i + z) + (this.flb.upper32At(i + z) & 0x1FFFFFFF) - 1;
                    }
                    ++z;
                    continue;
                }
                if (temp <= os1 || temp > os2) continue block0;
                int k = this.flb.lower32At(i + z) + (this.flb.upper32At(i + z) & 0x1FFFFFFF) - 1;
                if (k > os2) {
                    throw new ModifyException("Invalid insertion/deletion condition detected between offset " + os1 + " and offset " + os2);
                }
                this.flb.modifyEntry(i + z, this.flb.longAt(i + z) & 0x1FFFFFFFFFFFFFFFL | 0xC000000000000000L);
                ++z;
            }
        }
    }

    public int getUpdatedDocumentSize() throws ModifyException, TranscodeException {
        int size = this.flb.size;
        int docSize = this.md.getXML().getBytes().length;
        int inc = this.md.encoding < 63 ? 2 : 4;
        this.sort();
        this.check2();
        for (int i = 0; i < size; ++i) {
            long l = this.flb.longAt(i);
            if ((l & 0xE000000000000000L) == 0L) {
                docSize -= (int)((l & 0x1FFFFFFFFFFFFFFFL) >> 32);
                continue;
            }
            if ((l & 0xE000000000000000L) == 0x4000000000000000L) {
                docSize += ((byte[])this.fob.objectAt(i)).length;
                continue;
            }
            if ((l & 0xE000000000000000L) == 0x2000000000000000L) {
                docSize += ((ByteSegment)this.fob.objectAt((int)i)).len;
                continue;
            }
            if ((l & 0xE000000000000000L) == -6917529027641081856L) {
                docSize += ((ElementFragmentNs)this.fob.objectAt(i)).getSize(this.md.encoding);
                continue;
            }
            if ((l & 0xE000000000000000L) == Long.MIN_VALUE) {
                docSize += ((byte[])this.fob.objectAt(i)).length + inc;
                continue;
            }
            if ((l & 0xE000000000000000L) == 0x6000000000000000L) {
                docSize += ((ByteSegment)this.fob.objectAt((int)i)).len + inc;
                continue;
            }
            if ((l & 0xE000000000000000L) != -2305843009213693952L) continue;
            docSize += ((ElementFragmentNs)this.fob.objectAt(i)).getSize(this.md.encoding) + inc;
        }
        return docSize;
    }

    public void insertAfterElement(byte[] b) throws ModifyException, NavException {
        int startTagIndex = this.md.getCurrentIndex();
        int type = this.md.getTokenType(startTagIndex);
        if (type != 0) {
            throw new ModifyException("Token type is not a starting tag");
        }
        long l = this.md.getElementFragment();
        int offset = (int)l;
        int len = (int)(l >> 32);
        this.insertBytesAt(offset + len, b);
    }

    private void insertEndingTag(long l) throws ModifyException {
        int i = this.md.getCurrentIndex();
        int offset = this.md.getTokenOffset(i);
        int length = this.md.getTokenLength(i) & 0xFFFF;
        byte[] xml = this.md.getXML().getBytes();
        if (this.md.encoding < 63) {
            this.insertBytesAt((int)l, xml, offset, length);
        } else {
            this.insertBytesAt((int)l, xml, offset << 1, length << 1);
        }
    }

    public void insertAfterHead(byte[] b) throws ModifyException, NavException {
        long i = this.md.getOffsetAfterHead();
        if (i < 0L) {
            this.insertBytesEnclosedAt((int)i - 1, b);
            this.insertEndingTag(i);
            return;
        }
        this.insertBytesAt((int)i, b);
    }

    public void insertBeforeTail(byte[] b) throws ModifyException, NavException {
        long i = this.md.getOffsetBeforeTail();
        if (i < 0L) {
            this.insertAfterHead(b);
            return;
        }
        this.insertBytesAt((int)i, b);
    }

    public void insertBeforeTail(String s) throws ModifyException, UnsupportedEncodingException, NavException {
        long i = this.md.getOffsetBeforeTail();
        if (i < 0L) {
            this.insertAfterHead(s.getBytes(this.charSet));
            return;
        }
        this.insertBytesAt((int)i, s.getBytes());
    }

    public void insertBeforeTail(int src_encoding, byte[] b) throws ModifyException, NavException, TranscodeException {
        if (src_encoding == this.encoding) {
            this.insertBeforeTail(b);
        } else {
            long i = this.md.getOffsetBeforeTail();
            if (i < 0L) {
                this.insertAfterHead(src_encoding, b);
                return;
            }
            byte[] bo = Transcoder.transcode(b, 0, b.length, src_encoding, this.encoding);
            this.insertBytesAt((int)i, bo);
        }
    }

    public void insertBeforeTail(int src_encoding, byte[] b, int offset, int length) throws ModifyException, NavException, TranscodeException {
        if (src_encoding == this.encoding) {
            this.insertAfterHead(b, offset, length);
        } else {
            long i = this.md.getOffsetBeforeTail();
            if (i < 0L) {
                this.insertAfterHead(src_encoding, b, offset, length);
                return;
            }
            byte[] bo = Transcoder.transcode(b, offset, length, src_encoding, this.encoding);
            this.insertBytesAt((int)i, bo, offset, length);
        }
    }

    public void insertBeforeTail(VTDNav vn, int contentOffset, int contentLen) throws ModifyException, NavException, TranscodeException {
        this.insertBeforeTail(vn.XMLDoc.getBytes(), contentOffset, contentLen);
    }

    public void insertBeforeTail(int src_encoding, byte[] b, long l) throws ModifyException, NavException, TranscodeException {
        if (src_encoding == this.encoding) {
            this.insertBeforeTail(b, l);
        } else {
            long i = this.md.getOffsetBeforeTail();
            if (i < 0L) {
                this.insertAfterHead(src_encoding, b, l);
                return;
            }
            byte[] bo = Transcoder.transcode(b, (int)l, (int)l >> 32, src_encoding, this.encoding);
            this.insertBytesAt((int)i, bo, l);
        }
    }

    public void insertBeforeTail(byte[] b, long l) throws ModifyException, NavException {
        long i = this.md.getOffsetBeforeTail();
        if (i < 0L) {
            this.insertAfterHead(b, l);
            return;
        }
        this.insertBytesAt((int)i, b, l);
    }

    public void insertBeforeTail(ElementFragmentNs ef) throws ModifyException, NavException {
        long i = this.md.getOffsetBeforeTail();
        if (i < 0L) {
            this.insertAfterHead(ef);
            return;
        }
        this.insertElementFragmentNsAt((int)i, ef);
    }

    public void insertBeforeTail(VTDNav vn, long l1) throws ModifyException, NavException, TranscodeException {
        this.insertBeforeTail(vn.encoding, vn.XMLDoc.getBytes(), l1);
    }

    public void insertBeforeTail(byte[] b, int offset, int len) throws ModifyException, NavException {
        long i = this.md.getOffsetBeforeTail();
        if (i < 0L) {
            this.insertAfterHead(b, offset, len);
            return;
        }
        this.insertBytesAt((int)i, b, offset, len);
    }

    public void insertAfterHead(int src_encoding, byte[] b) throws ModifyException, NavException, TranscodeException {
        if (src_encoding == this.encoding) {
            this.insertAfterHead(b);
        } else {
            long i = this.md.getOffsetAfterHead();
            if (i < 0L) {
                byte[] bo = Transcoder.transcode(b, 0, b.length, src_encoding, this.encoding);
                this.insertBytesEnclosedAt((int)i - 1, bo);
                this.insertEndingTag(i);
                return;
            }
            byte[] bo = Transcoder.transcode(b, 0, b.length, src_encoding, this.encoding);
            this.insertBytesAt((int)i, bo);
        }
    }

    public void insertAfterHead(int src_encoding, byte[] b, int offset, int length) throws ModifyException, NavException, TranscodeException {
        if (src_encoding == this.encoding) {
            this.insertAfterHead(b, offset, length);
        } else {
            long i = this.md.getOffsetAfterHead();
            if (i < 0L) {
                byte[] bo = Transcoder.transcode(b, offset, length, src_encoding, this.encoding);
                this.insertBytesEnclosedAt((int)i - 1, bo);
                this.insertEndingTag(i);
                return;
            }
            byte[] bo = Transcoder.transcode(b, offset, length, src_encoding, this.encoding);
            this.insertBytesAt((int)i, bo, offset, length);
        }
    }

    public void insertAfterHead(int src_encoding, byte[] b, long l) throws ModifyException, NavException, TranscodeException {
        if (src_encoding == this.encoding) {
            this.insertAfterHead(b, l);
        } else {
            long i = this.md.getOffsetAfterHead();
            if (i < 0L) {
                byte[] bo = Transcoder.transcode(b, (int)l, (int)l >> 32, src_encoding, this.encoding);
                this.insertBytesEnclosedAt((int)i - 1, bo, l);
                this.insertEndingTag(i);
                return;
            }
            byte[] bo = Transcoder.transcode(b, (int)l, (int)l >> 32, src_encoding, this.encoding);
            this.insertBytesAt((int)i, bo, l);
        }
    }

    public void insertAfterHead(String s) throws ModifyException, UnsupportedEncodingException, NavException {
        long i = this.md.getOffsetAfterHead();
        if (i < 0L) {
            this.insertBytesEnclosedAt((int)i - 1, s.getBytes(this.charSet));
            this.insertEndingTag(i);
            return;
        }
        this.insertBytesAt((int)i, s.getBytes(this.charSet));
    }

    public void insertAfterHead(VTDNav vn, int contentOffset, int contentLen) throws ModifyException, NavException, TranscodeException {
        this.insertAfterHead(vn.encoding, vn.XMLDoc.getBytes(), contentOffset, contentLen);
    }

    public void insertAfterHead(byte[] b, int offset, int len) throws ModifyException, NavException {
        long i = this.md.getOffsetAfterHead();
        if (i < 0L) {
            this.insertBytesEnclosedAt((int)i - 1, b, offset, len);
            this.insertEndingTag(i);
            return;
        }
        this.insertBytesAt((int)i, b, offset, len);
    }

    public void insertAfterHead(byte[] b, long l) throws ModifyException, NavException {
        long i = this.md.getOffsetAfterHead();
        if (i < 0L) {
            this.insertBytesEnclosedAt((int)i - 1, b, (int)l, (int)(l << 32));
            this.insertEndingTag(i);
            return;
        }
        this.insertBytesAt((int)i, b, l);
    }

    public void insertAfterHead(ElementFragmentNs ef) throws ModifyException, NavException {
        long i = this.md.getOffsetAfterHead();
        if (i < 0L) {
            this.insertElementFragmentNsEnclosedAt((int)i - 1, ef);
            this.insertEndingTag(i);
            return;
        }
        this.insertElementFragmentNsAt((int)i, ef);
    }

    public void insertAfterElement(ElementFragmentNs ef) throws ModifyException, NavException {
        int startTagIndex = this.md.getCurrentIndex();
        int type = this.md.getTokenType(startTagIndex);
        if (type != 0) {
            throw new ModifyException("Token type is not a starting tag");
        }
        long l = this.md.getElementFragment();
        int offset = (int)l;
        int len = (int)(l >> 32);
        this.insertElementFragmentNsAt(offset + len, ef);
    }

    public void insertAfterElement(byte[] b, int contentOffset, int contentLen) throws ModifyException, NavException {
        int startTagIndex = this.md.getCurrentIndex();
        int type = this.md.getTokenType(startTagIndex);
        if (type != 0) {
            throw new ModifyException("Token type is not a starting tag");
        }
        long l = this.md.getElementFragment();
        int offset = (int)l;
        int len = (int)(l >> 32);
        this.insertBytesAt(offset + len, b, contentOffset, contentLen);
    }

    public void insertAfterElement(int src_encoding, byte[] b, int contentOffset, int contentLen) throws ModifyException, NavException, TranscodeException {
        if (src_encoding == this.encoding) {
            this.insertAfterElement(b, contentOffset, contentLen);
        } else {
            int startTagIndex = this.md.getCurrentIndex();
            int type = this.md.getTokenType(startTagIndex);
            if (type != 0) {
                throw new ModifyException("Token type is not a starting tag");
            }
            long l = this.md.getElementFragment();
            int offset = (int)l;
            int len = (int)(l >> 32);
            byte[] bo = Transcoder.transcode(b, contentOffset, contentLen, src_encoding, this.encoding);
            this.insertBytesAt(offset + len, bo);
        }
    }

    public void insertAfterElement(VTDNav vn, int contentOffset, int contentLen) throws ModifyException, UnsupportedEncodingException, NavException, TranscodeException {
        this.insertAfterElement(vn.encoding, vn.XMLDoc.getBytes(), contentOffset, contentLen);
    }

    public void insertAfterElement(byte[] b, long l1) throws ModifyException, NavException {
        int startTagIndex = this.md.getCurrentIndex();
        int type = this.md.getTokenType(startTagIndex);
        if (type != 0) {
            throw new ModifyException("Token type is not a starting tag");
        }
        long l = this.md.getElementFragment();
        int offset = (int)l;
        int len = (int)(l >> 32);
        this.insertBytesAt(offset + len, b, l1);
    }

    public void insertAfterElement(int src_encoding, byte[] b, long l1) throws ModifyException, UnsupportedEncodingException, NavException, TranscodeException {
        if (src_encoding == this.encoding) {
            this.insertAfterElement(b, l1);
        } else {
            int startTagIndex = this.md.getCurrentIndex();
            int type = this.md.getTokenType(startTagIndex);
            if (type != 0) {
                throw new ModifyException("Token type is not a starting tag");
            }
            long l = this.md.getElementFragment();
            int offset = (int)l;
            int len = (int)(l >> 32);
            byte[] bo = Transcoder.transcode(b, (int)l, (int)l >> 32, src_encoding, this.encoding);
            this.insertBytesAt(offset + len, bo, l1);
        }
    }

    public void insertAfterElement(VTDNav vn, long l1) throws ModifyException, UnsupportedEncodingException, NavException, TranscodeException {
        this.insertAfterElement(vn.encoding, vn.XMLDoc.getBytes(), l1);
    }

    public void insertAfterHead(VTDNav vn, long l1) throws ModifyException, NavException, TranscodeException {
        this.insertAfterHead(vn.encoding, vn.XMLDoc.getBytes(), l1);
    }

    public void insertAfterElement(int src_encoding, byte[] b) throws ModifyException, NavException, TranscodeException {
        if (src_encoding == this.encoding) {
            this.insertAfterElement(b);
        } else {
            int startTagIndex = this.md.getCurrentIndex();
            int type = this.md.getTokenType(startTagIndex);
            if (type != 0) {
                throw new ModifyException("Token type is not a starting tag");
            }
            long l = this.md.getElementFragment();
            int offset = (int)l;
            int len = (int)(l >> 32);
            byte[] bo = Transcoder.transcode(b, 0, b.length, src_encoding, this.encoding);
            this.insertBytesAt(offset + len, bo);
        }
    }

    public void insertAfterElement(String s) throws ModifyException, UnsupportedEncodingException, NavException {
        int startTagIndex = this.md.getCurrentIndex();
        int type = this.md.getTokenType(startTagIndex);
        if (type != 0) {
            throw new ModifyException("Token type is not a starting tag");
        }
        long l = this.md.getElementFragment();
        int offset = (int)l;
        int len = (int)(l >> 32);
        this.insertBytesAt(offset + len, s.getBytes(this.charSet));
    }

    public void insertBeforeElement(byte[] b) throws ModifyException {
        int startTagIndex = this.md.getCurrentIndex();
        int type = this.md.getTokenType(startTagIndex);
        if (type != 0) {
            throw new ModifyException("Token type is not a starting tag");
        }
        int offset = this.md.getTokenOffset(startTagIndex) - 1;
        if (this.encoding < 63) {
            this.insertBytesAt(offset, b);
        } else {
            this.insertBytesAt(offset << 1, b);
        }
    }

    public void insertBeforeElement(int src_encoding, byte[] b) throws ModifyException, TranscodeException {
        if (src_encoding == this.md.encoding) {
            this.insertBeforeElement(b);
        } else {
            int startTagIndex = this.md.getCurrentIndex();
            int type = this.md.getTokenType(startTagIndex);
            if (type != 0) {
                throw new ModifyException("Token type is not a starting tag");
            }
            int offset = this.md.getTokenOffset(startTagIndex) - 1;
            byte[] bo = Transcoder.transcode(b, 0, b.length, src_encoding, this.encoding);
            if (this.encoding < 63) {
                this.insertBytesAt(offset, bo);
            } else {
                this.insertBytesAt(offset << 1, bo);
            }
        }
    }

    public void insertBeforeElement(ElementFragmentNs ef) throws ModifyException {
        int startTagIndex = this.md.getCurrentIndex();
        int type = this.md.getTokenType(startTagIndex);
        if (type != 0) {
            throw new ModifyException("Token type is not a starting tag");
        }
        int offset = this.md.getTokenOffset(startTagIndex) - 1;
        if (this.encoding < 63) {
            this.insertElementFragmentNsAt(offset, ef);
        } else {
            this.insertElementFragmentNsAt(offset << 1, ef);
        }
    }

    public void insertBeforeElement(byte[] b, int contentOffset, int contentLen) throws ModifyException, UnsupportedEncodingException {
        int startTagIndex = this.md.getCurrentIndex();
        int type = this.md.getTokenType(startTagIndex);
        if (type != 0) {
            throw new ModifyException("Token type is not a starting tag");
        }
        int offset = this.md.getTokenOffset(startTagIndex) - 1;
        if (this.encoding < 63) {
            this.insertBytesAt(offset, b, contentOffset, contentLen);
        } else {
            this.insertBytesAt(offset << 1, b, contentOffset, contentLen);
        }
    }

    public void insertBeforeElement(int src_encoding, byte[] b, int contentOffset, int contentLen) throws ModifyException, UnsupportedEncodingException, TranscodeException {
        if (src_encoding == this.encoding) {
            this.insertBeforeElement(b, contentOffset, contentLen);
        } else {
            int startTagIndex = this.md.getCurrentIndex();
            int type = this.md.getTokenType(startTagIndex);
            if (type != 0) {
                throw new ModifyException("Token type is not a starting tag");
            }
            int offset = this.md.getTokenOffset(startTagIndex) - 1;
            byte[] bo = Transcoder.transcode(b, contentOffset, contentLen, src_encoding, this.encoding);
            if (this.encoding < 63) {
                this.insertBytesAt(offset, bo);
            } else {
                this.insertBytesAt(offset << 1, bo);
            }
        }
    }

    public void insertBeforeElement(VTDNav vn, int contentOffset, int contentLen) throws ModifyException, UnsupportedEncodingException, TranscodeException {
        this.insertBeforeElement(vn.encoding, vn.XMLDoc.getBytes(), contentOffset, contentLen);
    }

    public void insertBeforeElement(byte[] b, long l1) throws ModifyException, UnsupportedEncodingException {
        int startTagIndex = this.md.getCurrentIndex();
        int type = this.md.getTokenType(startTagIndex);
        if (type != 0) {
            throw new ModifyException("Token type is not a starting tag");
        }
        int offset = this.md.getTokenOffset(startTagIndex) - 1;
        if (this.encoding < 63) {
            this.insertBytesAt(offset, b, l1);
        } else {
            this.insertBytesAt(offset << 1, b, l1);
        }
    }

    public void insertBeforeElement(int src_encoding, byte[] b, long l1) throws ModifyException, UnsupportedEncodingException, TranscodeException {
        if (src_encoding == this.md.encoding) {
            this.insertBeforeElement(b, l1);
        } else {
            int startTagIndex = this.md.getCurrentIndex();
            int type = this.md.getTokenType(startTagIndex);
            if (type != 0) {
                throw new ModifyException("Token type is not a starting tag");
            }
            int offset = this.md.getTokenOffset(startTagIndex) - 1;
            byte[] bo = Transcoder.transcode(b, (int)l1, (int)(l1 >> 32), src_encoding, this.encoding);
            if (this.encoding < 63) {
                this.insertBytesAt(offset, bo);
            } else {
                this.insertBytesAt(offset << 1, bo);
            }
        }
    }

    public void insertBeforeElement(VTDNav vn, long l) throws ModifyException, UnsupportedEncodingException, TranscodeException {
        this.insertBeforeElement(vn.encoding, vn.XMLDoc.getBytes(), l);
    }

    public void insertBeforeElement(String s) throws ModifyException, UnsupportedEncodingException {
        int startTagIndex = this.md.getCurrentIndex();
        int type = this.md.getTokenType(startTagIndex);
        if (type != 0) {
            throw new ModifyException("Token type is not a starting tag");
        }
        int offset = this.md.getTokenOffset(startTagIndex) - 1;
        if (this.encoding < 63) {
            this.insertBytesAt(offset, s.getBytes(this.charSet));
        } else {
            this.insertBytesAt(offset << 1, s.getBytes(this.charSet));
        }
    }

    public void insertAttribute(String attr) throws ModifyException, UnsupportedEncodingException {
        int startTagIndex = this.md.getCurrentIndex();
        int type = this.md.getTokenType(startTagIndex);
        if (type != 0) {
            throw new ModifyException("Token type is not a starting tag");
        }
        int offset = this.md.getTokenOffset(startTagIndex);
        int len = this.md.getTokenLength(startTagIndex) & 0xFFFF;
        if (this.encoding < 63) {
            this.insertBytesAt(offset + len, attr.getBytes(this.charSet));
        } else {
            this.insertBytesAt(offset + len << 1, attr.getBytes(this.charSet));
        }
    }

    public void insertAttribute(byte[] b) throws ModifyException, UnsupportedEncodingException {
        int startTagIndex = this.md.getCurrentIndex();
        int type = this.md.getTokenType(startTagIndex);
        if (type != 0) {
            throw new ModifyException("Token type is not a starting tag");
        }
        int offset = this.md.getTokenOffset(startTagIndex);
        int len = this.md.getTokenLength(startTagIndex) & 0xFFFF;
        if (this.encoding < 63) {
            this.insertBytesAt(offset + len, b);
        } else {
            this.insertBytesAt(offset + len << 1, b);
        }
    }

    public void insertAttribute(int src_encoding, byte[] b) throws ModifyException, UnsupportedEncodingException, TranscodeException {
        int startTagIndex = this.md.getCurrentIndex();
        int type = this.md.getTokenType(startTagIndex);
        if (type != 0) {
            throw new ModifyException("Token type is not a starting tag");
        }
        int offset = this.md.getTokenOffset(startTagIndex);
        int len = this.md.getTokenLength(startTagIndex) & 0xFFFF;
        byte[] bo = Transcoder.transcode(b, 0, b.length, src_encoding, this.encoding);
        if (this.encoding < 63) {
            this.insertBytesAt(offset + len, bo);
        } else {
            this.insertBytesAt(offset + len << 1, bo);
        }
    }

    public void output(OutputStream os) throws IOException, ModifyException, TranscodeException {
        int len;
        if (os == null) {
            throw new IllegalArgumentException("OutputStream can't be null");
        }
        this.sort();
        this.check2();
        byte[] ba = this.md.getXML().getBytes();
        int t = this.md.vtdBuffer.lower32At(0);
        int start = t == 0 ? this.md.docOffset : 32;
        int n = len = t == 0 ? this.md.docLen : this.md.docLen - 32;
        if (this.flb.size == 0) {
            os.write(ba, start, len);
        } else if (this.md.encoding < 63) {
            int offset = start;
            int inc = 1;
            for (int i = 0; i < this.flb.size; i += inc) {
                ElementFragmentNs ef;
                ByteSegment bs;
                inc = i + 1 == this.flb.size ? 1 : (this.flb.lower32At(i) == this.flb.lower32At(i + 1) ? 2 : 1);
                long l = this.flb.longAt(i);
                if (inc == 1) {
                    if ((l & 0xE000000000000000L) == 0L) {
                        os.write(ba, offset, this.flb.lower32At(i) - offset);
                        offset = this.flb.lower32At(i) + (this.flb.upper32At(i) & 0x1FFFFFFF);
                        continue;
                    }
                    if ((l & 0xE000000000000000L) == 0x4000000000000000L) {
                        os.write(ba, offset, this.flb.lower32At(i) - offset);
                        os.write((byte[])this.fob.objectAt(i));
                        offset = this.flb.lower32At(i);
                        continue;
                    }
                    if ((l & 0xE000000000000000L) == 0x2000000000000000L) {
                        os.write(ba, offset, this.flb.lower32At(i) - offset);
                        ByteSegment bs2 = (ByteSegment)this.fob.objectAt(i);
                        os.write(bs2.ba, bs2.offset, bs2.len);
                        offset = this.flb.lower32At(i);
                        continue;
                    }
                    if ((l & 0xE000000000000000L) == -6917529027641081856L) {
                        os.write(ba, offset, this.flb.lower32At(i) - offset);
                        ElementFragmentNs ef2 = (ElementFragmentNs)this.fob.objectAt(i);
                        ef2.writeToOutputStream(os, this.md.encoding);
                        offset = this.flb.lower32At(i);
                        continue;
                    }
                    if ((l & 0xE000000000000000L) == Long.MIN_VALUE) {
                        os.write(ba, offset, this.flb.lower32At(i) - offset);
                        os.write(62);
                        os.write((byte[])this.fob.objectAt(i));
                        os.write(60);
                        offset = this.flb.lower32At(i);
                        continue;
                    }
                    if ((l & 0xE000000000000000L) == 0x6000000000000000L) {
                        os.write(ba, offset, this.flb.lower32At(i) - offset);
                        ByteSegment bs3 = (ByteSegment)this.fob.objectAt(i);
                        os.write(62);
                        os.write(bs3.ba, bs3.offset, bs3.len);
                        os.write(60);
                        offset = this.flb.lower32At(i);
                        continue;
                    }
                    if ((l & 0xE000000000000000L) != -2305843009213693952L) continue;
                    os.write(ba, offset, this.flb.lower32At(i) - offset);
                    ElementFragmentNs ef3 = (ElementFragmentNs)this.fob.objectAt(i);
                    os.write(62);
                    ef3.writeToOutputStream(os, this.md.encoding);
                    os.write(60);
                    offset = this.flb.lower32At(i);
                    continue;
                }
                long k = this.flb.longAt(i + 1);
                int i1 = i;
                int i2 = i + 1;
                if ((l & 0xE000000000000000L) != 0L) {
                    long temp = l;
                    l = k;
                    k = temp;
                    int temp2 = i1;
                    i1 = i2;
                    i2 = temp2;
                }
                if ((l & 0xE000000000000000L) == -4611686018427387904L) continue;
                os.write(ba, offset, this.flb.lower32At(i1) - offset);
                if ((k & 0xE000000000000000L) == 0x4000000000000000L) {
                    os.write((byte[])this.fob.objectAt(i2));
                    offset = this.flb.lower32At(i1) + (this.flb.upper32At(i1) & 0x1FFFFFFF);
                    continue;
                }
                if ((k & 0xE000000000000000L) == 0x2000000000000000L) {
                    bs = (ByteSegment)this.fob.objectAt(i2);
                    os.write(bs.ba, bs.offset, bs.len);
                    offset = this.flb.lower32At(i1) + (this.flb.upper32At(i1) & 0x1FFFFFFF);
                    continue;
                }
                if ((k & 0xE000000000000000L) == -6917529027641081856L) {
                    ef = (ElementFragmentNs)this.fob.objectAt(i2);
                    ef.writeToOutputStream(os, this.md.encoding);
                    offset = this.flb.lower32At(i1) + (this.flb.upper32At(i1) & 0x1FFFFFFF);
                    continue;
                }
                if ((k & 0xE000000000000000L) == Long.MIN_VALUE) {
                    os.write(62);
                    os.write((byte[])this.fob.objectAt(i2));
                    os.write(60);
                    offset = this.flb.lower32At(i1) + (this.flb.upper32At(i1) & 0x1FFFFFFF);
                    continue;
                }
                if ((k & 0xE000000000000000L) == 0x6000000000000000L) {
                    bs = (ByteSegment)this.fob.objectAt(i2);
                    os.write(62);
                    os.write(bs.ba, bs.offset, bs.len);
                    os.write(60);
                    offset = this.flb.lower32At(i1) + (this.flb.upper32At(i1) & 0x1FFFFFFF);
                    continue;
                }
                if ((k & 0xE000000000000000L) != -2305843009213693952L) continue;
                ef = (ElementFragmentNs)this.fob.objectAt(i2);
                os.write(62);
                ef.writeToOutputStream(os, this.md.encoding);
                os.write(60);
                offset = this.flb.lower32At(i1) + (this.flb.upper32At(i1) & 0x1FFFFFFF);
            }
            os.write(ba, offset, start + len - offset);
        } else {
            byte[] b1 = ba1;
            byte[] b2 = ba2;
            if (this.md.encoding == 63) {
                b1 = ba3;
                b2 = ba4;
            }
            int offset = start;
            int inc = 1;
            for (int i = 0; i < this.flb.size; i += inc) {
                ElementFragmentNs ef;
                ByteSegment bs;
                inc = i + 1 == this.flb.size ? 1 : (this.flb.lower32At(i) == this.flb.lower32At(i + 1) ? 2 : 1);
                long l = this.flb.longAt(i);
                if (inc == 1) {
                    if ((l & 0xE000000000000000L) == 0L) {
                        os.write(ba, offset, (this.flb.lower32At(i) << 1) - offset);
                        offset = this.flb.lower32At(i) + (this.flb.upper32At(i) & 0x1FFFFFFF) << 1;
                        continue;
                    }
                    if ((l & 0xE000000000000000L) == 0x4000000000000000L) {
                        os.write(ba, offset, (this.flb.lower32At(i) << 1) - offset);
                        os.write((byte[])this.fob.objectAt(i));
                        offset = this.flb.lower32At(i) << 1;
                        continue;
                    }
                    if ((l & 0xE000000000000000L) == 0x2000000000000000L) {
                        os.write(ba, offset, (this.flb.lower32At(i) << 1) - offset);
                        ByteSegment bs4 = (ByteSegment)this.fob.objectAt(i);
                        os.write(bs4.ba, bs4.offset, bs4.len);
                        offset = this.flb.lower32At(i) << 1;
                        continue;
                    }
                    if ((l & 0xE000000000000000L) == -6917529027641081856L) {
                        os.write(ba, offset, (this.flb.lower32At(i) << 1) - offset);
                        ElementFragmentNs ef4 = (ElementFragmentNs)this.fob.objectAt(i);
                        ef4.writeToOutputStream(os, this.md.encoding);
                        offset = this.flb.lower32At(i) << 1;
                        continue;
                    }
                    if ((l & 0xE000000000000000L) == Long.MIN_VALUE) {
                        os.write(ba, offset, (this.flb.lower32At(i) << 1) - offset);
                        os.write(b1);
                        os.write((byte[])this.fob.objectAt(i));
                        os.write(b2);
                        offset = this.flb.lower32At(i) << 1;
                        continue;
                    }
                    if ((l & 0xE000000000000000L) == 0x6000000000000000L) {
                        os.write(ba, offset, (this.flb.lower32At(i) << 1) - offset);
                        ByteSegment bs5 = (ByteSegment)this.fob.objectAt(i);
                        os.write(b1);
                        os.write(bs5.ba, bs5.offset, bs5.len);
                        os.write(b2);
                        offset = this.flb.lower32At(i) << 1;
                        continue;
                    }
                    if ((l & 0xE000000000000000L) != -2305843009213693952L) continue;
                    os.write(ba, offset, (this.flb.lower32At(i) << 1) - offset);
                    ElementFragmentNs ef5 = (ElementFragmentNs)this.fob.objectAt(i);
                    os.write(b1);
                    ef5.writeToOutputStream(os, this.md.encoding);
                    os.write(b2);
                    offset = this.flb.lower32At(i) << 1;
                    continue;
                }
                long k = this.flb.longAt(i + 1);
                int i1 = i;
                int i2 = i + 1;
                if ((l & 0xE000000000000000L) != 0L) {
                    long temp = l;
                    l = k;
                    k = temp;
                    int temp2 = i1;
                    i1 = i2;
                    i2 = temp2;
                }
                if ((l & 0xE000000000000000L) == -4611686018427387904L) continue;
                os.write(ba, offset, (this.flb.lower32At(i1) << 1) - offset);
                if ((k & 0xE000000000000000L) == 0x4000000000000000L) {
                    os.write((byte[])this.fob.objectAt(i2));
                    offset = this.flb.lower32At(i1) + (this.flb.upper32At(i1) & 0x1FFFFFFF) << 1;
                    continue;
                }
                if ((k & 0xE000000000000000L) == 0x2000000000000000L) {
                    bs = (ByteSegment)this.fob.objectAt(i2);
                    os.write(bs.ba, bs.offset, bs.len);
                    offset = this.flb.lower32At(i1) + (this.flb.upper32At(i1) & 0x1FFFFFFF) << 1;
                    continue;
                }
                if ((k & 0xE000000000000000L) == -6917529027641081856L) {
                    ef = (ElementFragmentNs)this.fob.objectAt(i2);
                    ef.writeToOutputStream(os, this.md.encoding);
                    offset = this.flb.lower32At(i1) + (this.flb.upper32At(i1) & 0x1FFFFFFF) << 1;
                    continue;
                }
                if ((k & 0xE000000000000000L) == Long.MIN_VALUE) {
                    os.write(b1);
                    os.write((byte[])this.fob.objectAt(i2));
                    os.write(b2);
                    offset = this.flb.lower32At(i1) + (this.flb.upper32At(i1) & 0x1FFFFFFF) << 1;
                    continue;
                }
                if ((k & 0xE000000000000000L) == 0x6000000000000000L) {
                    bs = (ByteSegment)this.fob.objectAt(i2);
                    os.write(b1);
                    os.write(bs.ba, bs.offset, bs.len);
                    os.write(b2);
                    offset = this.flb.lower32At(i1) + (this.flb.upper32At(i1) & 0x1FFFFFFF) << 1;
                    continue;
                }
                if ((k & 0xE000000000000000L) != -2305843009213693952L) continue;
                ef = (ElementFragmentNs)this.fob.objectAt(i2);
                os.write(b1);
                ef.writeToOutputStream(os, this.md.encoding);
                os.write(b2);
                offset = this.flb.lower32At(i1) + (this.flb.upper32At(i1) & 0x1FFFFFFF) << 1;
            }
            os.write(ba, offset, start + len - offset);
        }
    }

    public void output(String fileName) throws IOException, ModifyException, TranscodeException {
        FileOutputStream fos = new FileOutputStream(fileName);
        this.output(fos);
        fos.close();
    }

    void quickSort(int lo, int hi) {
        int i = lo;
        int j = hi;
        int x = this.flb.lower32At((lo + hi) / 2);
        while (true) {
            if (this.flb.lower32At(i) < x) {
                ++i;
                continue;
            }
            while (this.flb.lower32At(j) > x) {
                --j;
            }
            if (i <= j) {
                long h = this.flb.longAt(i);
                Object o = this.fob.objectAt(i);
                this.flb.modifyEntry(i, this.flb.longAt(j));
                this.fob.modifyEntry(i, this.fob.objectAt(j));
                this.flb.modifyEntry(j, h);
                this.fob.modifyEntry(j, o);
                ++i;
                --j;
            }
            if (i > j) break;
        }
        if (lo < j) {
            this.quickSort(lo, j);
        }
        if (i < hi) {
            this.quickSort(i, hi);
        }
    }

    public void reset() {
        if (this.flb != null) {
            this.flb.size = 0;
        }
        if (this.fob != null) {
            this.fob.size = 0;
        }
        if (this.insertHash != null) {
            this.insertHash.reset();
        }
        if (this.deleteHash != null) {
            this.deleteHash.reset();
        }
    }

    public void updateElementName(String newElementName) throws ModifyException, NavException, UnsupportedEncodingException {
        int i = this.md.getCurrentIndex();
        int type = this.md.getTokenType(i);
        if (type != 0) {
            throw new ModifyException("You can only update an element name");
        }
        int len = this.md.getTokenLength(i) & 0xFFFF;
        this.updateToken(i, newElementName);
        long l = this.md.getElementFragment();
        int encoding = this.md.getEncoding();
        byte[] xml = this.md.getXML().getBytes();
        int temp = (int)l + (int)(l >> 32);
        if (encoding < 63) {
            if (xml[temp - 2] == 47) {
                return;
            }
            --temp;
            while (xml[temp] != 47) {
                --temp;
            }
            this.insertBytesAt(temp + 1, newElementName.getBytes(this.charSet));
            this.removeContent(temp + 1, len);
            return;
        }
        if (encoding == 63) {
            if (xml[temp - 3] == 47 && xml[temp - 4] == 0) {
                return;
            }
            temp -= 2;
            while (xml[temp + 1] != 47 || xml[temp] != 0) {
                temp -= 2;
            }
            this.insertBytesAt(temp + 2, newElementName.getBytes(this.charSet));
            this.removeContent(temp + 2, len << 1);
        } else {
            if (xml[temp - 3] == 0 && xml[temp - 4] == 47) {
                return;
            }
            temp -= 2;
            while (xml[temp] != 47 || xml[temp + 1] != 0) {
                temp -= 2;
            }
            this.insertBytesAt(temp + 2, newElementName.getBytes(this.charSet));
            this.removeContent(temp + 2, len << 1);
        }
    }

    public VTDNav outputAndReparse() throws ParseException, IOException, TranscodeException, ModifyException {
        XMLByteOutputStream xbos = new XMLByteOutputStream(this.getUpdatedDocumentSize());
        this.output(xbos);
        VTDGen vg = new VTDGen();
        vg.setDoc(xbos.getXML());
        vg.parse(this.md.ns);
        return vg.getNav();
    }

    public class ByteSegment {
        byte[] ba;
        int offset;
        int len;
    }
}

