/*
 * Decompiled with CFR 0.152.
 */
package com.ximpleware.extended.xpath;

import com.ximpleware.extended.NavExceptionHuge;
import com.ximpleware.extended.NodeTest;
import com.ximpleware.extended.VTDNavHuge;
import com.ximpleware.extended.xpath.LocationPathNode;
import com.ximpleware.extended.xpath.Predicate;

public class Step
implements LocationPathNode {
    public int axis_type;
    public NodeTest nt;
    public Predicate p;
    public Predicate pt;
    public Step nextS;
    public int position;
    public Step prevS;
    public Object o;
    boolean ft;

    public Step() {
        this.nextS = this.prevS = (Step)null;
        this.pt = null;
        this.p = null;
        this.nt = null;
        this.ft = true;
        this.position = 1;
    }

    public void reset(VTDNavHuge vTDNavHuge) {
        this.ft = true;
        this.resetP(vTDNavHuge);
        this.position = 1;
    }

    public void resetP(VTDNavHuge vTDNavHuge) {
        Predicate predicate = this.p;
        while (predicate != null) {
            predicate.reset(vTDNavHuge);
            predicate = predicate.nextP;
        }
    }

    public void resetP(VTDNavHuge vTDNavHuge, Predicate predicate) {
        Predicate predicate2 = this.p;
        while (predicate2 != predicate) {
            predicate2.reset(vTDNavHuge);
            predicate2 = predicate2.nextP;
        }
    }

    public void adjust(int n) {
        Predicate predicate = this.p;
        while (predicate != null) {
            predicate.adjust(n);
            predicate = predicate.nextP;
        }
    }

    public NodeTest getNodeTest() {
        return this.nt;
    }

    public Step getNextStep() {
        return this.nextS;
    }

    public void setNextStep(Step step) {
        this.nextS = step;
    }

    public boolean get_ft() {
        return this.ft;
    }

    public void set_ft(boolean bl) {
        this.ft = bl;
    }

    public Step getPrevStep() {
        return this.prevS;
    }

    public void setPrevStep(Step step) {
        this.prevS = step;
    }

    public void setNodeTest(NodeTest nodeTest) {
        this.nt = nodeTest;
    }

    public void setPredicate(Predicate predicate) {
        if (this.p == null) {
            this.p = this.pt = predicate;
        } else {
            this.pt = this.pt.nextP = predicate;
        }
    }

    @Override
    public boolean eval(VTDNavHuge vTDNavHuge) throws NavExceptionHuge {
        return this.nt.eval(vTDNavHuge) && this.evalPredicates(vTDNavHuge);
    }

    public boolean eval(VTDNavHuge vTDNavHuge, Predicate predicate) throws NavExceptionHuge {
        return this.nt.eval(vTDNavHuge) && this.evalPredicates(vTDNavHuge, predicate);
    }

    public boolean evalPredicates(VTDNavHuge vTDNavHuge) throws NavExceptionHuge {
        Predicate predicate = this.p;
        while (predicate != null) {
            if (!predicate.eval(vTDNavHuge)) {
                return false;
            }
            predicate = predicate.nextP;
        }
        return true;
    }

    public boolean evalPredicates(VTDNavHuge vTDNavHuge, Predicate predicate) throws NavExceptionHuge {
        Predicate predicate2 = this.p;
        while (predicate2 != predicate) {
            if (!predicate2.eval(vTDNavHuge)) {
                return false;
            }
            predicate2 = predicate2.nextP;
        }
        return true;
    }

    public void setAxisType(int n) {
        this.axis_type = n;
    }

    public String toString() {
        String string = this.p == null ? this.axisName(this.axis_type) + this.nt : this.axisName(this.axis_type) + this.nt + " " + this.p;
        if (this.nextS == null) {
            return string;
        }
        return string + "/" + this.nextS.toString();
    }

    public String axisName(int n) {
        switch (n) {
            case 0: {
                return "child::";
            }
            case 1: {
                return "descendant::";
            }
            case 2: {
                return "parent::";
            }
            case 4: {
                return "following-sibling::";
            }
            case 5: {
                return "preceding-sibling::";
            }
            case 6: {
                return "following::";
            }
            case 7: {
                return "preceding::";
            }
            case 8: {
                return "attribute::";
            }
            case 9: {
                return "namespace::";
            }
            case 10: {
                return "self::";
            }
            case 11: {
                return "descendant-or-self::";
            }
            case 3: {
                return "ancestor::";
            }
        }
        return "ancestor-or-self::";
    }
}

