/*
 * Decompiled with CFR 0.152.
 */
package com.ximpleware.extended.xpath;

import com.ximpleware.extended.VTDNavHuge;
import com.ximpleware.extended.XPathEvalExceptionHuge;
import com.ximpleware.extended.xpath.Expr;

public class LiteralExpr
extends Expr {
    public String s;

    public LiteralExpr(String string) {
        this.s = string;
    }

    @Override
    public String toString() {
        boolean bl = true;
        for (int i = 0; i < this.s.length(); ++i) {
            if (this.s.charAt(i) != '\'') continue;
            bl = false;
            break;
        }
        if (bl) {
            return "\"" + this.s + "\"";
        }
        return "'" + this.s + "'";
    }

    @Override
    public boolean evalBoolean(VTDNavHuge vTDNavHuge) {
        return this.s.length() != 0;
    }

    @Override
    public double evalNumber(VTDNavHuge vTDNavHuge) {
        try {
            double d = Double.parseDouble(this.s);
            return d;
        }
        catch (NumberFormatException numberFormatException) {
            return Double.NaN;
        }
    }

    @Override
    public int evalNodeSet(VTDNavHuge vTDNavHuge) throws XPathEvalExceptionHuge {
        throw new XPathEvalExceptionHuge("LiteralExpr can't eval to a node set!");
    }

    @Override
    public String evalString(VTDNavHuge vTDNavHuge) {
        return this.s;
    }

    @Override
    public void reset(VTDNavHuge vTDNavHuge) {
    }

    @Override
    public boolean isNodeSet() {
        return false;
    }

    @Override
    public boolean isNumerical() {
        return false;
    }

    @Override
    public boolean isString() {
        return true;
    }

    @Override
    public boolean isBoolean() {
        return false;
    }

    @Override
    public boolean requireContextSize() {
        return false;
    }

    @Override
    public void setContextSize(int n) {
    }

    @Override
    public void setPosition(int n) {
    }

    @Override
    public int adjust(int n) {
        return 0;
    }
}

