/*
 * Decompiled with CFR 0.152.
 */
package com.ximpleware.transcode;

import com.ximpleware.TranscodeException;
import java.io.IOException;
import java.io.OutputStream;

public class UTF8_Coder {
    public static int encode(byte[] byArray, int n, int n2) {
        if (n2 < 128) {
            byArray[n] = (byte)n2;
            return n + 1;
        }
        if (n2 < 2048) {
            byArray[n] = (byte)((n2 & 0x7C0) >> 6 | 0xC0);
            byArray[n + 1] = (byte)(n2 & 0x3F | 0x80);
            return n + 2;
        }
        if (n2 < 57344) {
            byArray[n] = (byte)((n2 & 0xF000) >> 12 | 0xE0);
            byArray[n + 1] = (byte)((n2 & 0xFC) >> 6 | 0x80);
            byArray[n + 2] = (byte)(n2 & 0x3F | 0x80);
            return n + 3;
        }
        byArray[n] = (byte)((n2 & 0x1C0000) >> 18 | 0xF0);
        byArray[n + 1] = (byte)((n2 & 0x3F0) >> 12 | 0x80);
        byArray[n + 2] = (byte)((n2 & 0xFC) >> 6 | 0x80);
        byArray[n + 3] = (byte)(n2 & 0x3F | 0x80);
        return n + 4;
    }

    public static final void encodeAndWrite(OutputStream outputStream, int n) throws IOException, TranscodeException {
        if (n < 128) {
            outputStream.write(n);
            return;
        }
        if (n < 2048) {
            outputStream.write((n & 0x7C0) >> 6 | 0xC0);
            outputStream.write(n & 0x3F | 0x80);
            return;
        }
        if (n < 57344) {
            outputStream.write((n & 0xF000) >> 12 | 0xE0);
            outputStream.write((n & 0xFC) >> 6 | 0x80);
            outputStream.write(n & 0x3F | 0x80);
            return;
        }
        outputStream.write((n & 0x1C0000) >> 18 | 0xF0);
        outputStream.write((n & 0x3F0) >> 12 | 0x80);
        outputStream.write((n & 0xFC) >> 6 | 0x80);
        outputStream.write(n & 0x3F | 0x80);
    }

    public static long decode(byte[] byArray, int n) {
        long l = 0L;
        int n2 = 0;
        byte by = byArray[n];
        if (by > 0) {
            l = n + 1;
            return l << 32 | (long)by;
        }
        if ((by & 0xE0) == 192) {
            l = n + 2;
            n2 = (by & 0x1F) << 6 | byArray[n + 1] & 0x3F;
            return l << 32 | (long)n2;
        }
        if ((by & 0xF0) == 224) {
            l = n + 3;
            n2 = (by & 0xF) << 12 | (byArray[n + 1] & 0x3F) << 6 | byArray[n + 2] & 0x3F;
            return l << 32 | (long)n2;
        }
        l = n + 4;
        n2 = (by & 7) << 18 | (byArray[n + 1] & 0x3F) << 12 | (byArray[n + 2] & 0x3F) << 6 | byArray[n + 3] & 0x3F;
        return l << 32 | (long)n2;
    }

    public static int getLen(int n) throws TranscodeException {
        if (n < 128) {
            return 1;
        }
        if (n < 2048) {
            return 2;
        }
        if (n < 57344) {
            return 3;
        }
        if (n < 65536) {
            return 4;
        }
        return 5;
    }
}

