/*
 * Decompiled with CFR 0.152.
 */
package com.xingyuv.captcha.service.impl;

import com.xingyuv.captcha.model.common.CaptchaTypeEnum;
import com.xingyuv.captcha.model.common.RepCodeEnum;
import com.xingyuv.captcha.model.common.ResponseModel;
import com.xingyuv.captcha.model.vo.CaptchaVO;
import com.xingyuv.captcha.model.vo.PointVO;
import com.xingyuv.captcha.service.impl.AbstractCaptchaService;
import com.xingyuv.captcha.service.impl.CaptchaServiceFactory;
import com.xingyuv.captcha.util.AESUtil;
import com.xingyuv.captcha.util.ImageUtils;
import com.xingyuv.captcha.util.JsonUtil;
import com.xingyuv.captcha.util.RandomUtils;
import com.xingyuv.captcha.util.StringUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.util.Base64;
import java.util.Objects;
import java.util.Properties;
import java.util.Random;
import javax.imageio.ImageIO;

public class BlockPuzzleCaptchaServiceImpl
extends AbstractCaptchaService {
    @Override
    public void init(Properties config) {
        super.init(config);
    }

    @Override
    public void destroy(Properties config) {
        this.logger.info("start-clear-history-data-", (Object)this.captchaType());
    }

    @Override
    public String captchaType() {
        return CaptchaTypeEnum.BLOCKPUZZLE.getCodeValue();
    }

    @Override
    public ResponseModel get(CaptchaVO captchaVO) {
        ResponseModel r = super.get(captchaVO);
        if (!this.validatedReq(r)) {
            return r;
        }
        BufferedImage originalImage = ImageUtils.getOriginal();
        if (null == originalImage) {
            this.logger.error("\u6ed1\u52a8\u5e95\u56fe\u672a\u521d\u59cb\u5316\u6210\u529f\uff0c\u8bf7\u68c0\u67e5\u8def\u5f84");
            return ResponseModel.errorMsg(RepCodeEnum.API_CAPTCHA_BASEMAP_NULL);
        }
        Graphics backgroundGraphics = originalImage.getGraphics();
        int width = originalImage.getWidth();
        int height = originalImage.getHeight();
        backgroundGraphics.setFont(this.waterMarkFont);
        backgroundGraphics.setColor(Color.white);
        backgroundGraphics.drawString(waterMark, width - BlockPuzzleCaptchaServiceImpl.getEnOrChLength(waterMark), height - HAN_ZI_SIZE / 2 + 7);
        String jigsawImageBase64 = ImageUtils.getSlidingBlock();
        BufferedImage jigsawImage = ImageUtils.getBase64StrToImage(jigsawImageBase64);
        if (null == jigsawImage) {
            this.logger.error("\u6ed1\u52a8\u5e95\u56fe\u672a\u521d\u59cb\u5316\u6210\u529f\uff0c\u8bf7\u68c0\u67e5\u8def\u5f84");
            return ResponseModel.errorMsg(RepCodeEnum.API_CAPTCHA_BASEMAP_NULL);
        }
        CaptchaVO captcha = this.pictureTemplatesCut(originalImage, jigsawImage, jigsawImageBase64);
        if (captcha == null || StringUtils.isBlank(captcha.getJigsawImageBase64()) || StringUtils.isBlank(captcha.getOriginalImageBase64())) {
            return ResponseModel.errorMsg(RepCodeEnum.API_CAPTCHA_ERROR);
        }
        return ResponseModel.successData(captcha);
    }

    @Override
    public ResponseModel check(CaptchaVO captchaVO) {
        boolean exists;
        ResponseModel r = super.check(captchaVO);
        if (!this.validatedReq(r)) {
            return r;
        }
        String codeKey = String.format(REDIS_CAPTCHA_KEY, captchaVO.getToken());
        if (!CaptchaServiceFactory.getCache(cacheType).exists(codeKey)) {
            return ResponseModel.errorMsg(RepCodeEnum.API_CAPTCHA_INVALID);
        }
        String s = CaptchaServiceFactory.getCache(cacheType).get(codeKey);
        CaptchaServiceFactory.getCache(cacheType).delete(codeKey);
        PointVO point = null;
        PointVO point1 = null;
        String pointJson = null;
        try {
            point = JsonUtil.parseObject(s, PointVO.class);
            pointJson = BlockPuzzleCaptchaServiceImpl.decrypt(captchaVO.getPointJson(), point.getSecretKey());
            point1 = JsonUtil.parseObject(pointJson, PointVO.class);
        }
        catch (Exception e) {
            this.logger.error("\u9a8c\u8bc1\u7801\u5750\u6807\u89e3\u6790\u5931\u8d25", (Throwable)e);
            this.afterValidateFail(captchaVO);
            return ResponseModel.errorMsg(e.getMessage());
        }
        boolean bl = exists = point.x - Integer.parseInt(slipOffset) > point1.x || point1.x > point.x + Integer.parseInt(slipOffset) || point.y != point1.y;
        if (exists) {
            this.afterValidateFail(captchaVO);
            return ResponseModel.errorMsg(RepCodeEnum.API_CAPTCHA_COORDINATE_ERROR);
        }
        String secretKey = point.getSecretKey();
        String value = null;
        try {
            value = AESUtil.aesEncrypt(captchaVO.getToken().concat("---").concat(pointJson), secretKey);
        }
        catch (Exception e) {
            this.logger.error("AES\u52a0\u5bc6\u5931\u8d25", (Throwable)e);
            this.afterValidateFail(captchaVO);
            return ResponseModel.errorMsg(e.getMessage());
        }
        String secondKey = String.format(REDIS_SECOND_CAPTCHA_KEY, value);
        CaptchaServiceFactory.getCache(cacheType).set(secondKey, captchaVO.getToken(), EXPIRESIN_THREE);
        captchaVO.setResult(true);
        captchaVO.resetClientFlag();
        return ResponseModel.successData(captchaVO);
    }

    @Override
    public ResponseModel verification(CaptchaVO captchaVO) {
        ResponseModel r = super.verification(captchaVO);
        if (!this.validatedReq(r)) {
            return r;
        }
        try {
            String codeKey = String.format(REDIS_SECOND_CAPTCHA_KEY, captchaVO.getCaptchaVerification());
            if (!CaptchaServiceFactory.getCache(cacheType).exists(codeKey)) {
                return ResponseModel.errorMsg(RepCodeEnum.API_CAPTCHA_INVALID);
            }
            CaptchaServiceFactory.getCache(cacheType).delete(codeKey);
        }
        catch (Exception e) {
            this.logger.error("\u9a8c\u8bc1\u7801\u5750\u6807\u89e3\u6790\u5931\u8d25", (Throwable)e);
            return ResponseModel.errorMsg(e.getMessage());
        }
        return ResponseModel.success();
    }

    public CaptchaVO pictureTemplatesCut(BufferedImage originalImage, BufferedImage jigsawImage, String jigsawImageBase64) {
        try {
            CaptchaVO dataVO = new CaptchaVO();
            int originalWidth = originalImage.getWidth();
            int originalHeight = originalImage.getHeight();
            int jigsawWidth = jigsawImage.getWidth();
            int jigsawHeight = jigsawImage.getHeight();
            PointVO point = BlockPuzzleCaptchaServiceImpl.generateJigsawPoint(originalWidth, originalHeight, jigsawWidth, jigsawHeight);
            int x = point.getX();
            BufferedImage newJigsawImage = new BufferedImage(jigsawWidth, jigsawHeight, jigsawImage.getType());
            Graphics2D graphics = newJigsawImage.createGraphics();
            int bold = 5;
            newJigsawImage = graphics.getDeviceConfiguration().createCompatibleImage(jigsawWidth, jigsawHeight, 3);
            BlockPuzzleCaptchaServiceImpl.cutByTemplate(originalImage, jigsawImage, newJigsawImage, x, 0);
            if (captchaInterferenceOptions > 0) {
                String s;
                int position = 0;
                position = originalWidth - x - 5 > jigsawWidth * 2 ? RandomUtils.getRandomInt(x + jigsawWidth + 5, originalWidth - jigsawWidth).intValue() : RandomUtils.getRandomInt(100, x - jigsawWidth - 5).intValue();
                while (jigsawImageBase64.equals(s = ImageUtils.getSlidingBlock())) {
                }
                BlockPuzzleCaptchaServiceImpl.interferenceByTemplate(originalImage, Objects.requireNonNull(ImageUtils.getBase64StrToImage(s)), position, 0);
            }
            if (captchaInterferenceOptions > 1) {
                String s;
                while (jigsawImageBase64.equals(s = ImageUtils.getSlidingBlock())) {
                }
                Integer randomInt = RandomUtils.getRandomInt(jigsawWidth, 100 - jigsawWidth);
                BlockPuzzleCaptchaServiceImpl.interferenceByTemplate(originalImage, Objects.requireNonNull(ImageUtils.getBase64StrToImage(s)), randomInt, 0);
            }
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics.setStroke(new BasicStroke(bold, 0, 2));
            graphics.drawImage((Image)newJigsawImage, 0, 0, null);
            graphics.dispose();
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)newJigsawImage, "png", os);
            byte[] jigsawImages = os.toByteArray();
            ByteArrayOutputStream oriImagesOs = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)originalImage, "png", oriImagesOs);
            byte[] oriCopyImages = oriImagesOs.toByteArray();
            Base64.Encoder encoder = Base64.getEncoder();
            dataVO.setOriginalImageBase64(encoder.encodeToString(oriCopyImages).replaceAll("\r|\n", ""));
            dataVO.setJigsawImageBase64(encoder.encodeToString(jigsawImages).replaceAll("\r|\n", ""));
            dataVO.setToken(RandomUtils.getUUID());
            dataVO.setSecretKey(point.getSecretKey());
            String codeKey = String.format(REDIS_CAPTCHA_KEY, dataVO.getToken());
            CaptchaServiceFactory.getCache(cacheType).set(codeKey, JsonUtil.toJSONString(point), EXPIRESIN_SECONDS);
            this.logger.debug("token\uff1a{},point:{}", (Object)dataVO.getToken(), (Object)JsonUtil.toJSONString(point));
            return dataVO;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static PointVO generateJigsawPoint(int originalWidth, int originalHeight, int jigsawWidth, int jigsawHeight) {
        Random random = new Random();
        int widthDifference = originalWidth - jigsawWidth;
        int heightDifference = originalHeight - jigsawHeight;
        int y = 0;
        int x = widthDifference <= 0 ? 5 : random.nextInt(originalWidth - jigsawWidth - 100) + 100;
        y = heightDifference <= 0 ? 5 : random.nextInt(originalHeight - jigsawHeight) + 5;
        String key = null;
        if (captchaAesStatus.booleanValue()) {
            key = AESUtil.getKey();
        }
        return new PointVO(x, y, key);
    }

    private static void cutByTemplate(BufferedImage oriImage, BufferedImage templateImage, BufferedImage newImage, int x, int y) {
        int[][] martrix = new int[3][3];
        int[] values = new int[9];
        int xLength = templateImage.getWidth();
        int yLength = templateImage.getHeight();
        for (int i = 0; i < xLength; ++i) {
            for (int j = 0; j < yLength; ++j) {
                boolean exists;
                int rgb = templateImage.getRGB(i, j);
                if (rgb < 0) {
                    newImage.setRGB(i, j, oriImage.getRGB(x + i, y + j));
                    BlockPuzzleCaptchaServiceImpl.readPixel(oriImage, x + i, y + j, values);
                    BlockPuzzleCaptchaServiceImpl.fillMatrix(martrix, values);
                    oriImage.setRGB(x + i, y + j, BlockPuzzleCaptchaServiceImpl.avgMatrix(martrix));
                }
                if (i == xLength - 1 || j == yLength - 1) continue;
                int rightRgb = templateImage.getRGB(i + 1, j);
                int downRgb = templateImage.getRGB(i, j + 1);
                boolean bl = exists = rgb >= 0 && rightRgb < 0 || rgb < 0 && rightRgb >= 0 || rgb >= 0 && downRgb < 0 || rgb < 0 && downRgb >= 0;
                if (!exists) continue;
                newImage.setRGB(i, j, Color.white.getRGB());
                oriImage.setRGB(x + i, y + j, Color.white.getRGB());
            }
        }
    }

    private static void interferenceByTemplate(BufferedImage oriImage, BufferedImage templateImage, int x, int y) {
        int[][] martrix = new int[3][3];
        int[] values = new int[9];
        int xLength = templateImage.getWidth();
        int yLength = templateImage.getHeight();
        for (int i = 0; i < xLength; ++i) {
            for (int j = 0; j < yLength; ++j) {
                int rgb = templateImage.getRGB(i, j);
                if (rgb < 0) {
                    BlockPuzzleCaptchaServiceImpl.readPixel(oriImage, x + i, y + j, values);
                    BlockPuzzleCaptchaServiceImpl.fillMatrix(martrix, values);
                    oriImage.setRGB(x + i, y + j, BlockPuzzleCaptchaServiceImpl.avgMatrix(martrix));
                }
                if (i == xLength - 1 || j == yLength - 1) continue;
                int rightRgb = templateImage.getRGB(i + 1, j);
                int downRgb = templateImage.getRGB(i, j + 1);
                if (!(rgb >= 0 && rightRgb < 0 || rgb < 0 && rightRgb >= 0 || rgb >= 0 && downRgb < 0) && (rgb >= 0 || downRgb < 0)) continue;
                oriImage.setRGB(x + i, y + j, Color.white.getRGB());
            }
        }
    }

    private static void readPixel(BufferedImage img, int x, int y, int[] pixels) {
        int xStart = x - 1;
        int yStart = y - 1;
        int current = 0;
        for (int i = xStart; i < 3 + xStart; ++i) {
            for (int j = yStart; j < 3 + yStart; ++j) {
                int tx = i;
                if (tx < 0) {
                    tx = -tx;
                } else if (tx >= img.getWidth()) {
                    tx = x;
                }
                int ty = j;
                if (ty < 0) {
                    ty = -ty;
                } else if (ty >= img.getHeight()) {
                    ty = y;
                }
                pixels[current++] = img.getRGB(tx, ty);
            }
        }
    }

    private static void fillMatrix(int[][] matrix, int[] values) {
        int filled = 0;
        for (int[] x : matrix) {
            for (int j = 0; j < x.length; ++j) {
                x[j] = values[filled++];
            }
        }
    }

    private static int avgMatrix(int[][] matrix) {
        int r = 0;
        int g = 0;
        int b = 0;
        for (int[] x : matrix) {
            for (int j = 0; j < x.length; ++j) {
                if (j == 1) continue;
                Color c = new Color(x[j]);
                r += c.getRed();
                g += c.getGreen();
                b += c.getBlue();
            }
        }
        return new Color(r / 8, g / 8, b / 8).getRGB();
    }
}

