/*
 * Decompiled with CFR 0.152.
 */
package com.xingyuv.captcha.util;

import com.xingyuv.captcha.model.common.CaptchaBaseMapEnum;
import com.xingyuv.captcha.util.Base64Utils;
import com.xingyuv.captcha.util.FileCopyUtils;
import com.xingyuv.captcha.util.JsonUtil;
import com.xingyuv.captcha.util.RandomUtils;
import com.xingyuv.captcha.util.StringUtils;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageUtils {
    private static Logger logger = LoggerFactory.getLogger(ImageUtils.class);
    private static Map<String, String> originalRotateCacheMap = new ConcurrentHashMap<String, String>();
    private static Map<String, String> rotateBlockCacheMap = new ConcurrentHashMap<String, String>();
    private static Map<String, String> originalCacheMap = new ConcurrentHashMap<String, String>();
    private static Map<String, String> slidingBlockCacheMap = new ConcurrentHashMap<String, String>();
    private static Map<String, String> picClickCacheMap = new ConcurrentHashMap<String, String>();
    private static Map<String, String[]> fileNameMap = new ConcurrentHashMap<String, String[]>();

    public static void cacheImage(String captchaOriginalPathJigsaw, String captchaOriginalPathClick, String captchaOriginalPathRotate) {
        if (StringUtils.isBlank(captchaOriginalPathRotate)) {
            originalRotateCacheMap.putAll(ImageUtils.getResourcesImagesFile("defaultImages/rotate/original"));
            rotateBlockCacheMap.putAll(ImageUtils.getResourcesImagesFile("defaultImages/rotate/rotateBlock"));
        } else {
            originalRotateCacheMap.putAll(ImageUtils.getImagesFile(captchaOriginalPathRotate + File.separator + "original"));
            rotateBlockCacheMap.putAll(ImageUtils.getImagesFile(captchaOriginalPathRotate + File.separator + "rotateBlock"));
        }
        if (StringUtils.isBlank(captchaOriginalPathJigsaw)) {
            originalCacheMap.putAll(ImageUtils.getResourcesImagesFile("defaultImages/jigsaw/original"));
            slidingBlockCacheMap.putAll(ImageUtils.getResourcesImagesFile("defaultImages/jigsaw/slidingBlock"));
        } else {
            originalCacheMap.putAll(ImageUtils.getImagesFile(captchaOriginalPathJigsaw + File.separator + "original"));
            slidingBlockCacheMap.putAll(ImageUtils.getImagesFile(captchaOriginalPathJigsaw + File.separator + "slidingBlock"));
        }
        if (StringUtils.isBlank(captchaOriginalPathClick)) {
            picClickCacheMap.putAll(ImageUtils.getResourcesImagesFile("defaultImages/pic-click"));
        } else {
            picClickCacheMap.putAll(ImageUtils.getImagesFile(captchaOriginalPathClick));
        }
        fileNameMap.put(CaptchaBaseMapEnum.ORIGINAL.getCodeValue(), originalCacheMap.keySet().toArray(new String[0]));
        fileNameMap.put(CaptchaBaseMapEnum.SLIDING_BLOCK.getCodeValue(), slidingBlockCacheMap.keySet().toArray(new String[0]));
        fileNameMap.put(CaptchaBaseMapEnum.PIC_CLICK.getCodeValue(), picClickCacheMap.keySet().toArray(new String[0]));
        logger.info("\u521d\u59cb\u5316\u5e95\u56fe:{}", (Object)JsonUtil.toJSONString(fileNameMap));
    }

    public static void cacheBootImage(Map<String, String> originalMap, Map<String, String> slidingBlockMap, Map<String, String> picClickMap) {
        originalCacheMap.putAll(originalMap);
        slidingBlockCacheMap.putAll(slidingBlockMap);
        picClickCacheMap.putAll(picClickMap);
        fileNameMap.put(CaptchaBaseMapEnum.ORIGINAL.getCodeValue(), originalCacheMap.keySet().toArray(new String[0]));
        fileNameMap.put(CaptchaBaseMapEnum.SLIDING_BLOCK.getCodeValue(), slidingBlockCacheMap.keySet().toArray(new String[0]));
        fileNameMap.put(CaptchaBaseMapEnum.PIC_CLICK.getCodeValue(), picClickCacheMap.keySet().toArray(new String[0]));
        logger.debug("\u81ea\u5b9a\u4e49resource\u5e95\u56fe:{}", (Object)JsonUtil.toJSONString(fileNameMap));
    }

    public static BufferedImage getRotate() {
        String[] strings = fileNameMap.get(CaptchaBaseMapEnum.ROTATE.getCodeValue());
        if (null == strings || strings.length == 0) {
            return null;
        }
        Integer randomInt = RandomUtils.getRandomInt(0, strings.length);
        String s = originalRotateCacheMap.get(strings[randomInt]);
        return ImageUtils.getBase64StrToImage(s);
    }

    public static String getRotateBlock() {
        String[] strings = fileNameMap.get(CaptchaBaseMapEnum.ROTATE_BLOCK.getCodeValue());
        if (null == strings || strings.length == 0) {
            return null;
        }
        Integer randomInt = RandomUtils.getRandomInt(0, strings.length);
        String s = rotateBlockCacheMap.get(strings[randomInt]);
        return s;
    }

    public static BufferedImage getOriginal() {
        String[] strings = fileNameMap.get(CaptchaBaseMapEnum.ORIGINAL.getCodeValue());
        if (null == strings || strings.length == 0) {
            return null;
        }
        Integer randomInt = RandomUtils.getRandomInt(0, strings.length);
        String s = originalCacheMap.get(strings[randomInt]);
        return ImageUtils.getBase64StrToImage(s);
    }

    public static String getSlidingBlock() {
        String[] strings = fileNameMap.get(CaptchaBaseMapEnum.SLIDING_BLOCK.getCodeValue());
        if (null == strings || strings.length == 0) {
            return null;
        }
        Integer randomInt = RandomUtils.getRandomInt(0, strings.length);
        return slidingBlockCacheMap.get(strings[randomInt]);
    }

    public static BufferedImage getPicClick() {
        String[] strings = fileNameMap.get(CaptchaBaseMapEnum.PIC_CLICK.getCodeValue());
        if (null == strings || strings.length == 0) {
            return null;
        }
        Integer randomInt = RandomUtils.getRandomInt(0, strings.length);
        String s = picClickCacheMap.get(strings[randomInt]);
        return ImageUtils.getBase64StrToImage(s);
    }

    public static String getImageToBase64Str(BufferedImage templateImage) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)templateImage, "png", baos);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        byte[] bytes = baos.toByteArray();
        Base64.Encoder encoder = Base64.getEncoder();
        return encoder.encodeToString(bytes).trim();
    }

    public static BufferedImage getBase64StrToImage(String base64String) {
        try {
            Base64.Decoder decoder = Base64.getDecoder();
            byte[] bytes = decoder.decode(base64String);
            ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
            return ImageIO.read(inputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Map<String, String> getResourcesImagesFile(String path) {
        HashMap<String, String> imgMap = new HashMap<String, String>();
        ClassLoader classLoader = ImageUtils.class.getClassLoader();
        for (int i = 1; i <= 6; ++i) {
            InputStream resourceAsStream = classLoader.getResourceAsStream(path.concat("/").concat(String.valueOf(i).concat(".png")));
            byte[] bytes = new byte[]{};
            try {
                bytes = FileCopyUtils.copyToByteArray(resourceAsStream);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            String string = Base64Utils.encodeToString(bytes);
            String filename = String.valueOf(i).concat(".png");
            imgMap.put(filename, string);
        }
        return imgMap;
    }

    private static Map<String, String> getImagesFile(String path) {
        HashMap<String, String> imgMap = new HashMap<String, String>();
        File file = new File(path);
        if (!file.exists()) {
            return new HashMap<String, String>();
        }
        File[] files = file.listFiles();
        assert (files != null);
        Arrays.stream(files).forEach(item -> {
            try {
                FileInputStream fileInputStream = new FileInputStream((File)item);
                byte[] bytes = FileCopyUtils.copyToByteArray(fileInputStream);
                String string = Base64Utils.encodeToString(bytes);
                imgMap.put(item.getName(), string);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        return imgMap;
    }
}

