/*
 * Decompiled with CFR 0.152.
 */
package com.xingyuv.jushauth.request;

import com.alibaba.fastjson.JSONObject;
import com.xingyuv.jushauth.cache.AuthStateCache;
import com.xingyuv.jushauth.config.AuthConfig;
import com.xingyuv.jushauth.config.AuthSource;
import com.xingyuv.jushauth.enums.AuthResponseStatus;
import com.xingyuv.jushauth.enums.AuthUserGender;
import com.xingyuv.jushauth.exception.AuthException;
import com.xingyuv.jushauth.model.AuthCallback;
import com.xingyuv.jushauth.model.AuthToken;
import com.xingyuv.jushauth.model.AuthUser;
import com.xingyuv.jushauth.request.AuthDefaultRequest;
import com.xingyuv.jushauth.utils.HttpUtils;
import com.xingyuv.jushauth.utils.StringUtils;
import com.xingyuv.jushauth.utils.UrlBuilder;
import java.util.Map;

public abstract class AbstractAuthWeChatEnterpriseRequest
extends AuthDefaultRequest {
    public AbstractAuthWeChatEnterpriseRequest(AuthConfig config, AuthSource source) {
        super(config, source);
    }

    public AbstractAuthWeChatEnterpriseRequest(AuthConfig config, AuthSource source, AuthStateCache authStateCache) {
        super(config, source, authStateCache);
    }

    @Override
    protected AuthToken getAccessToken(AuthCallback authCallback) {
        String response = this.doGetAuthorizationCode(this.accessTokenUrl(null));
        JSONObject object = this.checkResponse(response);
        return AuthToken.builder().accessToken(object.getString("access_token")).expireIn(object.getIntValue("expires_in")).code(authCallback.getCode()).build();
    }

    @Override
    protected AuthUser getUserInfo(AuthToken authToken) {
        String response = this.doGetUserInfo(authToken);
        JSONObject object = this.checkResponse(response);
        if (!object.containsKey((Object)"UserId")) {
            throw new AuthException(AuthResponseStatus.UNIDENTIFIED_PLATFORM, this.source);
        }
        String userId = object.getString("UserId");
        String userTicket = object.getString("user_ticket");
        JSONObject userDetail = this.getUserDetail(authToken.getAccessToken(), userId, userTicket);
        return AuthUser.builder().rawUserInfo(userDetail).username(userDetail.getString("name")).nickname(userDetail.getString("alias")).avatar(userDetail.getString("avatar")).location(userDetail.getString("address")).email(userDetail.getString("email")).uuid(userId).gender(AuthUserGender.getWechatRealGender(userDetail.getString("gender"))).token(authToken).source(this.source.toString()).build();
    }

    private JSONObject checkResponse(String response) {
        JSONObject object = JSONObject.parseObject((String)response);
        if (object.containsKey((Object)"errcode") && object.getIntValue("errcode") != 0) {
            throw new AuthException(object.getString("errmsg"), this.source);
        }
        return object;
    }

    @Override
    protected String accessTokenUrl(String code) {
        return UrlBuilder.fromBaseUrl(this.source.accessToken()).queryParam("corpid", this.config.getClientId()).queryParam("corpsecret", this.config.getClientSecret()).build();
    }

    @Override
    protected String userInfoUrl(AuthToken authToken) {
        return UrlBuilder.fromBaseUrl(this.source.userInfo()).queryParam("access_token", authToken.getAccessToken()).queryParam("code", authToken.getCode()).build();
    }

    private JSONObject getUserDetail(String accessToken, String userId, String userTicket) {
        String userInfoUrl = UrlBuilder.fromBaseUrl("https://qyapi.weixin.qq.com/cgi-bin/user/get").queryParam("access_token", accessToken).queryParam("userid", userId).build();
        String userInfoResponse = new HttpUtils(this.config.getHttpConfig()).get(userInfoUrl).getBody();
        JSONObject userInfo = this.checkResponse(userInfoResponse);
        if (StringUtils.isNotEmpty(userTicket)) {
            String userDetailUrl = UrlBuilder.fromBaseUrl("https://qyapi.weixin.qq.com/cgi-bin/auth/getuserdetail").queryParam("access_token", accessToken).build();
            JSONObject param = new JSONObject();
            param.put("user_ticket", (Object)userTicket);
            String userDetailResponse = new HttpUtils(this.config.getHttpConfig()).post(userDetailUrl, param.toJSONString()).getBody();
            JSONObject userDetail = this.checkResponse(userDetailResponse);
            userInfo.putAll((Map)userDetail);
        }
        return userInfo;
    }
}

