/*
 * Decompiled with CFR 0.152.
 */
package com.xingyuv.jushauth.log;

import java.io.PrintStream;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

public class Log {
    public static void debug(String msg) {
        Log.debug(msg, null);
    }

    public static void warn(String msg) {
        Log.warn(msg, null);
    }

    public static void error(String msg) {
        Log.error(msg, null);
    }

    public static void debug(String msg, Throwable t) {
        Log.print(Level.DEBUG, msg, t, System.out);
    }

    public static void warn(String msg, Throwable t) {
        Log.print(Level.WARN, msg, t, System.out);
    }

    public static void error(String msg, Throwable t) {
        Log.print(Level.ERROR, msg, t, System.err);
    }

    private static void print(Level level, String msg, Throwable t, PrintStream ps) {
        if (Config.enable && level.getLevelNum() >= Config.level.getLevelNum()) {
            ps.printf("%s %s %s [%s] - %s%n", new Object[]{Log.getDate(), Thread.currentThread().getName(), Log.getCaller(), level, msg});
            Log.writeThrowable(t, ps);
            ps.flush();
        }
    }

    private static String getCaller() {
        int offset = 2;
        StackTraceElement[] stackTraceArr = new Throwable().getStackTrace();
        StackTraceElement stackTrace = null;
        if (offset >= stackTraceArr.length) {
            --offset;
        }
        stackTrace = stackTraceArr[offset];
        return stackTrace.getClassName() + "(" + stackTrace.getMethodName() + ":" + stackTrace.getLineNumber() + ")";
    }

    private static String getDate() {
        return LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
    }

    private static void writeThrowable(Throwable t, PrintStream targetStream) {
        if (t != null) {
            t.printStackTrace(targetStream);
        }
    }

    public static enum Level {
        DEBUG(10),
        WARN(30),
        ERROR(40);

        private int levelNum;

        public int getLevelNum() {
            return this.levelNum;
        }

        private Level(int levelNum) {
            this.levelNum = levelNum;
        }
    }

    public static class Config {
        public static Level level = Level.DEBUG;
        public static boolean enable = true;
    }
}

