/*
 * Decompiled with CFR 0.152.
 */
package com.xingyuv.jushauth.request;

import com.alibaba.fastjson.JSONObject;
import com.xingyuv.jushauth.cache.AuthStateCache;
import com.xingyuv.jushauth.config.AuthConfig;
import com.xingyuv.jushauth.config.AuthDefaultSource;
import com.xingyuv.jushauth.enums.AuthUserGender;
import com.xingyuv.jushauth.model.AuthCallback;
import com.xingyuv.jushauth.model.AuthToken;
import com.xingyuv.jushauth.model.AuthUser;
import com.xingyuv.jushauth.request.AuthDefaultRequest;

public class AuthAliyunRequest
extends AuthDefaultRequest {
    public AuthAliyunRequest(AuthConfig config) {
        super(config, AuthDefaultSource.ALIYUN);
    }

    public AuthAliyunRequest(AuthConfig config, AuthStateCache authStateCache) {
        super(config, AuthDefaultSource.ALIYUN, authStateCache);
    }

    @Override
    protected AuthToken getAccessToken(AuthCallback authCallback) {
        String response = this.doPostAuthorizationCode(authCallback.getCode());
        JSONObject accessTokenObject = JSONObject.parseObject((String)response);
        return AuthToken.builder().accessToken(accessTokenObject.getString("access_token")).expireIn(accessTokenObject.getIntValue("expires_in")).tokenType(accessTokenObject.getString("token_type")).idToken(accessTokenObject.getString("id_token")).refreshToken(accessTokenObject.getString("refresh_token")).build();
    }

    @Override
    protected AuthUser getUserInfo(AuthToken authToken) {
        String userInfo = this.doGetUserInfo(authToken);
        JSONObject object = JSONObject.parseObject((String)userInfo);
        return AuthUser.builder().rawUserInfo(object).uuid(object.getString("sub")).username(object.getString("login_name")).nickname(object.getString("name")).gender(AuthUserGender.UNKNOWN).token(authToken).source(this.source.toString()).build();
    }
}

